/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.provider.play26.run;

import com.google.code.play2.provider.api.Play2BuildError;
import com.google.code.play2.provider.api.Play2BuildFailure;
import com.google.code.play2.provider.api.Play2Builder;
import com.google.code.play2.provider.play26.run.CompilationException;
import com.google.code.play2.provider.play26.run.DelegatedResourcesClassLoader;
import com.google.code.play2.provider.play26.run.UnexpectedException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import play.core.BuildLink;

public class Reloader
implements BuildLink {
    private Play2Builder buildLink;
    private ClassLoader baseLoader;
    private File projectPath;
    private List<File> outputDirectories;
    private Map<String, String> devSettings;
    private volatile URLClassLoader currentApplicationClassLoader = null;
    private int classLoaderVersion = 0;

    public Reloader(Play2Builder buildLink, ClassLoader baseLoader, File projectPath, List<File> outputDirectories, Map<String, String> devSettings) {
        this.buildLink = buildLink;
        this.baseLoader = baseLoader;
        this.projectPath = projectPath;
        this.outputDirectories = outputDirectories;
        this.devSettings = devSettings;
    }

    public synchronized Object reload() {
        Object result = null;
        try {
            boolean reloadRequired = this.buildLink.build();
            if (reloadRequired) {
                int version = ++this.classLoaderVersion;
                String name = "ReloadableClassLoader(v" + version + ")";
                this.currentApplicationClassLoader = new DelegatedResourcesClassLoader(name, Reloader.toUrls(this.outputDirectories), this.baseLoader);
                result = this.currentApplicationClassLoader;
            }
        }
        catch (MalformedURLException e) {
            throw new UnexpectedException("Unexpected reloader exception", e);
        }
        catch (Play2BuildFailure e) {
            result = new CompilationException(e.getMessage(), e.line(), e.position(), e.source() != null ? e.source().getAbsolutePath() : null, e.input());
        }
        catch (Play2BuildError e) {
            result = new UnexpectedException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public Map<String, String> settings() {
        return this.devSettings;
    }

    public void forceReload() {
        this.buildLink.forceReload();
    }

    public Object[] findSource(String className, Integer line) {
        return this.buildLink.findSource(className, line);
    }

    public File projectPath() {
        return this.projectPath;
    }

    void close() {
        this.currentApplicationClassLoader = null;
    }

    URLClassLoader getClassLoader() {
        return this.currentApplicationClassLoader;
    }

    public static URL[] toUrls(List<File> cp) throws MalformedURLException {
        URL[] result = new URL[cp.size()];
        for (int i = 0; i < cp.size(); ++i) {
            File file = cp.get(i);
            result[i] = file.toURI().toURL();
        }
        return result;
    }
}

