/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.provider.play26;

import com.google.code.play2.provider.api.Play2TemplateCompiler;
import com.google.code.play2.provider.api.TemplateCompilationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import play.TemplateImports;
import play.twirl.compiler.TemplateCompilationError;
import play.twirl.compiler.TwirlCompiler;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.io.Codec;

public class Play26TemplateCompiler
implements Play2TemplateCompiler {
    private static final String[] templateExts = new String[]{"html", "txt", "xml", "js"};
    private static final String[] formatterTypes = new String[]{"play.twirl.api.HtmlFormat", "play.twirl.api.TxtFormat", "play.twirl.api.XmlFormat", "play.twirl.api.JavaScriptFormat"};
    private static final String[] constructorAnnotations = new String[]{"@javax.inject.Inject()"};
    private File sourceDirectory;
    private File outputDirectory;
    private List<String> additionalImports;

    public String getCustomOutputDirectoryName() {
        return "twirl";
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<String> getDefaultJavaImports() {
        return this.getDefaultImports(TemplateImports.minimalJavaTemplateImports);
    }

    public List<String> getDefaultScalaImports() {
        return this.getDefaultImports(TemplateImports.defaultScalaTemplateImports);
    }

    private List<String> getDefaultImports(List<String> playImports) {
        List twirlDefaultImports = JavaConverters.seqAsJavaList((Seq)TwirlCompiler.DefaultImports());
        ArrayList<String> defaultImports = new ArrayList<String>(twirlDefaultImports.size() + playImports.size());
        defaultImports.addAll(twirlDefaultImports);
        defaultImports.addAll(playImports);
        return Collections.unmodifiableList(defaultImports);
    }

    public void setAdditionalImports(List<String> additionalImports) {
        this.additionalImports = additionalImports;
    }

    public File compile(File templateFile) throws TemplateCompilationException {
        File result = null;
        String fileName = templateFile.getName();
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        int index = this.getTemplateExtIndex(ext);
        if (index >= 0) {
            String formatterType = formatterTypes[index];
            Seq<String> additionalImportsSeq = this.getAdditionalImports(ext);
            Seq constructorAnnotationsSeq = JavaConverters.asScalaBuffer(Arrays.asList(constructorAnnotations)).toSeq();
            try {
                Option resultOption = TwirlCompiler.compile((File)templateFile, (File)this.sourceDirectory, (File)this.outputDirectory, (String)formatterType, additionalImportsSeq, (Seq)constructorAnnotationsSeq, (Codec)Codec.apply((String)"UTF-8"), (boolean)false);
                result = resultOption.isDefined() ? (File)resultOption.get() : null;
            }
            catch (TemplateCompilationError e) {
                throw new TemplateCompilationException(e.source(), e.message(), e.line(), e.column());
            }
        }
        return result;
    }

    private int getTemplateExtIndex(String ext) {
        int result = -1;
        for (int i = 0; i < templateExts.length; ++i) {
            if (!templateExts[i].equals(ext)) continue;
            result = i;
            break;
        }
        return result;
    }

    private Seq<String> getAdditionalImports(String format) {
        ArrayList<String> formattedAdditionalImports = new ArrayList<String>(this.additionalImports.size());
        for (String additionalImport : this.additionalImports) {
            formattedAdditionalImports.add(additionalImport.replace("%format%", format));
        }
        return JavaConverters.asScalaBuffer(formattedAdditionalImports).toSeq();
    }
}

