/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.provider.play26;

import com.google.code.play2.provider.api.Play2DevServer;
import com.google.code.play2.provider.api.Play2Runner;
import com.google.code.play2.provider.api.Play2RunnerConfiguration;
import com.google.code.play2.provider.play26.run.AssetsClassLoader;
import com.google.code.play2.provider.play26.run.NamedURLClassLoader;
import com.google.code.play2.provider.play26.run.Reloader;
import com.google.code.play2.provider.play26.run.ReloaderApplicationClassLoaderProvider;
import com.google.code.play2.provider.play26.run.ReloaderPlayDevServer;
import com.google.code.play2.provider.play26.run.ServerStartException;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import play.core.Build;
import play.core.BuildLink;
import play.core.server.ReloadableServer;
import play.runsupport.classloader.DelegatingClassLoader;

public class Play26Runner
implements Play2Runner {
    private static final String DEV_SERVER_MAIN_CLASS = "play.core.server.DevServerStart";

    public String getServerMainClass() {
        return "play.core.server.ProdServerStart";
    }

    public boolean supportsRunInDevMode() {
        return true;
    }

    public String getPlayDocsModuleId(String scalaBinaryVersion, String playVersion) {
        return null;
    }

    public Play2DevServer runInDevMode(Play2RunnerConfiguration configuration) throws Throwable {
        ClassLoader buildLoader = Reloader.class.getClassLoader();
        ClassLoader commonClassLoader = this.commonClassLoader(configuration.getDependencyClasspath());
        ReloaderApplicationClassLoaderProvider applicationClassLoaderProvider = new ReloaderApplicationClassLoaderProvider();
        DelegatingClassLoader delegatingLoader = new DelegatingClassLoader(commonClassLoader, Build.sharedClasses, buildLoader, applicationClassLoaderProvider);
        NamedURLClassLoader applicationLoader = new NamedURLClassLoader("PlayDependencyClassLoader", Reloader.toUrls(configuration.getDependencyClasspath()), delegatingLoader);
        AssetsClassLoader assetsLoader = new AssetsClassLoader(applicationLoader, configuration.getAssetsPrefix(), configuration.getAssetsDirectory());
        Reloader reloader = new Reloader(configuration.getBuildLink(), assetsLoader, configuration.getBaseDirectory(), configuration.getOutputDirectories(), configuration.getDevSettings());
        applicationClassLoaderProvider.setReloader(reloader);
        try {
            Class<?> mainClass = applicationLoader.loadClass(DEV_SERVER_MAIN_CLASS);
            String mainMethod = configuration.getHttpPort() != null ? "mainDevHttpMode" : "mainDevOnlyHttpsMode";
            int port = configuration.getHttpPort() != null ? configuration.getHttpPort().intValue() : configuration.getHttpsPort().intValue();
            String httpAddress = configuration.getHttpAddress();
            Method mainDev = mainClass.getMethod(mainMethod, BuildLink.class, Integer.TYPE, String.class);
            ReloadableServer server = (ReloadableServer)mainDev.invoke(null, reloader, port, httpAddress);
            return new ReloaderPlayDevServer(server, reloader);
        }
        catch (Throwable t) {
            if ("play.core.server.ServerListenException".equals(this.getRootCause(t).getClass().getName())) {
                throw new ServerStartException(t);
            }
            throw t;
        }
    }

    private Throwable getRootCause(Throwable t) {
        return t.getCause() == null ? t : this.getRootCause(t.getCause());
    }

    private ClassLoader commonClassLoader(List<File> classpath) throws MalformedURLException {
        ArrayList<URL> commonClasspath = new ArrayList<URL>(1);
        for (File depFile : classpath) {
            String name = depFile.getName();
            if (!name.startsWith("h2-")) continue;
            commonClasspath.add(depFile.toURI().toURL());
        }
        ClassLoader parent = ClassLoader.getSystemClassLoader().getParent();
        return new URLClassLoader(commonClasspath.toArray(new URL[commonClasspath.size()]), parent);
    }
}

