/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.provider.play26;

import com.google.code.play2.provider.api.Play2RoutesCompiler;
import com.google.code.play2.provider.api.RoutesCompilationException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import play.routes.compiler.InjectedRoutesGenerator$;
import play.routes.compiler.RoutesCompilationError;
import play.routes.compiler.RoutesCompiler;
import play.routes.compiler.RoutesGenerator;
import play.routes.compiler.StaticRoutesGenerator$;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.util.Either;

public class Play26RoutesCompiler
implements Play2RoutesCompiler {
    private static final String[] javaAdditionalImports = new String[]{"controllers.Assets.Asset", "play.libs.F"};
    private static final String[] scalaAdditionalImports = new String[]{"controllers.Assets.Asset"};
    private static final String[] supportedGenerators = new String[]{"injected", "static"};
    private File outputDirectory;
    private String generator;
    private List<String> additionalImports;

    public String getCustomOutputDirectoryName() {
        return "routes";
    }

    public String getDefaultNamespace() {
        return "router";
    }

    public String getMainRoutesFileName() {
        return "Routes.scala";
    }

    public String[] getSupportedGenerators() {
        return supportedGenerators;
    }

    public List<String> getDefaultJavaImports() {
        return Arrays.asList(javaAdditionalImports);
    }

    public List<String> getDefaultScalaImports() {
        return Arrays.asList(scalaAdditionalImports);
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setGenerator(String generator) {
        if (Arrays.asList(supportedGenerators).contains(generator)) {
            this.generator = generator;
        }
    }

    public void setAdditionalImports(List<String> additionalImports) {
        this.additionalImports = additionalImports;
    }

    public void compile(File routesFile) throws RoutesCompilationException {
        RoutesCompiler.RoutesCompilerTask routesCompilerTask;
        Either result;
        InjectedRoutesGenerator$ routesGenerator = InjectedRoutesGenerator$.MODULE$;
        if ("static".equals(this.generator)) {
            routesGenerator = StaticRoutesGenerator$.MODULE$;
        }
        if ((result = RoutesCompiler.compile((RoutesCompiler.RoutesCompilerTask)(routesCompilerTask = new RoutesCompiler.RoutesCompilerTask(routesFile, (Seq)JavaConversions.asScalaBuffer(this.additionalImports), true, true, false)), (RoutesGenerator)routesGenerator, (File)this.outputDirectory)).isLeft()) {
            RoutesCompilationError e = (RoutesCompilationError)((Seq)result.left().get()).apply(0);
            throw new RoutesCompilationException(e.source(), e.message(), ((Integer)e.line().get()).intValue(), ((Integer)e.column().get()).intValue());
        }
    }
}

