/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.provider.play26;

import com.google.code.play2.provider.api.Play2EbeanEnhancer;
import io.ebean.enhance.Transformer;
import io.ebean.enhance.ant.StringReplace;
import io.ebean.enhance.common.InputStreamTransform;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Play26EbeanEnhancer
implements Play2EbeanEnhancer {
    private static final String configLoaderClassName = "play.db.ebean.ModelsConfigLoader";
    private File outputDirectory;
    private List<URL> classPathUrls;
    private InputStreamTransform inputStreamTransform;

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setClassPathUrls(List<URL> classPathUrls) {
        this.classPathUrls = classPathUrls;
        URL[] cp = classPathUrls.toArray(new URL[classPathUrls.size()]);
        URLClassLoader classLoader = new URLClassLoader(cp, null);
        Transformer transformer = new Transformer((ClassLoader)classLoader, "debug=-1");
        this.inputStreamTransform = new InputStreamTransform(transformer, (ClassLoader)classLoader);
    }

    public String getModelsToEnhance() {
        Map<String, List<String>> config = this.getConfig();
        if (!config.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>();
            for (List<String> modelsList : config.values()) {
                for (String models : modelsList) {
                    if (result.contains(models)) continue;
                    result.add(models);
                }
            }
            return String.join((CharSequence)",", result);
        }
        return "models.*";
    }

    private Map<String, List<String>> getConfig() {
        URL[] cp = this.classPathUrls.toArray(new URL[this.classPathUrls.size()]);
        URLClassLoader classLoader = new URLClassLoader(cp, null);
        try {
            Class<?> configLoaderClass = classLoader.loadClass(configLoaderClassName);
            Function configLoader = (Function)configLoaderClass.newInstance();
            Map map = (Map)configLoader.apply(classLoader);
            return map;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw this.cloneException(e);
        }
        finally {
            try {
                classLoader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private RuntimeException cloneException(Throwable t) {
        RuntimeException cloned = new RuntimeException(t.getClass().getName() + ": " + t.getMessage());
        cloned.setStackTrace(t.getStackTrace());
        if (t.getCause() != null) {
            cloned.initCause(this.cloneException(t.getCause()));
        }
        return cloned;
    }

    public boolean enhanceModel(File classFile) throws Exception {
        boolean processed = false;
        String className = this.getClassName(classFile);
        byte[] result = this.inputStreamTransform.transform(className, classFile);
        if (result != null) {
            InputStreamTransform.writeBytes((byte[])result, (File)classFile);
            processed = true;
        }
        return processed;
    }

    private String getClassName(File file) {
        String path = file.getPath();
        path = path.substring(this.outputDirectory.getAbsolutePath().length() + 1);
        path = path.substring(0, path.length() - ".class".length());
        return StringReplace.replace((String)path, (String)"\\", (String)"/");
    }
}

