/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.play2.provider.api;

import com.google.code.play2.provider.api.Play2BuildException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Play2BuildFailure
extends Exception {
    private static final long serialVersionUID = 1L;
    private Play2BuildException e;
    private String charsetName;

    public Play2BuildFailure(Play2BuildException e, String charsetName) {
        this.e = e;
        this.charsetName = charsetName;
    }

    @Override
    public String getMessage() {
        return this.filterAnnoyingErrorMessages(this.e.getMessage());
    }

    public int line() {
        return this.e.line();
    }

    public int position() {
        return this.e.position();
    }

    public File source() {
        return this.e.source();
    }

    public String input() {
        String result = null;
        File sourceFile = this.e.source();
        if (sourceFile != null) {
            try {
                result = this.readFileAsString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileAsString() throws IOException {
        FileInputStream is = new FileInputStream(this.e.source());
        try {
            byte[] buffer = new byte[8192];
            int len = is.read(buffer);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (len != -1) {
                out.write(buffer, 0, len);
                len = is.read(buffer);
            }
            String string = this.charsetName != null ? new String(out.toByteArray(), this.charsetName) : new String(out.toByteArray());
            return string;
        }
        finally {
            is.close();
        }
    }

    private String filterAnnoyingErrorMessages(String message) {
        String result = message;
        Pattern pattern = Pattern.compile("(?s)overloaded method value (.*) with alternatives:(.*)cannot be applied to(.*)");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            String method = matcher.group(1);
            String signature = matcher.group(3);
            result = String.format("Overloaded method value [%s] cannot be applied to %s", method, signature);
        }
        return result;
    }
}

