/*
 * Decompiled with CFR 0.152.
 */
package rat.report.xml;

import java.io.IOException;
import rat.document.IDocument;
import rat.document.IDocumentAnalyser;
import rat.document.RatDocumentAnalysisException;
import rat.report.RatReport;
import rat.report.RatReportFailedException;
import rat.report.xml.writer.IXmlWriter;

class XmlReport
implements RatReport {
    private final IDocumentAnalyser analyser;
    private final IXmlWriter writer;

    public XmlReport(IXmlWriter writer, IDocumentAnalyser analyser) {
        this.analyser = analyser;
        this.writer = writer;
    }

    public void startReport() throws RatReportFailedException {
        try {
            this.writer.openElement("rat-report");
        }
        catch (IOException e) {
            throw new RatReportFailedException("Cannot open start element", e);
        }
    }

    public void endReport() throws RatReportFailedException {
        try {
            this.writer.closeDocument();
        }
        catch (IOException e) {
            throw new RatReportFailedException("Cannot close last element", e);
        }
    }

    public void report(IDocument document) throws RatReportFailedException {
        try {
            this.analyser.analyse(document);
        }
        catch (RatDocumentAnalysisException e) {
            throw new RatReportFailedException("Analysis failed", (Throwable)((Object)e));
        }
    }
}

