/*
 * Decompiled with CFR 0.152.
 */
package rat.report.analyser;

import rat.document.IDocument;
import rat.document.IDocumentAnalyser;
import rat.document.RatDocumentAnalysisException;
import rat.report.RatReportFailedException;
import rat.report.analyser.RatReportAnalysisResultException;
import rat.report.claim.IClaimReporter;

public abstract class AbstractSingleClaimAnalyser
implements IDocumentAnalyser {
    private final IClaimReporter reporter;
    private final CharSequence predicate;
    private final boolean isLiteral;

    public AbstractSingleClaimAnalyser(IClaimReporter reporter, CharSequence predicate, boolean isLiteral) {
        this.reporter = reporter;
        this.predicate = predicate;
        this.isLiteral = isLiteral;
    }

    public void analyse(IDocument document) throws RatDocumentAnalysisException {
        String name = document.getName();
        try {
            CharSequence object = this.toObject(document);
            this.reporter.claim(name, this.predicate, object, this.isLiteral);
        }
        catch (RatReportFailedException e) {
            throw new RatReportAnalysisResultException(e);
        }
    }

    protected abstract CharSequence toObject(IDocument var1) throws RatDocumentAnalysisException;
}

