/*
 * Decompiled with CFR 0.152.
 */
package rat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.TransformerConfigurationException;
import rat.Defaults;
import rat.DirectoryWalker;
import rat.ReportTransformer;
import rat.analysis.IHeaderMatcher;
import rat.license.ILicenseFamily;
import rat.report.IReportable;
import rat.report.RatReport;
import rat.report.RatReportFailedException;
import rat.report.xml.XmlReportFactory;
import rat.report.xml.writer.impl.base.XmlWriter;

public class Report {
    private final String baseDirectory;

    public static final void main(String[] args) throws Exception {
        if (args == null || args.length != 1) {
            Report.printUsage();
        } else {
            Report report = new Report(args[0]);
            report.styleReport(System.out);
        }
    }

    private static final void printUsage() {
        System.out.println("Usage: <directory>");
        System.out.println("       where ");
        System.out.println("<directory> is the base directory to be audited.");
        System.out.println("NOTE: RAT is really little more than a grep ATM");
        System.out.println("      RAT is also rather memory hungry ATM");
        System.out.println("      RAT is very basic ATM");
        System.out.println("      RAT ATM runs on unpacked releases");
        System.out.println("      RAT highlights possible issues");
        System.out.println("      RAT reports require intepretation");
        System.out.println("      RAT often requires some tuning before it runs well against a project");
        System.out.println("      RAT relies on heuristics: it may miss issues");
    }

    private Report(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void report(PrintStream out) throws Exception {
        DirectoryWalker base = this.getDirectory(out);
        if (base != null) {
            Report.report(base, new OutputStreamWriter(out), Defaults.createDefaultMatcher(), null);
        }
    }

    private DirectoryWalker getDirectory(PrintStream out) {
        DirectoryWalker result = null;
        File base = new File(this.baseDirectory);
        if (!base.exists()) {
            out.print("ERROR: ");
            out.print(this.baseDirectory);
            out.print(" does not exist.\n");
        } else if (!base.isDirectory()) {
            out.print("ERROR: ");
            out.print(this.baseDirectory);
            out.print(" must be a directory.\n");
        } else {
            result = new DirectoryWalker(base);
        }
        return result;
    }

    public void styleReport(PrintStream out) throws Exception {
        DirectoryWalker base = this.getDirectory(out);
        if (base != null) {
            InputStream style = Defaults.getDefaultStyleSheet();
            Report.report(out, (IReportable)base, style, Defaults.createDefaultMatcher(), null);
        }
    }

    public static void report(PrintStream out, IReportable base, InputStream style, IHeaderMatcher matcher, ILicenseFamily[] approvedLicenseNames) throws IOException, TransformerConfigurationException, InterruptedException, RatReportFailedException {
        Report.report(new OutputStreamWriter(out), base, style, matcher, approvedLicenseNames);
    }

    public static void report(Writer out, IReportable base, InputStream style, IHeaderMatcher matcher, ILicenseFamily[] approvedLicenseNames) throws IOException, TransformerConfigurationException, FileNotFoundException, InterruptedException, RatReportFailedException {
        PipedReader reader = new PipedReader();
        PipedWriter writer = new PipedWriter(reader);
        ReportTransformer transformer = new ReportTransformer(out, style, (Reader)reader);
        Thread transformerThread = new Thread(transformer);
        transformerThread.start();
        Report.report(base, writer, matcher, approvedLicenseNames);
        writer.flush();
        writer.close();
        transformerThread.join();
    }

    public static void report(IReportable container, Writer out, IHeaderMatcher matcher, ILicenseFamily[] approvedLicenseNames) throws IOException, RatReportFailedException {
        XmlWriter writer = new XmlWriter(out);
        RatReport report = XmlReportFactory.createStandardReport(writer, matcher, approvedLicenseNames);
        report.startReport();
        container.run(report);
        report.endReport();
        writer.closeDocument();
    }
}

