/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import com.google.code.maven_replacer_plugin.DelimiterBuilder;
import com.google.code.maven_replacer_plugin.OutputFilenameBuilder;
import com.google.code.maven_replacer_plugin.PatternFlagsFactory;
import com.google.code.maven_replacer_plugin.Replacement;
import com.google.code.maven_replacer_plugin.ReplacementProcessor;
import com.google.code.maven_replacer_plugin.ReplacerFactory;
import com.google.code.maven_replacer_plugin.SummaryBuilder;
import com.google.code.maven_replacer_plugin.TokenValueMapFactory;
import com.google.code.maven_replacer_plugin.file.FileUtils;
import com.google.code.maven_replacer_plugin.include.FileSelector;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplacerMojo
extends AbstractMojo {
    private static final String INVALID_IGNORE_MISSING_FILE_MESSAGE = "<ignoreMissingFile> only useable with <file>";
    private static final String REGEX_PATTERN_WITH_DELIMITERS_MESSAGE = "Error: %s. Check that your delimiters do not contain regex characters. (e.g. '$'). Either remove the regex characters from your delimiters or set <regex>false</regex> in your configuration.";
    private final FileUtils fileUtils;
    private final ReplacerFactory replacerFactory;
    private final TokenValueMapFactory tokenValueMapFactory;
    private final FileSelector fileSelector;
    private final PatternFlagsFactory patternFlagsFactory;
    private final OutputFilenameBuilder outputFilenameBuilder;
    private final SummaryBuilder summaryBuilder;
    private final ReplacementProcessor processor;
    private String file;
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private String filesToInclude;
    private String filesToExclude;
    private String token;
    private String tokenFile;
    private boolean ignoreMissingFile;
    private String value;
    private String valueFile;
    private boolean regex = true;
    private String outputFile;
    private String outputDir;
    private String tokenValueMap;
    private String basedir = ".";
    private List<String> regexFlags;
    private List<Replacement> replacements;
    private boolean commentsEnabled = true;
    private String outputBasedir;
    private boolean preserveDir = true;
    private boolean quiet = false;
    private boolean unescape;
    private List<String> delimiters = new ArrayList<String>();
    private String variableTokenValueMap;
    private boolean ignoreErrors;
    private String xpath;
    private String encoding;
    private String inputFilePattern;
    private String outputFilePattern;

    public ReplacerMojo() {
        this.fileUtils = new FileUtils();
        this.replacerFactory = new ReplacerFactory();
        this.tokenValueMapFactory = new TokenValueMapFactory(this.fileUtils);
        this.fileSelector = new FileSelector();
        this.patternFlagsFactory = new PatternFlagsFactory();
        this.outputFilenameBuilder = new OutputFilenameBuilder();
        this.summaryBuilder = new SummaryBuilder();
        this.processor = new ReplacementProcessor(this.fileUtils, this.replacerFactory);
    }

    public ReplacerMojo(FileUtils fileUtils, ReplacementProcessor processor, ReplacerFactory replacerFactory, TokenValueMapFactory tokenValueMapFactory, FileSelector fileSelector, PatternFlagsFactory patternFlagsFactory, OutputFilenameBuilder outputFilenameBuilder, SummaryBuilder summaryBuilder) {
        this.fileUtils = fileUtils;
        this.processor = processor;
        this.replacerFactory = replacerFactory;
        this.tokenValueMapFactory = tokenValueMapFactory;
        this.fileSelector = fileSelector;
        this.patternFlagsFactory = patternFlagsFactory;
        this.outputFilenameBuilder = outputFilenameBuilder;
        this.summaryBuilder = summaryBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        try {
            if (this.checkFileExists()) {
                this.getLog().info((CharSequence)"Ignoring missing file");
                return;
            }
            List<Replacement> replacements = this.getDelimiterReplacements(this.buildReplacements());
            this.addIncludesFilesAndExcludedFiles();
            if (this.includes.isEmpty()) {
                this.replaceContents(this.processor, replacements, this.file);
                return;
            }
            for (String file : this.fileSelector.listIncludes(this.basedir, this.includes, this.excludes)) {
                this.replaceContents(this.processor, replacements, file);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage());
            if (!this.isIgnoreErrors()) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        finally {
            if (!this.quiet) {
                this.summaryBuilder.print(this.getLog());
            }
        }
    }

    private boolean checkFileExists() throws MojoExecutionException {
        if (this.ignoreMissingFile && this.file == null) {
            this.getLog().error((CharSequence)INVALID_IGNORE_MISSING_FILE_MESSAGE);
            throw new MojoExecutionException(INVALID_IGNORE_MISSING_FILE_MESSAGE);
        }
        return this.ignoreMissingFile && this.fileUtils.fileNotExists(this.getBaseDirPrefixedFilename(this.file));
    }

    private String getBaseDirPrefixedFilename(String file) {
        if (StringUtils.isEmpty((String)this.basedir)) {
            return file;
        }
        return this.basedir + File.separator + file;
    }

    private void addIncludesFilesAndExcludedFiles() {
        String[] splitFiles;
        if (this.filesToInclude != null) {
            splitFiles = this.filesToInclude.split(",");
            this.addToList(Arrays.asList(splitFiles), this.includes);
        }
        if (this.filesToExclude != null) {
            splitFiles = this.filesToExclude.split(",");
            this.addToList(Arrays.asList(splitFiles), this.excludes);
        }
    }

    private void addToList(List<String> toAdds, List<String> destination) {
        for (String toAdd : toAdds) {
            destination.add(toAdd.trim());
        }
    }

    private void replaceContents(ReplacementProcessor processor, List<Replacement> replacements, String inputFile) throws IOException {
        String outputFileName;
        block2: {
            outputFileName = this.outputFilenameBuilder.buildFrom(inputFile, this);
            try {
                processor.replace(replacements, this.regex, this.getBaseDirPrefixedFilename(inputFile), outputFileName, this.patternFlagsFactory.buildFlags(this.regexFlags), this.encoding);
            }
            catch (PatternSyntaxException e) {
                if (this.delimiters.isEmpty()) break block2;
                this.getLog().error((CharSequence)String.format(REGEX_PATTERN_WITH_DELIMITERS_MESSAGE, e.getMessage()));
                throw e;
            }
        }
        this.summaryBuilder.add(this.getBaseDirPrefixedFilename(inputFile), outputFileName, this.encoding, this.getLog());
    }

    private List<Replacement> buildReplacements() throws IOException {
        if (this.replacements != null) {
            return this.replacements;
        }
        if (this.variableTokenValueMap != null) {
            return this.tokenValueMapFactory.replacementsForVariable(this.variableTokenValueMap, this.isCommentsEnabled(), this.unescape, this.encoding);
        }
        if (this.tokenValueMap == null) {
            Replacement replacement = new Replacement(this.fileUtils, this.token, this.value, this.unescape, this.xpath, this.encoding);
            replacement.setEncoding(this.encoding);
            replacement.setTokenFile(this.tokenFile);
            replacement.setValueFile(this.valueFile);
            return Arrays.asList(replacement);
        }
        String tokenValueMapFile = this.getBaseDirPrefixedFilename(this.tokenValueMap);
        if (this.fileUtils.fileNotExists(tokenValueMapFile)) {
            this.getLog().info((CharSequence)("'" + tokenValueMapFile + "' does not exist and assuming this is an absolute file name."));
            tokenValueMapFile = this.tokenValueMap;
        }
        return this.tokenValueMapFactory.replacementsForFile(tokenValueMapFile, this.isCommentsEnabled(), this.unescape, this.encoding);
    }

    private List<Replacement> getDelimiterReplacements(List<Replacement> replacements) {
        if (this.delimiters.isEmpty()) {
            return replacements;
        }
        ArrayList<Replacement> newReplacements = new ArrayList<Replacement>();
        for (Replacement replacement : replacements) {
            for (DelimiterBuilder delimiter : this.buildDelimiters()) {
                Replacement withDelimiter = Replacement.from(replacement).withDelimiter(delimiter);
                newReplacements.add(withDelimiter);
            }
        }
        return newReplacements;
    }

    private List<DelimiterBuilder> buildDelimiters() {
        ArrayList<DelimiterBuilder> built = new ArrayList<DelimiterBuilder>();
        for (String delimiter : this.delimiters) {
            built.add(new DelimiterBuilder(delimiter));
        }
        return built;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
    }

    public void setValueFile(String valueFile) {
        this.valueFile = valueFile;
    }

    public void setIgnoreMissingFile(boolean ignoreMissingFile) {
        this.ignoreMissingFile = ignoreMissingFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setTokenValueMap(String tokenValueMap) {
        this.tokenValueMap = tokenValueMap;
    }

    public void setFilesToInclude(String filesToInclude) {
        this.filesToInclude = filesToInclude;
    }

    public void setFilesToExclude(String filesToExclude) {
        this.filesToExclude = filesToExclude;
    }

    public void setBasedir(String baseDir) {
        this.basedir = baseDir;
    }

    public void setReplacements(List<Replacement> replacements) {
        this.replacements = replacements;
    }

    public void setRegexFlags(List<String> regexFlags) {
        this.regexFlags = regexFlags;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public String getFilesToInclude() {
        return this.filesToInclude;
    }

    public String getFilesToExclude() {
        return this.filesToExclude;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public boolean isCommentsEnabled() {
        return this.commentsEnabled;
    }

    public void setCommentsEnabled(boolean commentsEnabled) {
        this.commentsEnabled = commentsEnabled;
    }

    public void setOutputBasedir(String outputBasedir) {
        this.outputBasedir = outputBasedir;
    }

    public boolean isPreserveDir() {
        return this.preserveDir;
    }

    public void setPreserveDir(boolean preserveDir) {
        this.preserveDir = preserveDir;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getOutputBasedir() {
        return this.outputBasedir;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setDelimiters(List<String> delimiters) {
        this.delimiters = delimiters;
    }

    public List<String> getDelimiters() {
        return this.delimiters;
    }

    public void setUnescape(boolean unescape) {
        this.unescape = unescape;
    }

    public boolean isUnescape() {
        return this.unescape;
    }

    public void setVariableTokenValueMap(String variableTokenValueMap) {
        this.variableTokenValueMap = variableTokenValueMap;
    }

    public String getVariableTokenValueMap() {
        return this.variableTokenValueMap;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setInputFilePattern(String inputFilePattern) {
        this.inputFilePattern = inputFilePattern;
    }

    public void setOutputFilePattern(String outputFilePattern) {
        this.outputFilePattern = outputFilePattern;
    }

    public String getInputFilePattern() {
        return this.inputFilePattern;
    }

    public String getOutputFilePattern() {
        return this.outputFilePattern;
    }
}

