/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.PrimitiveArrays;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MultisetSerializedForm<E>
implements Serializable {
    private final Object[] elements;
    private final int[] counts;
    private static final long serialVersionUID = 0L;

    protected MultisetSerializedForm(Multiset<E> multiset) {
        int entryCount = multiset.entrySet().size();
        ArrayList<E> elementList = Lists.newArrayListWithExpectedSize(entryCount);
        ArrayList<Integer> countList = Lists.newArrayListWithExpectedSize(entryCount);
        for (Multiset.Entry<E> entry : multiset.entrySet()) {
            elementList.add(entry.getElement());
            countList.add(entry.getCount());
        }
        this.elements = elementList.toArray();
        this.counts = PrimitiveArrays.toIntArray(countList);
    }

    protected abstract Multiset<E> createEmpty();

    protected Object readResolve() {
        Multiset<E> multiset = this.createEmpty();
        this.populate(multiset);
        return multiset;
    }

    private void populate(Multiset<E> multiset) {
        for (int i = 0; i < this.elements.length; ++i) {
            multiset.add(this.elements[i], this.counts[i]);
        }
    }

    protected int elementCount() {
        return this.elements.length;
    }
}

