/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractMultisetEntry;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkedListMultimap<K, V>
implements ListMultimap<K, V>,
Serializable {
    private Node<K, V> head;
    private Node<K, V> tail;
    private Multiset<K> keyCount;
    private Map<K, Node<K, V>> keyToKeyHead;
    private Map<K, Node<K, V>> keyToKeyTail;
    private volatile transient Set<K> keySet;
    private volatile transient Multiset<K> keys;
    private volatile transient Collection<V> valuesCollection;
    private volatile transient Collection<Map.Entry<K, V>> entries;
    private volatile transient Map<K, Collection<V>> map;
    private static final long serialVersionUID = -2456602590668068301L;

    public LinkedListMultimap() {
        this.clear();
    }

    public LinkedListMultimap(Multimap<? extends K, ? extends V> multimap) {
        int keySize = multimap.keySet().size();
        this.keyCount = new HashMultiset<K>(keySize);
        this.keyToKeyHead = Maps.newHashMapWithExpectedSize(keySize);
        this.keyToKeyTail = Maps.newHashMapWithExpectedSize(keySize);
        this.putAll(multimap);
    }

    private Node<K, V> addNode(@Nullable K key, @Nullable V value, @Nullable Node<K, V> nextSibling) {
        Node<K, V> node = new Node<K, V>(key, value);
        if (this.head == null) {
            this.tail = node;
            this.head = this.tail;
            this.keyToKeyHead.put(key, node);
            this.keyToKeyTail.put(key, node);
        } else if (nextSibling == null) {
            this.tail.next = node;
            node.previous = this.tail;
            Node<K, V> keyTail = this.keyToKeyTail.get(key);
            if (keyTail == null) {
                this.keyToKeyHead.put(key, node);
            } else {
                keyTail.nextSibling = node;
                node.previousSibling = keyTail;
            }
            this.keyToKeyTail.put(key, node);
            this.tail = node;
        } else {
            node.previous = nextSibling.previous;
            node.previousSibling = nextSibling.previousSibling;
            node.next = nextSibling;
            node.nextSibling = nextSibling;
            if (nextSibling.previousSibling == null) {
                this.keyToKeyHead.put(key, node);
            } else {
                nextSibling.previousSibling.nextSibling = node;
            }
            if (nextSibling.previous == null) {
                this.head = node;
            } else {
                nextSibling.previous.next = node;
            }
            nextSibling.previous = node;
            nextSibling.previousSibling = node;
        }
        this.keyCount.add(key);
        return node;
    }

    private void removeNode(Node<K, V> node) {
        if (node.previous != null) {
            node.previous.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.previous = node.previous;
        } else {
            this.tail = node.previous;
        }
        if (node.previousSibling != null) {
            node.previousSibling.nextSibling = node.nextSibling;
        } else if (node.nextSibling != null) {
            this.keyToKeyHead.put(node.key, node.nextSibling);
        } else {
            this.keyToKeyHead.remove(node.key);
        }
        if (node.nextSibling != null) {
            node.nextSibling.previousSibling = node.previousSibling;
        } else if (node.previousSibling != null) {
            this.keyToKeyTail.put(node.key, node.previousSibling);
        } else {
            this.keyToKeyTail.remove(node.key);
        }
        this.keyCount.remove(node.key);
    }

    private void removeAllNodes(@Nullable Object key) {
        ValueForKeyIterator i = new ValueForKeyIterator(key);
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    private static void checkElement(@Nullable Object node) {
        if (node == null) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int size() {
        return this.keyCount.size();
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.keyToKeyHead.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        NodeIterator i = new NodeIterator();
        while (i.hasNext()) {
            if (!Objects.equal(((Node)i.next()).value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        ValueForKeyIterator i = new ValueForKeyIterator(key);
        while (i.hasNext()) {
            if (!Objects.equal(i.next(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean put(@Nullable K key, @Nullable V value) {
        this.addNode(key, value, null);
        return true;
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        ValueForKeyIterator values = new ValueForKeyIterator(key);
        while (values.hasNext()) {
            if (!Objects.equal(values.next(), value)) continue;
            values.remove();
            return true;
        }
        return false;
    }

    @Override
    public void putAll(@Nullable K key, Iterable<? extends V> values) {
        for (V value : values) {
            this.addNode(key, value, null);
        }
    }

    @Override
    public void putAll(Multimap<? extends K, ? extends V> multimap) {
        for (Map.Entry<K, V> entry : multimap.entries()) {
            this.addNode(entry.getKey(), entry.getValue(), null);
        }
    }

    @Override
    public List<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
        List<V> oldValues = this.getCopy(key);
        ValueForKeyIterator keyValues = new ValueForKeyIterator(key);
        Iterator<V> newValues = values.iterator();
        while (keyValues.hasNext() && newValues.hasNext()) {
            keyValues.next();
            keyValues.set(newValues.next());
        }
        while (keyValues.hasNext()) {
            keyValues.next();
            keyValues.remove();
        }
        while (newValues.hasNext()) {
            keyValues.add(newValues.next());
        }
        return oldValues;
    }

    private List<V> getCopy(@Nullable Object key) {
        return Lists.newArrayList(new ValueForKeyIterator(key));
    }

    @Override
    public List<V> removeAll(@Nullable Object key) {
        List<V> oldValues = this.getCopy(key);
        this.removeAllNodes(key);
        return oldValues;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.keyCount = Multisets.newHashMultiset();
        this.keyToKeyHead = Maps.newHashMap();
        this.keyToKeyTail = Maps.newHashMap();
    }

    @Override
    public List<V> get(final @Nullable K key) {
        return new AbstractSequentialList<V>(){

            @Override
            public int size() {
                return LinkedListMultimap.this.keyCount.count(key);
            }

            @Override
            public ListIterator<V> listIterator(int index) {
                return new ValueForKeyIterator(key, index);
            }
        };
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.elementSet().size();
                }

                @Override
                public Iterator<K> iterator() {
                    return new DistinctKeyIterator();
                }

                @Override
                public boolean contains(Object key) {
                    return LinkedListMultimap.this.keyCount.contains(key);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Multiset<K> keys() {
        if (this.keys == null) {
            this.keys = new MultisetView();
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.size();
                }

                @Override
                public Iterator<V> iterator() {
                    final NodeIterator nodes = new NodeIterator();
                    return new Iterator<V>(){

                        @Override
                        public boolean hasNext() {
                            return nodes.hasNext();
                        }

                        @Override
                        public V next() {
                            return ((Node)nodes.next()).value;
                        }

                        @Override
                        public void remove() {
                            nodes.remove();
                        }
                    };
                }
            };
        }
        return this.valuesCollection;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        if (this.entries == null) {
            this.entries = new AbstractCollection<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.size();
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    final NodeIterator nodes = new NodeIterator();
                    return new Iterator<Map.Entry<K, V>>(){

                        @Override
                        public boolean hasNext() {
                            return nodes.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            final Node node = (Node)nodes.next();
                            return new AbstractMapEntry<K, V>(){

                                @Override
                                public K getKey() {
                                    return node.key;
                                }

                                @Override
                                public V getValue() {
                                    return node.value;
                                }

                                @Override
                                public V setValue(V value) {
                                    Object oldValue = node.value;
                                    node.value = value;
                                    return oldValue;
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            nodes.remove();
                        }
                    };
                }
            };
        }
        return this.entries;
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        if (this.map == null) {
            this.map = new AbstractMap<K, Collection<V>>(){
                volatile Set<Map.Entry<K, Collection<V>>> entrySet;

                @Override
                public Set<Map.Entry<K, Collection<V>>> entrySet() {
                    if (this.entrySet == null) {
                        this.entrySet = new AsMapEntries();
                    }
                    return this.entrySet;
                }

                @Override
                public boolean containsKey(@Nullable Object key) {
                    return LinkedListMultimap.this.containsKey(key);
                }

                @Override
                public Collection<V> get(@Nullable Object key) {
                    Collection collection = LinkedListMultimap.this.get(key);
                    return collection.isEmpty() ? null : collection;
                }

                @Override
                public Collection<V> remove(@Nullable Object key) {
                    Collection collection = LinkedListMultimap.this.removeAll(key);
                    return collection.isEmpty() ? null : collection;
                }
            };
        }
        return this.map;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Multimap)) {
            return false;
        }
        return ((Object)this.asMap()).equals(((Multimap)other).asMap());
    }

    @Override
    public int hashCode() {
        return ((Object)this.asMap()).hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsMapEntries
    extends AbstractSet<Map.Entry<K, Collection<V>>> {
        private AsMapEntries() {
        }

        @Override
        public int size() {
            return LinkedListMultimap.this.keyCount.elementSet().size();
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            final DistinctKeyIterator keyIterator = new DistinctKeyIterator();
            return new Iterator<Map.Entry<K, Collection<V>>>(){

                @Override
                public boolean hasNext() {
                    return keyIterator.hasNext();
                }

                @Override
                public Map.Entry<K, Collection<V>> next() {
                    final Object key = keyIterator.next();
                    return new AbstractMapEntry<K, Collection<V>>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public Collection<V> getValue() {
                            return LinkedListMultimap.this.get(key);
                        }
                    };
                }

                @Override
                public void remove() {
                    keyIterator.remove();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetView
    extends AbstractCollection<K>
    implements Multiset<K> {
        private MultisetView() {
        }

        @Override
        public int size() {
            return LinkedListMultimap.this.keyCount.size();
        }

        @Override
        public Iterator<K> iterator() {
            final NodeIterator nodes = new NodeIterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return nodes.hasNext();
                }

                @Override
                public K next() {
                    return ((Node)nodes.next()).key;
                }

                @Override
                public void remove() {
                    nodes.remove();
                }
            };
        }

        @Override
        public int count(@Nullable Object key) {
            return LinkedListMultimap.this.keyCount.count(key);
        }

        @Override
        public boolean add(@Nullable K key, int occurrences) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(@Nullable Object key, int occurrences) {
            Preconditions.checkArgument(occurrences >= 0);
            ValueForKeyIterator values = new ValueForKeyIterator(key);
            int removed = 0;
            while (occurrences-- > 0 && values.hasNext()) {
                values.next();
                values.remove();
                ++removed;
            }
            return removed;
        }

        @Override
        public int removeAllOccurrences(@Nullable Object key) {
            return LinkedListMultimap.this.removeAll(key).size();
        }

        @Override
        public Set<K> elementSet() {
            return LinkedListMultimap.this.keySet();
        }

        @Override
        public Set<Multiset.Entry<K>> entrySet() {
            return new AbstractSet<Multiset.Entry<K>>(){

                @Override
                public int size() {
                    return LinkedListMultimap.this.keyCount.elementSet().size();
                }

                @Override
                public Iterator<Multiset.Entry<K>> iterator() {
                    final DistinctKeyIterator keyIterator = new DistinctKeyIterator();
                    return new Iterator<Multiset.Entry<K>>(){

                        @Override
                        public boolean hasNext() {
                            return keyIterator.hasNext();
                        }

                        @Override
                        public Multiset.Entry<K> next() {
                            final Object key = keyIterator.next();
                            return new AbstractMultisetEntry<K>(){

                                @Override
                                public K getElement() {
                                    return key;
                                }

                                @Override
                                public int getCount() {
                                    return LinkedListMultimap.this.keyCount.count(key);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            keyIterator.remove();
                        }
                    };
                }
            };
        }

        @Override
        public boolean equals(@Nullable Object o) {
            return ((Object)LinkedListMultimap.this.keyCount).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)LinkedListMultimap.this.keyCount).hashCode();
        }

        @Override
        public String toString() {
            return ((Object)LinkedListMultimap.this.keyCount).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueForKeyIterator
    implements ListIterator<V> {
        final Object key;
        int nextIndex;
        Node<K, V> next;
        Node<K, V> current;
        Node<K, V> previous;

        ValueForKeyIterator(Object key) {
            this.key = key;
            this.next = (Node)LinkedListMultimap.this.keyToKeyHead.get(key);
        }

        public ValueForKeyIterator(Object key, int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index too small");
            }
            int size = LinkedListMultimap.this.keyCount.count(key);
            if (index > size) {
                throw new IndexOutOfBoundsException("index too large");
            }
            if (index >= size / 2) {
                this.previous = (Node)LinkedListMultimap.this.keyToKeyTail.get(key);
                this.nextIndex = size;
                while (index++ < size) {
                    this.previous();
                }
            } else {
                this.next = (Node)LinkedListMultimap.this.keyToKeyHead.get(key);
                while (index-- > 0) {
                    this.next();
                }
            }
            this.key = key;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            LinkedListMultimap.checkElement(this.next);
            this.current = this.next;
            this.previous = this.current;
            this.next = this.next.nextSibling;
            ++this.nextIndex;
            return this.current.value;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        @Override
        public V previous() {
            LinkedListMultimap.checkElement(this.previous);
            this.current = this.previous;
            this.next = this.current;
            this.previous = this.previous.previousSibling;
            --this.nextIndex;
            return this.current.value;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null);
            if (this.current != this.next) {
                this.previous = this.current.previousSibling;
                --this.nextIndex;
            } else {
                this.next = this.current.nextSibling;
            }
            LinkedListMultimap.this.removeNode(this.current);
            this.current = null;
        }

        @Override
        public void set(V value) {
            Preconditions.checkState(this.current != null);
            this.current.value = value;
        }

        @Override
        public void add(V value) {
            this.previous = LinkedListMultimap.this.addNode(this.key, value, this.next);
            ++this.nextIndex;
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistinctKeyIterator
    implements Iterator<K> {
        final Set<K> seenKeys;
        Node<K, V> next;
        Node<K, V> current;

        private DistinctKeyIterator() {
            this.seenKeys = new HashSet(Maps.capacity(LinkedListMultimap.this.keySet().size()));
            this.next = LinkedListMultimap.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public K next() {
            LinkedListMultimap.checkElement(this.next);
            this.current = this.next;
            this.seenKeys.add(this.current.key);
            do {
                this.next = this.next.next;
            } while (this.next != null && !this.seenKeys.add(this.next.key));
            return this.current.key;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null);
            LinkedListMultimap.this.removeAllNodes(this.current.key);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeIterator
    implements Iterator<Node<K, V>> {
        Node<K, V> next;
        Node<K, V> current;

        private NodeIterator() {
            this.next = LinkedListMultimap.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Node<K, V> next() {
            LinkedListMultimap.checkElement(this.next);
            this.current = this.next;
            this.next = this.next.next;
            return this.current;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null);
            LinkedListMultimap.this.removeNode(this.current);
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node<K, V>
    implements Serializable {
        final K key;
        V value;
        Node<K, V> next;
        Node<K, V> previous;
        Node<K, V> nextSibling;
        Node<K, V> previousSibling;
        private static final long serialVersionUID = 1620110227870214382L;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

