/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle.extension.ownership;

import com.google.cloud.tools.jib.api.buildplan.ContainerBuildPlan;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.gradle.extension.GradleData;
import com.google.cloud.tools.jib.gradle.extension.JibGradlePluginExtension;
import com.google.cloud.tools.jib.gradle.extension.ownership.Configuration;
import com.google.cloud.tools.jib.plugins.extension.ExtensionLogger;
import com.google.cloud.tools.jib.plugins.extension.JibPluginExtensionException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class JibOwnershipExtension
implements JibGradlePluginExtension<Configuration> {
    private Map<PathMatcher, String> pathMatchers = new LinkedHashMap<PathMatcher, String>();

    public Optional<Class<Configuration>> getExtraConfigType() {
        return Optional.of(Configuration.class);
    }

    public ContainerBuildPlan extendContainerBuildPlan(ContainerBuildPlan buildPlan, Map<String, String> properties, Optional<Configuration> config, GradleData gradleData, ExtensionLogger logger) throws JibPluginExtensionException {
        logger.log(ExtensionLogger.LogLevel.LIFECYCLE, "Running Jib Ownership Extension");
        if (!config.isPresent()) {
            logger.log(ExtensionLogger.LogLevel.WARN, "Nothing configured for Jib Ownership Extension");
            return buildPlan;
        }
        for (Configuration.Rule rule : config.get().getRules()) {
            if (rule.getGlob().isEmpty()) {
                throw new JibPluginExtensionException(this.getClass(), "glob pattern not given in ownership configuration");
            }
            this.pathMatchers.put(FileSystems.getDefault().getPathMatcher("glob:" + rule.getGlob()), rule.getOwnership());
        }
        List layers = buildPlan.getLayers();
        List newLayers = layers.stream().map(this::applyRulesToLayer).collect(Collectors.toList());
        return buildPlan.toBuilder().setLayers(newLayers).build();
    }

    private FileEntriesLayer applyRulesToLayer(FileEntriesLayer layer) {
        List entries = layer.getEntries().stream().map(this::applyRulesToFileEntry).collect(Collectors.toList());
        return layer.toBuilder().setEntries(entries).build();
    }

    private FileEntry applyRulesToFileEntry(FileEntry entry) {
        String newOwnership = null;
        for (Map.Entry<PathMatcher, String> mapEntry : this.pathMatchers.entrySet()) {
            Path pathInContainer;
            PathMatcher matcher = mapEntry.getKey();
            if (!matcher.matches(pathInContainer = Paths.get(entry.getExtractionPath().toString(), new String[0]))) continue;
            newOwnership = mapEntry.getValue();
        }
        return newOwnership == null ? entry : new FileEntry(entry.getSourceFile(), entry.getExtractionPath(), entry.getPermissions(), entry.getModificationTime(), newOwnership);
    }
}

