/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.event.events.TimerEvent;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;

class Timer
implements TimerEvent.Timer {
    private final Clock clock;
    @Nullable
    private final Timer parentTimer;
    private final Instant startTime;
    private Instant lapStartTime;

    Timer(Clock clock, @Nullable Timer parentTimer) {
        this.clock = clock;
        this.parentTimer = parentTimer;
        this.lapStartTime = this.startTime = clock.instant();
    }

    public Optional<? extends Timer> getParent() {
        return Optional.ofNullable(this.parentTimer);
    }

    Duration lap() {
        Instant now = this.clock.instant();
        Duration duration = Duration.between(this.lapStartTime, now);
        this.lapStartTime = now;
        return duration;
    }

    Duration getElapsedTime() {
        return Duration.between(this.startTime, this.clock.instant());
    }
}

