/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;

public class JibContainer {
    private final ImageReference targetImage;
    private final DescriptorDigest imageDigest;
    private final DescriptorDigest imageId;
    private final Set<String> tags;
    private final boolean imagePushed;

    @VisibleForTesting
    JibContainer(ImageReference targetImage, DescriptorDigest imageDigest, DescriptorDigest imageId, Set<String> tags, boolean imagePushed) {
        this.targetImage = targetImage;
        this.imageDigest = imageDigest;
        this.imageId = imageId;
        this.tags = tags;
        this.imagePushed = imagePushed;
    }

    static JibContainer from(BuildContext buildContext, BuildResult buildResult) {
        ImageReference targetImage = buildContext.getTargetImageConfiguration().getImage();
        DescriptorDigest imageDigest = buildResult.getImageDigest();
        DescriptorDigest imageId = buildResult.getImageId();
        ImmutableSet<String> tags = buildContext.getAllTargetImageTags();
        return new JibContainer(targetImage, imageDigest, imageId, (Set<String>)tags, buildResult.isImagePushed());
    }

    public ImageReference getTargetImage() {
        return this.targetImage;
    }

    public boolean isImagePushed() {
        return this.imagePushed;
    }

    public DescriptorDigest getDigest() {
        return this.imageDigest;
    }

    public DescriptorDigest getImageId() {
        return this.imageId;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hash(this.targetImage, this.imageDigest, this.imageId, this.tags, this.imagePushed);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JibContainer)) {
            return false;
        }
        JibContainer otherContainer = (JibContainer)other;
        return this.targetImage.equals(otherContainer.targetImage) && this.imageDigest.equals(otherContainer.imageDigest) && this.imageId.equals(otherContainer.imageId) && this.tags.equals(otherContainer.tags) && this.imagePushed == otherContainer.imagePushed;
    }
}

