/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.filesystem;

import com.google.cloud.tools.jib.filesystem.PathConsumer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DirectoryWalker {
    private final Path rootDir;
    private Predicate<Path> pathFilter = path -> true;

    public DirectoryWalker(Path rootDir) throws NotDirectoryException {
        if (!Files.isDirectory(rootDir, new LinkOption[0])) {
            throw new NotDirectoryException(rootDir + " is not a directory");
        }
        this.rootDir = rootDir;
    }

    public DirectoryWalker filter(Predicate<Path> pathFilter) {
        this.pathFilter = this.pathFilter.and(pathFilter);
        return this;
    }

    public DirectoryWalker filterRoot() {
        this.filter(path -> !path.equals(this.rootDir));
        return this;
    }

    public ImmutableList<Path> walk(PathConsumer pathConsumer) throws IOException {
        ImmutableList<Path> files = this.walk();
        for (Path path : files) {
            pathConsumer.accept(path);
        }
        return files;
    }

    public ImmutableList<Path> walk() throws IOException {
        try (Stream<Path> fileStream = Files.walk(this.rootDir, new FileVisitOption[0]);){
            ImmutableList immutableList = (ImmutableList)fileStream.filter(this.pathFilter).sorted().collect(ImmutableList.toImmutableList());
            return immutableList;
        }
    }
}

