/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class ObtainBaseImageLayerStep
implements Callable<PreparedLayer> {
    private static final String DESCRIPTION = "Pulling base image layer %s";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final Layer layer;
    @Nullable
    private final RegistryClient registryClient;
    private final BlobExistenceChecker blobExistenceChecker;

    static ObtainBaseImageLayerStep forForcedDownload(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Layer layer, @Nullable RegistryClient sourceRegistryClient) {
        BlobExistenceChecker noOpChecker = ignored -> PreparedLayer.StateInTarget.UNKNOWN;
        return new ObtainBaseImageLayerStep(buildContext, progressEventDispatcherFactory, layer, sourceRegistryClient, noOpChecker);
    }

    static ObtainBaseImageLayerStep forSelectiveDownload(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Layer layer, @Nullable RegistryClient sourceRegistryClient, RegistryClient targetRegistryClient) {
        Verify.verify((!buildContext.isOffline() ? 1 : 0) != 0);
        BlobExistenceChecker blobExistenceChecker = digest -> targetRegistryClient.checkBlob(digest).isPresent() ? PreparedLayer.StateInTarget.EXISTING : PreparedLayer.StateInTarget.MISSING;
        return new ObtainBaseImageLayerStep(buildContext, progressEventDispatcherFactory, layer, sourceRegistryClient, blobExistenceChecker);
    }

    private ObtainBaseImageLayerStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Layer layer, @Nullable RegistryClient registryClient, BlobExistenceChecker blobExistenceChecker) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.layer = layer;
        this.registryClient = registryClient;
        this.blobExistenceChecker = blobExistenceChecker;
    }

    /*
     * Exception decompiling
     */
    @Override
    public PreparedLayer call() throws IOException, CacheCorruptedException, RegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 22[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    @FunctionalInterface
    private static interface BlobExistenceChecker {
        public PreparedLayer.StateInTarget check(DescriptorDigest var1) throws IOException, RegistryException;
    }
}

