/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class ObtainBaseImageLayerStep
implements Callable<PreparedLayer> {
    private static final String DESCRIPTION = "Pulling base image layer %s";
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final Layer layer;
    @Nullable
    private final Authorization pullAuthorization;
    private final BlobExistenceChecker blobExistenceChecker;

    static ImmutableList<ObtainBaseImageLayerStep> makeListForForcedDownload(BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, PullBaseImageStep.ImageAndAuthorization baseImageAndAuth) {
        BlobExistenceChecker noOpChecker = ignored -> PreparedLayer.StateInTarget.UNKNOWN;
        return ObtainBaseImageLayerStep.makeList(buildConfiguration, progressEventDispatcherFactory, baseImageAndAuth, noOpChecker);
    }

    static ImmutableList<ObtainBaseImageLayerStep> makeListForSelectiveDownload(BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, PullBaseImageStep.ImageAndAuthorization baseImageAndAuth, Authorization pushAuthorization) {
        Verify.verify((!buildConfiguration.isOffline() ? 1 : 0) != 0);
        RegistryClient targetRegistryClient = buildConfiguration.newTargetImageRegistryClientFactory().setAuthorization(pushAuthorization).newRegistryClient();
        BlobExistenceChecker blobExistenceChecker = digest -> targetRegistryClient.checkBlob(digest).isPresent() ? PreparedLayer.StateInTarget.EXISTING : PreparedLayer.StateInTarget.MISSING;
        return ObtainBaseImageLayerStep.makeList(buildConfiguration, progressEventDispatcherFactory, baseImageAndAuth, blobExistenceChecker);
    }

    private static ImmutableList<ObtainBaseImageLayerStep> makeList(BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, PullBaseImageStep.ImageAndAuthorization baseImageAndAuth, BlobExistenceChecker blobExistenceChecker) {
        ImmutableList<Layer> baseImageLayers = baseImageAndAuth.getImage().getLayers();
        Throwable throwable = null;
        try (ProgressEventDispatcher progressEventDispatcher = progressEventDispatcherFactory.create("launching base image layer pullers", baseImageLayers.size());){
            UnmodifiableIterator unmodifiableIterator;
            TimerEventDispatcher ignored = new TimerEventDispatcher(buildConfiguration.getEventHandlers(), "Preparing base image layer pullers");
            Throwable throwable2 = null;
            try {
                ArrayList<ObtainBaseImageLayerStep> layerPullers = new ArrayList<ObtainBaseImageLayerStep>();
                for (Layer layer : baseImageLayers) {
                    layerPullers.add(new ObtainBaseImageLayerStep(buildConfiguration, progressEventDispatcher.newChildProducer(), layer, baseImageAndAuth.getAuthorization(), blobExistenceChecker));
                }
                unmodifiableIterator = ImmutableList.copyOf(layerPullers);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ObtainBaseImageLayerStep.$closeResource(throwable2, ignored);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            ObtainBaseImageLayerStep.$closeResource(throwable2, ignored);
            return unmodifiableIterator;
        }
    }

    ObtainBaseImageLayerStep(BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Layer layer, @Nullable Authorization pullAuthorization, BlobExistenceChecker blobExistenceChecker) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.layer = layer;
        this.pullAuthorization = pullAuthorization;
        this.blobExistenceChecker = blobExistenceChecker;
    }

    /*
     * Exception decompiling
     */
    @Override
    public PreparedLayer call() throws IOException, CacheCorruptedException, RegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 22[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FunctionalInterface
    private static interface BlobExistenceChecker {
        public PreparedLayer.StateInTarget check(DescriptorDigest var1) throws IOException, RegistryException;
    }
}

