/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.filesystem.FileOperations;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;

public class SaveDockerStep
implements Callable<Path> {
    private final BuildConfiguration buildConfiguration;
    private final DockerClient dockerClient;

    SaveDockerStep(BuildConfiguration buildConfiguration, DockerClient dockerClient) {
        this.buildConfiguration = buildConfiguration;
        this.dockerClient = dockerClient;
    }

    @Override
    public Path call() throws IOException, InterruptedException {
        Path outputDir = Files.createTempDirectory("jib-docker-save", new FileAttribute[0]);
        FileOperations.deleteRecursiveOnExit(outputDir);
        Path outputPath = outputDir.resolve("out.tar");
        ImageReference imageReference = this.buildConfiguration.getBaseImageConfiguration().getImage();
        this.dockerClient.save(imageReference, outputPath);
        return outputPath;
    }
}

