/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.docker.json.DockerManifestEntryTemplate;
import com.google.cloud.tools.jib.filesystem.FileOperations;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.json.BadContainerConfigurationFormatException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.tar.TarExtractor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class ExtractTarStep
implements Callable<LocalImage> {
    private final Path tarPath;
    private final Path destination;

    @VisibleForTesting
    static boolean isGzipped(Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            inputStream.mark(2);
            int magic = inputStream.read() & 0xFF | inputStream.read() << 8 & 0xFF00;
            boolean bl = magic == 35615;
            return bl;
        }
    }

    ExtractTarStep(Path tarPath, Path destination) {
        this.tarPath = tarPath;
        this.destination = destination;
    }

    @Override
    public LocalImage call() throws IOException, LayerCountMismatchException, BadContainerConfigurationFormatException {
        Files.createDirectories(this.destination, new FileAttribute[0]);
        FileOperations.deleteRecursiveOnExit(this.destination);
        TarExtractor.extract(this.tarPath, this.destination);
        InputStream manifestStream = Files.newInputStream(this.destination.resolve("manifest.json"), new OpenOption[0]);
        DockerManifestEntryTemplate loadManifest = ((DockerManifestEntryTemplate[])new ObjectMapper().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).readValue(manifestStream, DockerManifestEntryTemplate[].class))[0];
        manifestStream.close();
        ContainerConfigurationTemplate configurationTemplate = JsonTemplateMapper.readJsonFromFile(this.destination.resolve(loadManifest.getConfig()), ContainerConfigurationTemplate.class);
        List<String> layerFiles = loadManifest.getLayerFiles();
        if (configurationTemplate.getLayerCount() != layerFiles.size()) {
            throw new LayerCountMismatchException("Invalid base image format: manifest contains " + layerFiles.size() + " layers, but container configuration contains " + configurationTemplate.getLayerCount() + " layers");
        }
        boolean layersAreCompressed = layerFiles.size() > 0 && ExtractTarStep.isGzipped(this.destination.resolve(layerFiles.get(0)));
        ArrayList<PreparedLayer> layers = new ArrayList<PreparedLayer>();
        V22ManifestTemplate v22Manifest = new V22ManifestTemplate();
        for (int index = 0; index < layerFiles.size(); ++index) {
            Path file = this.destination.resolve(layerFiles.get(index));
            Blob blob = layersAreCompressed ? Blobs.from(file) : Blobs.compress(Blobs.from(file));
            BlobDescriptor blobDescriptor = blob.writeTo(ByteStreams.nullOutputStream());
            CachedLayer layer = CachedLayer.builder().setLayerBlob(blob).setLayerDigest(blobDescriptor.getDigest()).setLayerSize(blobDescriptor.getSize()).setLayerDiffId(configurationTemplate.getLayerDiffId(index)).build();
            layers.add(new PreparedLayer.Builder(layer).build());
            v22Manifest.addLayer(blobDescriptor.getSize(), blobDescriptor.getDigest());
        }
        BlobDescriptor configDescriptor = Blobs.from(configurationTemplate).writeTo(ByteStreams.nullOutputStream());
        v22Manifest.setContainerConfiguration(configDescriptor.getSize(), configDescriptor.getDigest());
        Image image = JsonToImageTranslator.toImage(v22Manifest, configurationTemplate);
        return new LocalImage(image, layers);
    }

    static class LocalImage {
        final Image baseImage;
        final List<PreparedLayer> layers;

        LocalImage(Image baseImage, List<PreparedLayer> layers) {
            this.baseImage = baseImage;
            this.layers = layers;
        }
    }
}

