/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import java.nio.file.Path;
import java.util.function.Function;

public class HelpfulSuggestions {
    private final String messagePrefix;
    private final String clearCacheCommand;
    private final String baseImageCredHelperConfiguration;
    private final Function<String, String> baseImageAuthConfiguration;
    private final String targetImageCredHelperConfiguration;
    private final Function<String, String> targetImageAuthConfiguration;

    public HelpfulSuggestions(String messagePrefix, String clearCacheCommand, String baseImageCredHelperConfiguration, Function<String, String> baseImageAuthConfiguration, String targetImageCredHelperConfiguration, Function<String, String> targetImageAuthConfiguration) {
        this.messagePrefix = messagePrefix;
        this.clearCacheCommand = clearCacheCommand;
        this.baseImageCredHelperConfiguration = baseImageCredHelperConfiguration;
        this.baseImageAuthConfiguration = baseImageAuthConfiguration;
        this.targetImageCredHelperConfiguration = targetImageCredHelperConfiguration;
        this.targetImageAuthConfiguration = targetImageAuthConfiguration;
    }

    public String forCacheMetadataCorrupted() {
        return this.suggest("run '" + this.clearCacheCommand + "' to clear the cache");
    }

    public String forHttpHostConnect() {
        return this.suggest("make sure your Internet is up and that the registry you are pushing to exists");
    }

    public String forUnknownHost() {
        return this.suggest("make sure that the registry you configured exists/is spelled properly");
    }

    public String forCacheDirectoryNotOwned(Path cacheDirectory) {
        return this.suggest("check that '" + cacheDirectory + "' is not used by another application or set the `useOnlyProjectCache` configuration");
    }

    public String forHttpStatusCodeForbidden(String imageReference) {
        return this.suggest("make sure you have permissions for " + imageReference);
    }

    public String forNoCredentialHelpersDefinedForBaseImage(String registry) {
        return this.forNoCredentialHelpersDefined(this.baseImageCredHelperConfiguration, this.baseImageAuthConfiguration.apply(registry));
    }

    public String forNoCredentialHelpersDefinedForTargetImage(String registry) {
        return this.forNoCredentialHelpersDefined(this.targetImageCredHelperConfiguration, this.targetImageAuthConfiguration.apply(registry));
    }

    public String forCredentialsNotCorrect(String registry) {
        return this.suggest("make sure your credentials for '" + registry + "' are set up correctly");
    }

    public String forDockerContextInsecureRecursiveDelete(String directory) {
        return this.suggest("clear " + directory + " manually before creating the Docker context");
    }

    public String forMainClassNotFound(String pluginName) {
        return this.suggest("add a `mainClass` configuration to " + pluginName);
    }

    public String forDockerNotInstalled() {
        return this.suggest("make sure Docker is installed and you have correct privileges to run it");
    }

    public String none() {
        return this.messagePrefix;
    }

    public String suggest(String suggestion) {
        return this.messagePrefix + ", perhaps you should " + suggestion;
    }

    private String forNoCredentialHelpersDefined(String credHelperConfiguration, String authConfiguration) {
        return this.suggest("set a credential helper name with the configuration '" + credHelperConfiguration + "' or " + authConfiguration);
    }
}

