/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import javax.annotation.Nullable;

public class CacheReader {
    private final Cache cache;

    private static FileTime getLastModifiedTime(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            ImmutableList<Path> subFiles = new DirectoryWalker(path).walk();
            FileTime maxLastModifiedTime = FileTime.from(Instant.MIN);
            for (Path subFilePath : subFiles) {
                FileTime subFileLastModifiedTime = Files.getLastModifiedTime(subFilePath, new LinkOption[0]);
                if (subFileLastModifiedTime.compareTo(maxLastModifiedTime) <= 0) continue;
                maxLastModifiedTime = subFileLastModifiedTime;
            }
            return maxLastModifiedTime;
        }
        return Files.getLastModifiedTime(path, new LinkOption[0]);
    }

    public CacheReader(Cache cache) {
        this.cache = cache;
    }

    @Nullable
    public CachedLayer getLayer(DescriptorDigest layerDigest) throws LayerPropertyNotFoundException {
        return this.cache.getMetadata().getLayers().get(layerDigest);
    }

    @Nullable
    public Path getLayerFile(ImmutableList<Path> sourceFiles) throws CacheMetadataCorruptedException {
        CacheMetadata cacheMetadata = this.cache.getMetadata();
        ImageLayers<CachedLayerWithMetadata> cachedLayers = cacheMetadata.filterLayers().bySourceFiles(sourceFiles).filter();
        FileTime newestLastModifiedTime = FileTime.from(Instant.MIN);
        Path newestLayerFile = null;
        for (CachedLayerWithMetadata cachedLayer : cachedLayers) {
            if (cachedLayer.getMetadata() == null) {
                throw new IllegalStateException("Layers with sourceFiles should have metadata");
            }
            FileTime cachedLayerLastModifiedTime = cachedLayer.getMetadata().getLastModifiedTime();
            if (cachedLayerLastModifiedTime.compareTo(newestLastModifiedTime) <= 0) continue;
            newestLastModifiedTime = cachedLayerLastModifiedTime;
            newestLayerFile = cachedLayer.getContentFile();
        }
        return newestLayerFile;
    }

    @Nullable
    public CachedLayer getUpToDateLayerBySourceFiles(ImmutableList<Path> sourceFiles) throws IOException, CacheMetadataCorruptedException {
        ImageLayers<CachedLayerWithMetadata> cachedLayersWithSourceFiles = this.cache.getMetadata().filterLayers().bySourceFiles(sourceFiles).filter();
        if (cachedLayersWithSourceFiles.isEmpty()) {
            return null;
        }
        FileTime sourceFilesLastModifiedTime = FileTime.from(Instant.MIN);
        for (Path path : sourceFiles) {
            FileTime lastModifiedTime = CacheReader.getLastModifiedTime(path);
            if (lastModifiedTime.compareTo(sourceFilesLastModifiedTime) <= 0) continue;
            sourceFilesLastModifiedTime = lastModifiedTime;
        }
        for (CachedLayerWithMetadata cachedLayer : cachedLayersWithSourceFiles) {
            if (cachedLayer.getMetadata() == null) {
                throw new IllegalStateException("Layers with sourceFiles should have metadata");
            }
            if (sourceFilesLastModifiedTime.compareTo(cachedLayer.getMetadata().getLastModifiedTime()) > 0) continue;
            return cachedLayer;
        }
        return null;
    }
}

