/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.stage;

import com.google.cloud.tools.maven.stage.AbstractStageMojo;
import com.google.cloud.tools.maven.stage.AppEngineWebXmlStager;
import com.google.cloud.tools.maven.stage.AppYamlStager;
import com.google.cloud.tools.maven.stage.NoOpStager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.maven.plugin.MojoExecutionException;

public interface Stager {
    public static Stager newStager(AbstractStageMojo stageMojo) throws MojoExecutionException {
        if (!stageMojo.isAppEngineCompatiblePackaging()) {
            return new NoOpStager();
        }
        if (stageMojo.getArtifact() == null || !Files.exists(stageMojo.getArtifact(), new LinkOption[0])) {
            throw new MojoExecutionException("\nCould not determine appengine environment, did you package your application?\nRun 'mvn package appengine:stage'");
        }
        return stageMojo.isAppEngineWebXmlBased() ? AppEngineWebXmlStager.newAppEngineWebXmlStager(stageMojo) : AppYamlStager.newAppYamlStager(stageMojo);
    }

    public void stage() throws MojoExecutionException;
}

