/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.deploy;

import com.google.cloud.tools.appengine.AppEngineException;
import com.google.cloud.tools.appengine.configuration.DeployConfiguration;
import com.google.cloud.tools.appengine.configuration.DeployProjectConfigurationConfiguration;
import com.google.cloud.tools.maven.deploy.AbstractDeployMojo;
import com.google.cloud.tools.maven.deploy.ConfigProcessor;
import com.google.cloud.tools.maven.deploy.Deployer;
import com.google.cloud.tools.maven.stage.Stager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class AppDeployer
implements Deployer {
    @VisibleForTesting
    final Stager stager;
    @VisibleForTesting
    final Path appengineDirectory;
    private final AbstractDeployMojo deployMojo;
    private final ConfigBuilder configBuilder;

    @VisibleForTesting
    AppDeployer(AbstractDeployMojo deployMojo, Stager stager, ConfigBuilder configBuilder, Path appengineDirectory) {
        this.deployMojo = deployMojo;
        this.stager = stager;
        this.configBuilder = configBuilder;
        this.appengineDirectory = appengineDirectory;
    }

    @Override
    public void deploy() throws MojoExecutionException {
        this.stager.stage();
        DeployConfiguration config = this.configBuilder.buildDeployConfiguration((List<Path>)ImmutableList.of((Object)this.deployMojo.getStagingDirectory()));
        try {
            this.deployMojo.getAppEngineFactory().deployment().deploy(config);
        }
        catch (AppEngineException ex) {
            throw new MojoExecutionException("App Engine application deployment failed", (Exception)((Object)ex));
        }
    }

    @Override
    public void deployAll() throws MojoExecutionException {
        String[] configYamls;
        this.stager.stage();
        ImmutableList.Builder computedDeployables = ImmutableList.builder();
        Path appYaml = this.deployMojo.getStagingDirectory().resolve("app.yaml");
        if (!Files.exists(appYaml, new LinkOption[0])) {
            throw new MojoExecutionException("Failed to deploy all: could not find app.yaml.");
        }
        this.deployMojo.getLog().info((CharSequence)"deployAll: Preparing to deploy app.yaml");
        computedDeployables.add((Object)appYaml);
        for (String yamlName : configYamls = new String[]{"cron.yaml", "dispatch.yaml", "dos.yaml", "index.yaml", "queue.yaml"}) {
            Path yaml = this.appengineDirectory.resolve(yamlName);
            if (!Files.exists(yaml, new LinkOption[0])) continue;
            this.deployMojo.getLog().info((CharSequence)("deployAll: Preparing to deploy " + yamlName));
            computedDeployables.add((Object)yaml);
        }
        DeployConfiguration config = this.configBuilder.buildDeployConfiguration((List<Path>)computedDeployables.build());
        try {
            this.deployMojo.getAppEngineFactory().deployment().deploy(config);
        }
        catch (AppEngineException ex) {
            throw new MojoExecutionException("Failed to deploy", (Exception)((Object)ex));
        }
    }

    @Override
    public void deployCron() throws MojoExecutionException {
        this.stager.stage();
        try {
            this.deployMojo.getAppEngineFactory().deployment().deployCron(this.configBuilder.buildDeployProjectConfigurationConfiguration(this.appengineDirectory));
        }
        catch (AppEngineException ex) {
            throw new MojoExecutionException("Failed to deploy", (Exception)((Object)ex));
        }
    }

    @Override
    public void deployDispatch() throws MojoExecutionException {
        this.stager.stage();
        try {
            this.deployMojo.getAppEngineFactory().deployment().deployDispatch(this.configBuilder.buildDeployProjectConfigurationConfiguration(this.appengineDirectory));
        }
        catch (AppEngineException ex) {
            throw new MojoExecutionException("Failed to deploy", (Exception)((Object)ex));
        }
    }

    @Override
    public void deployDos() throws MojoExecutionException {
        this.stager.stage();
        try {
            this.deployMojo.getAppEngineFactory().deployment().deployDos(this.configBuilder.buildDeployProjectConfigurationConfiguration(this.appengineDirectory));
        }
        catch (AppEngineException ex) {
            throw new MojoExecutionException("Failed to deploy", (Exception)((Object)ex));
        }
    }

    @Override
    public void deployIndex() throws MojoExecutionException {
        this.stager.stage();
        try {
            this.deployMojo.getAppEngineFactory().deployment().deployIndex(this.configBuilder.buildDeployProjectConfigurationConfiguration(this.appengineDirectory));
        }
        catch (AppEngineException ex) {
            throw new MojoExecutionException("Failed to deploy", (Exception)((Object)ex));
        }
    }

    @Override
    public void deployQueue() throws MojoExecutionException {
        this.stager.stage();
        try {
            this.deployMojo.getAppEngineFactory().deployment().deployQueue(this.configBuilder.buildDeployProjectConfigurationConfiguration(this.appengineDirectory));
        }
        catch (AppEngineException ex) {
            throw new MojoExecutionException("Failed to deploy", (Exception)((Object)ex));
        }
    }

    static class ConfigBuilder {
        private final AbstractDeployMojo deployMojo;
        private final ConfigProcessor configProcessor;

        ConfigBuilder(AbstractDeployMojo deployMojo, ConfigProcessor configProcessor) {
            this.deployMojo = deployMojo;
            this.configProcessor = configProcessor;
        }

        DeployConfiguration buildDeployConfiguration(List<Path> deployables) {
            return DeployConfiguration.builder(deployables).bucket(this.deployMojo.getBucket()).gcloudMode(this.deployMojo.getGcloudMode()).imageUrl(this.deployMojo.getImageUrl()).projectId(this.configProcessor.processProjectId(this.deployMojo.getProjectId())).promote(this.deployMojo.getPromote()).server(this.deployMojo.getServer()).stopPreviousVersion(this.deployMojo.getStopPreviousVersion()).version(this.configProcessor.processVersion(this.deployMojo.getVersion())).build();
        }

        DeployProjectConfigurationConfiguration buildDeployProjectConfigurationConfiguration(Path appengineDirectory) {
            return DeployProjectConfigurationConfiguration.builder((Path)appengineDirectory).projectId(this.configProcessor.processProjectId(this.deployMojo.getProjectId())).server(this.deployMojo.getServer()).build();
        }
    }
}

