/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.cloudsdk;

import com.google.cloud.tools.maven.cloudsdk.CloudSdkAppEngineFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class CloudSdkMojo
extends AbstractMojo {
    @Parameter(property="cloudSdkHome", required=false)
    private File cloudSdkHome;
    @Parameter(property="cloudSdkVersion", required=false)
    private String cloudSdkVersion;
    @Parameter(property="serviceAccountKeyFile", required=false)
    private File serviceAccountKeyFile;
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    protected CloudSdkAppEngineFactory factory = new CloudSdkAppEngineFactory(this);

    public String getArtifactId() {
        return this.pluginDescriptor.getArtifactId();
    }

    public String getArtifactVersion() {
        return this.pluginDescriptor.getVersion();
    }

    public Path getCloudSdkHome() {
        return this.cloudSdkHome != null ? this.cloudSdkHome.toPath() : null;
    }

    public String getCloudSdkVersion() {
        return this.cloudSdkVersion;
    }

    public Path getServiceAccountKeyFile() {
        return this.serviceAccountKeyFile == null ? null : this.serviceAccountKeyFile.toPath();
    }

    public CloudSdkAppEngineFactory getAppEngineFactory() {
        return this.factory;
    }

    public String getCompileTargetVersion() {
        String javaVersion = "1.5";
        if (this.mavenProject != null) {
            String mavenCompilerTargetProperty = this.mavenProject.getProperties().getProperty("maven.compiler.target");
            if (mavenCompilerTargetProperty != null) {
                javaVersion = mavenCompilerTargetProperty;
            } else {
                Xpp3Dom domVersion;
                Xpp3Dom config;
                Plugin compilerPlugin = this.mavenProject.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
                if (compilerPlugin != null && (config = (Xpp3Dom)compilerPlugin.getConfiguration()) != null && (domVersion = config.getChild("target")) != null) {
                    javaVersion = domVersion.getValue();
                }
            }
        }
        return javaVersion;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    @VisibleForTesting
    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

