/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.CountTokensRequest;
import com.google.cloud.vertexai.api.CountTokensResponse;
import com.google.cloud.vertexai.api.GenerateContentRequest;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.SafetySetting;
import com.google.cloud.vertexai.api.Tool;
import com.google.cloud.vertexai.api.ToolConfig;
import com.google.cloud.vertexai.generativeai.ChatSession;
import com.google.cloud.vertexai.generativeai.Constants;
import com.google.cloud.vertexai.generativeai.ContentMaker;
import com.google.cloud.vertexai.generativeai.ResponseStream;
import com.google.cloud.vertexai.generativeai.ResponseStreamIteratorWithHistory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class GenerativeModel {
    private final String modelName;
    private final String resourceName;
    private final VertexAI vertexAi;
    private final GenerationConfig generationConfig;
    private final ImmutableList<SafetySetting> safetySettings;
    private final ImmutableList<Tool> tools;
    private final Optional<ToolConfig> toolConfig;
    private final Optional<Content> systemInstruction;

    public GenerativeModel(String modelName, VertexAI vertexAi) {
        this(modelName, GenerationConfig.getDefaultInstance(), (ImmutableList<SafetySetting>)ImmutableList.of(), (ImmutableList<Tool>)ImmutableList.of(), Optional.empty(), Optional.empty(), vertexAi);
    }

    private GenerativeModel(String modelName, GenerationConfig generationConfig, ImmutableList<SafetySetting> safetySettings, ImmutableList<Tool> tools, Optional<ToolConfig> toolConfig, Optional<Content> systemInstruction, VertexAI vertexAi) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)modelName) ? 1 : 0) != 0, (Object)"modelName can't be null or empty. Please refer to https://cloud.google.com/vertex-ai/docs/generative-ai/learn/models#gemini-models to find the right model name.");
        Preconditions.checkNotNull((Object)vertexAi, (Object)"VertexAI can't be null.");
        Preconditions.checkNotNull((Object)generationConfig, (Object)"GenerationConfig can't be null.");
        Preconditions.checkNotNull(safetySettings, (Object)"ImmutableList<SafetySettings> can't be null.");
        Preconditions.checkNotNull(tools, (Object)"ImmutableList<Tool> can't be null.");
        Preconditions.checkNotNull(toolConfig, (Object)"Optional<ToolConfig> can't be null.");
        Preconditions.checkNotNull(systemInstruction, (Object)"Optional<Content> can't be null.");
        this.resourceName = GenerativeModel.getResourceName(modelName, vertexAi);
        this.modelName = GenerativeModel.reconcileModelName(modelName);
        this.vertexAi = vertexAi;
        this.generationConfig = generationConfig;
        this.safetySettings = safetySettings;
        this.tools = tools;
        this.toolConfig = toolConfig;
        this.systemInstruction = systemInstruction.isPresent() ? Optional.of(this.removeRoleInSystemInstructionContent(systemInstruction.get())) : Optional.empty();
    }

    public GenerativeModel withGenerationConfig(GenerationConfig generationConfig) {
        Preconditions.checkNotNull((Object)generationConfig, (Object)"GenerationConfig can't be null.");
        return new GenerativeModel(this.modelName, generationConfig, this.safetySettings, this.tools, this.toolConfig, this.systemInstruction, this.vertexAi);
    }

    public GenerativeModel withSafetySettings(List<SafetySetting> safetySettings) {
        Preconditions.checkNotNull(safetySettings, (Object)"safetySettings can't be null. Use an empty list if no safety settings is intended.");
        return new GenerativeModel(this.modelName, this.generationConfig, (ImmutableList<SafetySetting>)ImmutableList.copyOf(safetySettings), this.tools, this.toolConfig, this.systemInstruction, this.vertexAi);
    }

    public GenerativeModel withTools(List<Tool> tools) {
        Preconditions.checkNotNull(tools, (Object)"tools can't be null. Use an empty list if no tool is to be used.");
        return new GenerativeModel(this.modelName, this.generationConfig, this.safetySettings, (ImmutableList<Tool>)ImmutableList.copyOf(tools), this.toolConfig, this.systemInstruction, this.vertexAi);
    }

    public GenerativeModel withToolConfig(ToolConfig toolConfig) {
        Preconditions.checkNotNull((Object)toolConfig, (Object)"toolConfig can't be null. Use Optional.empty() if no tool config is intended.");
        return new GenerativeModel(this.modelName, this.generationConfig, this.safetySettings, this.tools, Optional.of(toolConfig), this.systemInstruction, this.vertexAi);
    }

    public GenerativeModel withSystemInstruction(Content systemInstruction) {
        Preconditions.checkNotNull((Object)systemInstruction, (Object)"system instruction can't be null. Use Optional.empty() if no system instruction should be provided.");
        return new GenerativeModel(this.modelName, this.generationConfig, this.safetySettings, this.tools, this.toolConfig, Optional.of(systemInstruction), this.vertexAi);
    }

    @BetaApi
    public CountTokensResponse countTokens(String text) throws IOException {
        return this.countTokens(ContentMaker.fromString(text));
    }

    @BetaApi
    public CountTokensResponse countTokens(Content content) throws IOException {
        return this.countTokens(Arrays.asList(content));
    }

    @BetaApi
    public CountTokensResponse countTokens(List<Content> contents) throws IOException {
        Preconditions.checkArgument((contents != null && !contents.isEmpty() ? 1 : 0) != 0, (Object)"contents can't be null or empty.");
        CountTokensRequest request = CountTokensRequest.newBuilder().setEndpoint(this.resourceName).setModel(this.resourceName).addAllContents(contents).build();
        return this.countTokensFromRequest(request);
    }

    private CountTokensResponse countTokensFromRequest(CountTokensRequest request) throws IOException {
        return this.vertexAi.getLlmUtilityClient().countTokens(request);
    }

    public GenerateContentResponse generateContent(String text) throws IOException {
        return this.generateContent(ContentMaker.fromString(text));
    }

    public GenerateContentResponse generateContent(Content content) throws IOException {
        return this.generateContent(Arrays.asList(content));
    }

    public GenerateContentResponse generateContent(List<Content> contents) throws IOException {
        return this.generateContent(this.buildGenerateContentRequest(contents));
    }

    private GenerateContentResponse generateContent(GenerateContentRequest request) throws IOException {
        return (GenerateContentResponse)this.vertexAi.getPredictionServiceClient().generateContentCallable().call((Object)request);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(String text) throws IOException {
        return this.generateContentStream(ContentMaker.fromString(text));
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(Content content) throws IOException {
        return this.generateContentStream(Arrays.asList(content));
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(List<Content> contents) throws IOException {
        return this.generateContentStream(this.buildGenerateContentRequest(contents));
    }

    private ResponseStream<GenerateContentResponse> generateContentStream(GenerateContentRequest request) throws IOException {
        return new ResponseStream<GenerateContentResponse>(new ResponseStreamIteratorWithHistory(this.vertexAi.getPredictionServiceClient().streamGenerateContentCallable().call((Object)request).iterator()));
    }

    public ApiFuture<GenerateContentResponse> generateContentAsync(String text) throws IOException {
        return this.generateContentAsync(ContentMaker.fromString(text));
    }

    public ApiFuture<GenerateContentResponse> generateContentAsync(Content content) throws IOException {
        return this.generateContentAsync(Arrays.asList(content));
    }

    public ApiFuture<GenerateContentResponse> generateContentAsync(List<Content> contents) throws IOException {
        return this.generateContentAsync(this.buildGenerateContentRequest(contents));
    }

    private ApiFuture<GenerateContentResponse> generateContentAsync(GenerateContentRequest request) throws IOException {
        return this.vertexAi.getPredictionServiceClient().generateContentCallable().futureCall((Object)request);
    }

    private Content removeRoleInSystemInstructionContent(Content systemInstruction) {
        return systemInstruction.toBuilder().clearRole().build();
    }

    private GenerateContentRequest buildGenerateContentRequest(List<Content> contents) {
        Preconditions.checkArgument((contents != null && !contents.isEmpty() ? 1 : 0) != 0, (Object)"contents can't be null or empty.");
        GenerateContentRequest.Builder requestBuilder = GenerateContentRequest.newBuilder().setModel(this.resourceName).addAllContents(contents).setGenerationConfig(this.generationConfig).addAllSafetySettings(this.safetySettings).addAllTools(this.tools);
        if (this.toolConfig.isPresent()) {
            requestBuilder.setToolConfig(this.toolConfig.get());
        }
        if (this.systemInstruction.isPresent()) {
            requestBuilder.setSystemInstruction(this.systemInstruction.get());
        }
        return requestBuilder.build();
    }

    public String getModelName() {
        return this.modelName;
    }

    public GenerationConfig getGenerationConfig() {
        return this.generationConfig;
    }

    public ImmutableList<SafetySetting> getSafetySettings() {
        return this.safetySettings;
    }

    public ImmutableList<Tool> getTools() {
        return this.tools;
    }

    public Optional<ToolConfig> getToolConfig() {
        return this.toolConfig;
    }

    public Optional<Content> getSystemInstruction() {
        return this.systemInstruction;
    }

    public ChatSession startChat() {
        return new ChatSession(this);
    }

    private static String reconcileModelName(String modelName) {
        for (String prefix : Constants.MODEL_NAME_PREFIXES) {
            if (!modelName.startsWith(prefix)) continue;
            modelName = modelName.substring(modelName.lastIndexOf(47) + 1);
            break;
        }
        return modelName;
    }

    private static String getResourceName(String modelName, VertexAI vertexAi) {
        if (modelName.startsWith("projects/")) {
            return modelName;
        }
        if (modelName.startsWith("publishers/")) {
            return String.format("projects/%s/locations/%s/%s", vertexAi.getProjectId(), vertexAi.getLocation(), modelName);
        }
        return String.format("projects/%s/locations/%s/publishers/google/models/%s", vertexAi.getProjectId(), vertexAi.getLocation(), GenerativeModel.reconcileModelName(modelName));
    }

    public static class Builder {
        private String modelName;
        private VertexAI vertexAi;
        private GenerationConfig generationConfig = GenerationConfig.getDefaultInstance();
        private ImmutableList<SafetySetting> safetySettings = ImmutableList.of();
        private ImmutableList<Tool> tools = ImmutableList.of();
        private Optional<ToolConfig> toolConfig = Optional.empty();
        private Optional<Content> systemInstruction = Optional.empty();

        public GenerativeModel build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.modelName) ? 1 : 0) != 0, (Object)"modelName is required. Please call setModelName() before building.");
            Preconditions.checkNotNull((Object)this.vertexAi, (Object)"vertexAi is required. Please call setVertexAi() before building.");
            return new GenerativeModel(this.modelName, this.generationConfig, this.safetySettings, this.tools, this.toolConfig, this.systemInstruction, this.vertexAi);
        }

        @CanIgnoreReturnValue
        public Builder setModelName(String modelName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)modelName) ? 1 : 0) != 0, (Object)"modelName can't be null or empty. Please refer to https://cloud.google.com/vertex-ai/docs/generative-ai/learn/models#gemini-models to find the right model name.");
            this.modelName = modelName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVertexAi(VertexAI vertexAi) {
            Preconditions.checkNotNull((Object)vertexAi, (Object)"VertexAI can't be null.");
            this.vertexAi = vertexAi;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setGenerationConfig(GenerationConfig generationConfig) {
            Preconditions.checkNotNull((Object)generationConfig, (Object)"GenerationConfig can't be null.");
            this.generationConfig = generationConfig;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSafetySettings(List<SafetySetting> safetySettings) {
            Preconditions.checkNotNull(safetySettings, (Object)"safetySettings can't be null. Use an empty list if no safety settings is intended.");
            this.safetySettings = ImmutableList.copyOf(safetySettings);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTools(List<Tool> tools) {
            Preconditions.checkNotNull(tools, (Object)"tools can't be null. Use an empty list if no tool is to be used.");
            this.tools = ImmutableList.copyOf(tools);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setToolConfig(ToolConfig toolConfig) {
            Preconditions.checkNotNull((Object)toolConfig, (Object)"toolConfig can't be null. Use Optional.empty() if no tool config is intended.");
            this.toolConfig = Optional.of(toolConfig);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSystemInstruction(Content systemInstruction) {
            Preconditions.checkNotNull((Object)systemInstruction, (Object)"system instruction can't be null. Use Optional.empty() if no system instruction should be provided.");
            this.systemInstruction = Optional.of(systemInstruction);
            return this;
        }
    }
}

