/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.google.cloud.storage.StorageClass;
import com.google.common.base.MoreObjects;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class MultipartUpload {
    @JacksonXmlProperty(localName="Key")
    private String key;
    @JacksonXmlProperty(localName="UploadId")
    private String uploadId;
    @JacksonXmlProperty(localName="StorageClass")
    private StorageClass storageClass;
    @JacksonXmlProperty(localName="Initiated")
    private OffsetDateTime initiated;

    private MultipartUpload() {
    }

    private MultipartUpload(String key, String uploadId, StorageClass storageClass, OffsetDateTime initiated) {
        this.key = key;
        this.uploadId = uploadId;
        this.storageClass = storageClass;
        this.initiated = initiated;
    }

    public String key() {
        return this.key;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public StorageClass storageClass() {
        return this.storageClass;
    }

    public OffsetDateTime initiated() {
        return this.initiated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipartUpload that = (MultipartUpload)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.uploadId, that.uploadId) && Objects.equals((Object)this.storageClass, (Object)that.storageClass) && Objects.equals(this.initiated, that.initiated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.uploadId, this.storageClass, this.initiated});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("uploadId", (Object)this.uploadId).add("storageClass", (Object)this.storageClass).add("initiated", (Object)this.initiated).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String key;
        private String uploadId;
        private StorageClass storageClass;
        private OffsetDateTime initiated;

        private Builder() {
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder initiated(OffsetDateTime initiated) {
            this.initiated = initiated;
            return this;
        }

        public MultipartUpload build() {
            return new MultipartUpload(this.key, this.uploadId, this.storageClass, this.initiated);
        }
    }
}

