/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.spi.v1;

import com.google.cloud.storage.spi.v1.HttpStorageRpc;
import com.google.cloud.storage.spi.v1.RpcBatch;
import com.google.common.collect.ImmutableSet;
import io.opencensus.trace.Tracing;

class HttpStorageRpcSpans {
    static final String SPAN_NAME_CLIENT_PREFIX = "Sent";
    static final String SPAN_NAME_CREATE_BUCKET = HttpStorageRpcSpans.getTraceSpanName("create(Bucket,Map)");
    static final String SPAN_NAME_CREATE_OBJECT = HttpStorageRpcSpans.getTraceSpanName("create(StorageObject,InputStream,Map)");
    static final String SPAN_NAME_LIST_BUCKETS = HttpStorageRpcSpans.getTraceSpanName("list(Map)");
    static final String SPAN_NAME_LIST_OBJECTS = HttpStorageRpcSpans.getTraceSpanName("create(String,Map)");
    static final String SPAN_NAME_GET_BUCKET = HttpStorageRpcSpans.getTraceSpanName("get(Bucket,Map)");
    static final String SPAN_NAME_GET_OBJECT = HttpStorageRpcSpans.getTraceSpanName("get(StorageObject,Map)");
    static final String SPAN_NAME_PATCH_BUCKET = HttpStorageRpcSpans.getTraceSpanName("patch(Bucket,Map)");
    static final String SPAN_NAME_PATCH_OBJECT = HttpStorageRpcSpans.getTraceSpanName("patch(StorageObject,Map)");
    static final String SPAN_NAME_DELETE_BUCKET = HttpStorageRpcSpans.getTraceSpanName("delete(Bucket,Map)");
    static final String SPAN_NAME_DELETE_OBJECT = HttpStorageRpcSpans.getTraceSpanName("delete(StorageObject,Map)");
    static final String SPAN_NAME_CREATE_BATCH = HttpStorageRpcSpans.getTraceSpanName("createBatch()");
    static final String SPAN_NAME_COMPOSE = HttpStorageRpcSpans.getTraceSpanName("compose(Iterable,StorageObject,Map)");
    static final String SPAN_NAME_LOAD = HttpStorageRpcSpans.getTraceSpanName("load(StorageObject,Map");
    static final String SPAN_NAME_READ = HttpStorageRpcSpans.getTraceSpanName("read(StorageObject,Map,long,int)");
    static final String SPAN_NAME_OPEN = HttpStorageRpcSpans.getTraceSpanName("open(StorageObject,Map)");
    static final String SPAN_NAME_WRITE = HttpStorageRpcSpans.getTraceSpanName("write(String,byte[],int,long,int,boolean)");
    static final String SPAN_NAME_OPEN_REWRITE = HttpStorageRpcSpans.getTraceSpanName("openRewrite(RewriteRequest)");
    static final String SPAN_NAME_CONTINUE_REWRITE = HttpStorageRpcSpans.getTraceSpanName("continueRewrite(RewriteResponse)");
    static final String SPAN_NAME_GET_BUCKET_ACL = HttpStorageRpcSpans.getTraceSpanName("getAcl(String,String,Map)");
    static final String SPAN_NAME_DELETE_BUCKET_ACL = HttpStorageRpcSpans.getTraceSpanName("deleteAcl(String,String,Map)");
    static final String SPAN_NAME_CREATE_BUCKET_ACL = HttpStorageRpcSpans.getTraceSpanName("createAcl(BucketAccessControl,Map)");
    static final String SPAN_NAME_PATCH_BUCKET_ACL = HttpStorageRpcSpans.getTraceSpanName("patchAcl(BucketAccessControl,Map)");
    static final String SPAN_NAME_LIST_BUCKET_ACLS = HttpStorageRpcSpans.getTraceSpanName("listAcls(String,Map)");
    static final String SPAN_NAME_GET_OBJECT_DEFAULT_ACL = HttpStorageRpcSpans.getTraceSpanName("getDefaultAcl(String,String)");
    static final String SPAN_NAME_DELETE_OBJECT_DEFAULT_ACL = HttpStorageRpcSpans.getTraceSpanName("deleteDefaultAcl(String,String)");
    static final String SPAN_NAME_CREATE_OBJECT_DEFAULT_ACL = HttpStorageRpcSpans.getTraceSpanName("createDefaultAcl(ObjectAccessControl)");
    static final String SPAN_NAME_PATCH_OBJECT_DEFAULT_ACL = HttpStorageRpcSpans.getTraceSpanName("patchDefaultAcl(ObjectAccessControl)");
    static final String SPAN_NAME_LIST_OBJECT_DEFAULT_ACLS = HttpStorageRpcSpans.getTraceSpanName("listDefaultAcls(String)");
    static final String SPAN_NAME_GET_OBJECT_ACL = HttpStorageRpcSpans.getTraceSpanName("getAcl(String,String,Long,String)");
    static final String SPAN_NAME_DELETE_OBJECT_ACL = HttpStorageRpcSpans.getTraceSpanName("deleteAcl(String,String,Long,String)");
    static final String SPAN_NAME_CREATE_OBJECT_ACL = HttpStorageRpcSpans.getTraceSpanName("createAcl(ObjectAccessControl)");
    static final String SPAN_NAME_PATCH_OBJECT_ACL = HttpStorageRpcSpans.getTraceSpanName("patchAcl(ObjectAccessControl)");
    static final String SPAN_NAME_LIST_OBJECT_ACLS = HttpStorageRpcSpans.getTraceSpanName("listAcls(String,String,Long)");
    static final String SPAN_NAME_CREATE_HMAC_KEY = HttpStorageRpcSpans.getTraceSpanName("createHmacKey(String)");
    static final String SPAN_NAME_GET_HMAC_KEY = HttpStorageRpcSpans.getTraceSpanName("getHmacKey(String)");
    static final String SPAN_NAME_DELETE_HMAC_KEY = HttpStorageRpcSpans.getTraceSpanName("deleteHmacKey(String)");
    static final String SPAN_NAME_LIST_HMAC_KEYS = HttpStorageRpcSpans.getTraceSpanName("listHmacKeys(String,String,Long)");
    static final String SPAN_NAME_UPDATE_HMAC_KEY = HttpStorageRpcSpans.getTraceSpanName("updateHmacKey(HmacKeyMetadata)");
    static final String SPAN_NAME_GET_BUCKET_IAM_POLICY = HttpStorageRpcSpans.getTraceSpanName("getIamPolicy(String,Map)");
    static final String SPAN_NAME_SET_BUCKET_IAM_POLICY = HttpStorageRpcSpans.getTraceSpanName("setIamPolicy(String,Policy,Map)");
    static final String SPAN_NAME_TEST_BUCKET_IAM_PERMISSIONS = HttpStorageRpcSpans.getTraceSpanName("testIamPermissions(String,List,Map)");
    static final String SPAN_NAME_DELETE_NOTIFICATION = HttpStorageRpcSpans.getTraceSpanName("deleteNotification(String,String)");
    static final String SPAN_NAME_LIST_NOTIFICATIONS = HttpStorageRpcSpans.getTraceSpanName("listNotifications(String)");
    static final String SPAN_NAME_CREATE_NOTIFICATION = HttpStorageRpcSpans.getTraceSpanName("createNotification(String,Notification)");
    static final String SPAN_LOCK_RETENTION_POLICY = HttpStorageRpcSpans.getTraceSpanName("lockRetentionPolicy(String,Long)");
    static final String SPAN_NAME_GET_SERVICE_ACCOUNT = HttpStorageRpcSpans.getTraceSpanName("getServiceAccount(String)");
    static final String SPAN_NAME_BATCH_SUBMIT = HttpStorageRpcSpans.getTraceSpanName(RpcBatch.class.getName() + ".submit()");
    static final ImmutableSet<String> ALL_SPAN_NAMES = ImmutableSet.of((Object)SPAN_NAME_CREATE_BUCKET, (Object)SPAN_NAME_CREATE_OBJECT, (Object)SPAN_NAME_LIST_BUCKETS, (Object)SPAN_NAME_LIST_OBJECTS, (Object)SPAN_NAME_GET_BUCKET, (Object)SPAN_NAME_GET_OBJECT, (Object[])new String[]{SPAN_NAME_PATCH_BUCKET, SPAN_NAME_PATCH_OBJECT, SPAN_NAME_DELETE_BUCKET, SPAN_NAME_DELETE_OBJECT, SPAN_NAME_CREATE_BATCH, SPAN_NAME_COMPOSE, SPAN_NAME_LOAD, SPAN_NAME_READ, SPAN_NAME_OPEN, SPAN_NAME_WRITE, SPAN_NAME_OPEN_REWRITE, SPAN_NAME_CONTINUE_REWRITE, SPAN_NAME_GET_BUCKET_ACL, SPAN_NAME_DELETE_BUCKET_ACL, SPAN_NAME_CREATE_BUCKET_ACL, SPAN_NAME_PATCH_BUCKET_ACL, SPAN_NAME_LIST_BUCKET_ACLS, SPAN_NAME_GET_OBJECT_DEFAULT_ACL, SPAN_NAME_DELETE_OBJECT_DEFAULT_ACL, SPAN_NAME_CREATE_OBJECT_DEFAULT_ACL, SPAN_NAME_PATCH_OBJECT_DEFAULT_ACL, SPAN_NAME_LIST_OBJECT_DEFAULT_ACLS, SPAN_NAME_GET_OBJECT_ACL, SPAN_NAME_DELETE_OBJECT_ACL, SPAN_NAME_CREATE_OBJECT_ACL, SPAN_NAME_PATCH_OBJECT_ACL, SPAN_NAME_LIST_OBJECT_ACLS, SPAN_NAME_GET_BUCKET_IAM_POLICY, SPAN_NAME_SET_BUCKET_IAM_POLICY, SPAN_NAME_TEST_BUCKET_IAM_PERMISSIONS, SPAN_NAME_DELETE_NOTIFICATION, SPAN_NAME_LIST_NOTIFICATIONS, SPAN_NAME_CREATE_NOTIFICATION, SPAN_NAME_GET_SERVICE_ACCOUNT, SPAN_LOCK_RETENTION_POLICY, SPAN_NAME_BATCH_SUBMIT});

    static String getTraceSpanName(String methodDescriptor) {
        return String.format("%s.%s.%s", SPAN_NAME_CLIENT_PREFIX, HttpStorageRpc.class.getName(), methodDescriptor);
    }

    static void registerAllSpanNamesForCollection() {
        Tracing.getExportComponent().getSampledSpanStore().registerSpanNamesForCollection(ALL_SPAN_NAMES);
    }

    private HttpStorageRpcSpans() {
    }
}

