/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.core.BetaApi;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.StorageClass;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BucketInfo
implements Serializable {
    static final Function<Bucket, BucketInfo> FROM_PB_FUNCTION = new Function<Bucket, BucketInfo>(){

        public BucketInfo apply(Bucket pb) {
            return BucketInfo.fromPb(pb);
        }
    };
    static final Function<BucketInfo, Bucket> TO_PB_FUNCTION = new Function<BucketInfo, Bucket>(){

        public Bucket apply(BucketInfo bucketInfo) {
            return bucketInfo.toPb();
        }
    };
    private static final long serialVersionUID = -4712013629621638459L;
    private final String generatedId;
    private final String name;
    private final Acl.Entity owner;
    private final String selfLink;
    private final Boolean requesterPays;
    private final Boolean versioningEnabled;
    private final String indexPage;
    private final String notFoundPage;
    private final List<DeleteRule> deleteRules;
    private final List<LifecycleRule> lifecycleRules;
    private final String etag;
    private final Long createTime;
    private final Long updateTime;
    private final Long metageneration;
    private final List<Cors> cors;
    private final List<Acl> acl;
    private final List<Acl> defaultAcl;
    private final String location;
    private final StorageClass storageClass;
    private final Map<String, String> labels;
    private final String defaultKmsKeyName;
    private final Boolean defaultEventBasedHold;
    private final Long retentionEffectiveTime;
    private final Boolean retentionPolicyIsLocked;
    private final Long retentionPeriod;
    private final IamConfiguration iamConfiguration;
    private final String locationType;
    private final Logging logging;

    BucketInfo(BuilderImpl builder) {
        this.generatedId = builder.generatedId;
        this.name = builder.name;
        this.etag = builder.etag;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.metageneration = builder.metageneration;
        this.location = builder.location;
        this.storageClass = builder.storageClass;
        this.cors = builder.cors;
        this.acl = builder.acl;
        this.defaultAcl = builder.defaultAcl;
        this.owner = builder.owner;
        this.selfLink = builder.selfLink;
        this.versioningEnabled = builder.versioningEnabled;
        this.indexPage = builder.indexPage;
        this.notFoundPage = builder.notFoundPage;
        this.deleteRules = builder.deleteRules;
        this.lifecycleRules = builder.lifecycleRules;
        this.labels = builder.labels;
        this.requesterPays = builder.requesterPays;
        this.defaultKmsKeyName = builder.defaultKmsKeyName;
        this.defaultEventBasedHold = builder.defaultEventBasedHold;
        this.retentionEffectiveTime = builder.retentionEffectiveTime;
        this.retentionPolicyIsLocked = builder.retentionPolicyIsLocked;
        this.retentionPeriod = builder.retentionPeriod;
        this.iamConfiguration = builder.iamConfiguration;
        this.locationType = builder.locationType;
        this.logging = builder.logging;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getName() {
        return this.name;
    }

    public Acl.Entity getOwner() {
        return this.owner;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Boolean versioningEnabled() {
        return Data.isNull((Object)this.versioningEnabled) ? null : this.versioningEnabled;
    }

    public Boolean requesterPays() {
        return Data.isNull((Object)this.requesterPays) ? null : this.requesterPays;
    }

    public String getIndexPage() {
        return this.indexPage;
    }

    public String getNotFoundPage() {
        return this.notFoundPage;
    }

    @Deprecated
    public List<? extends DeleteRule> getDeleteRules() {
        return this.deleteRules;
    }

    public List<? extends LifecycleRule> getLifecycleRules() {
        return this.lifecycleRules != null ? this.lifecycleRules : ImmutableList.of();
    }

    public String getEtag() {
        return this.etag;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public Long getMetageneration() {
        return this.metageneration;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public List<Cors> getCors() {
        return this.cors;
    }

    public List<Acl> getAcl() {
        return this.acl;
    }

    public List<Acl> getDefaultAcl() {
        return this.defaultAcl;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getDefaultKmsKeyName() {
        return this.defaultKmsKeyName;
    }

    @BetaApi
    public Boolean getDefaultEventBasedHold() {
        return Data.isNull((Object)this.defaultEventBasedHold) ? null : this.defaultEventBasedHold;
    }

    @BetaApi
    public Long getRetentionEffectiveTime() {
        return this.retentionEffectiveTime;
    }

    @BetaApi
    public Boolean retentionPolicyIsLocked() {
        return Data.isNull((Object)this.retentionPolicyIsLocked) ? null : this.retentionPolicyIsLocked;
    }

    @BetaApi
    public Long getRetentionPeriod() {
        return this.retentionPeriod;
    }

    @BetaApi
    public IamConfiguration getIamConfiguration() {
        return this.iamConfiguration;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(BucketInfo.class) && Objects.equals(this.toPb(), ((BucketInfo)obj).toPb());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    Bucket toPb() {
        Bucket bucketPb = new Bucket();
        bucketPb.setId(this.generatedId);
        bucketPb.setName(this.name);
        bucketPb.setEtag(this.etag);
        if (this.createTime != null) {
            bucketPb.setTimeCreated(new DateTime(this.createTime.longValue()));
        }
        if (this.updateTime != null) {
            bucketPb.setUpdated(new DateTime(this.updateTime.longValue()));
        }
        if (this.metageneration != null) {
            bucketPb.setMetageneration(this.metageneration);
        }
        if (this.location != null) {
            bucketPb.setLocation(this.location);
        }
        if (this.locationType != null) {
            bucketPb.setLocationType(this.locationType);
        }
        if (this.storageClass != null) {
            bucketPb.setStorageClass(this.storageClass.toString());
        }
        if (this.cors != null) {
            bucketPb.setCors(Lists.transform(this.cors, Cors.TO_PB_FUNCTION));
        }
        if (this.acl != null) {
            bucketPb.setAcl(Lists.transform(this.acl, (Function)new Function<Acl, BucketAccessControl>(){

                public BucketAccessControl apply(Acl acl) {
                    return acl.toBucketPb();
                }
            }));
        }
        if (this.defaultAcl != null) {
            bucketPb.setDefaultObjectAcl(Lists.transform(this.defaultAcl, (Function)new Function<Acl, ObjectAccessControl>(){

                public ObjectAccessControl apply(Acl acl) {
                    return acl.toObjectPb();
                }
            }));
        }
        if (this.owner != null) {
            bucketPb.setOwner(new Bucket.Owner().setEntity(this.owner.toPb()));
        }
        bucketPb.setSelfLink(this.selfLink);
        if (this.versioningEnabled != null) {
            bucketPb.setVersioning(new Bucket.Versioning().setEnabled(this.versioningEnabled));
        }
        if (this.requesterPays != null) {
            Bucket.Billing billing = new Bucket.Billing();
            billing.setRequesterPays(this.requesterPays);
            bucketPb.setBilling(billing);
        }
        if (this.indexPage != null || this.notFoundPage != null) {
            Bucket.Website website = new Bucket.Website();
            website.setMainPageSuffix(this.indexPage);
            website.setNotFoundPage(this.notFoundPage);
            bucketPb.setWebsite(website);
        }
        HashSet rules = new HashSet();
        if (this.deleteRules != null) {
            rules.addAll(Lists.transform(this.deleteRules, (Function)new Function<DeleteRule, Bucket.Lifecycle.Rule>(){

                public Bucket.Lifecycle.Rule apply(DeleteRule deleteRule) {
                    return deleteRule.toPb();
                }
            }));
        }
        if (this.lifecycleRules != null) {
            rules.addAll(Lists.transform(this.lifecycleRules, (Function)new Function<LifecycleRule, Bucket.Lifecycle.Rule>(){

                public Bucket.Lifecycle.Rule apply(LifecycleRule lifecycleRule) {
                    return lifecycleRule.toPb();
                }
            }));
        }
        if (rules != null) {
            Bucket.Lifecycle lifecycle = new Bucket.Lifecycle();
            lifecycle.setRule((List)ImmutableList.copyOf(rules));
            bucketPb.setLifecycle(lifecycle);
        }
        if (this.labels != null) {
            bucketPb.setLabels(this.labels);
        }
        if (this.defaultKmsKeyName != null) {
            bucketPb.setEncryption(new Bucket.Encryption().setDefaultKmsKeyName(this.defaultKmsKeyName));
        }
        if (this.defaultEventBasedHold != null) {
            bucketPb.setDefaultEventBasedHold(this.defaultEventBasedHold);
        }
        if (this.retentionPeriod != null) {
            if (Data.isNull((Object)this.retentionPeriod)) {
                bucketPb.setRetentionPolicy((Bucket.RetentionPolicy)Data.nullOf(Bucket.RetentionPolicy.class));
            } else {
                Bucket.RetentionPolicy retentionPolicy = new Bucket.RetentionPolicy();
                retentionPolicy.setRetentionPeriod(this.retentionPeriod);
                if (this.retentionEffectiveTime != null) {
                    retentionPolicy.setEffectiveTime(new DateTime(this.retentionEffectiveTime.longValue()));
                }
                if (this.retentionPolicyIsLocked != null) {
                    retentionPolicy.setIsLocked(this.retentionPolicyIsLocked);
                }
                bucketPb.setRetentionPolicy(retentionPolicy);
            }
        }
        if (this.iamConfiguration != null) {
            bucketPb.setIamConfiguration(this.iamConfiguration.toPb());
        }
        if (this.logging != null) {
            bucketPb.setLogging(this.logging.toPb());
        }
        return bucketPb;
    }

    public static BucketInfo of(String name) {
        return BucketInfo.newBuilder(name).build();
    }

    public static Builder newBuilder(String name) {
        return new BuilderImpl(name);
    }

    static BucketInfo fromPb(Bucket bucketPb) {
        Bucket.Logging logging;
        Bucket.RetentionPolicy retentionPolicy;
        Bucket.Encryption encryption;
        Bucket.Billing billing;
        Bucket.Website website;
        BuilderImpl builder = new BuilderImpl(bucketPb.getName());
        if (bucketPb.getId() != null) {
            ((Builder)builder).setGeneratedId(bucketPb.getId());
        }
        if (bucketPb.getEtag() != null) {
            ((Builder)builder).setEtag(bucketPb.getEtag());
        }
        if (bucketPb.getMetageneration() != null) {
            ((Builder)builder).setMetageneration(bucketPb.getMetageneration());
        }
        if (bucketPb.getSelfLink() != null) {
            ((Builder)builder).setSelfLink(bucketPb.getSelfLink());
        }
        if (bucketPb.getTimeCreated() != null) {
            ((Builder)builder).setCreateTime(bucketPb.getTimeCreated().getValue());
        }
        if (bucketPb.getUpdated() != null) {
            ((Builder)builder).setUpdateTime(bucketPb.getUpdated().getValue());
        }
        if (bucketPb.getLocation() != null) {
            ((Builder)builder).setLocation(bucketPb.getLocation());
        }
        if (bucketPb.getStorageClass() != null) {
            ((Builder)builder).setStorageClass(StorageClass.valueOf(bucketPb.getStorageClass()));
        }
        if (bucketPb.getCors() != null) {
            ((Builder)builder).setCors(Lists.transform((List)bucketPb.getCors(), Cors.FROM_PB_FUNCTION));
        }
        if (bucketPb.getAcl() != null) {
            ((Builder)builder).setAcl(Lists.transform((List)bucketPb.getAcl(), (Function)new Function<BucketAccessControl, Acl>(){

                public Acl apply(BucketAccessControl bucketAccessControl) {
                    return Acl.fromPb(bucketAccessControl);
                }
            }));
        }
        if (bucketPb.getDefaultObjectAcl() != null) {
            ((Builder)builder).setDefaultAcl(Lists.transform((List)bucketPb.getDefaultObjectAcl(), (Function)new Function<ObjectAccessControl, Acl>(){

                public Acl apply(ObjectAccessControl objectAccessControl) {
                    return Acl.fromPb(objectAccessControl);
                }
            }));
        }
        if (bucketPb.getOwner() != null) {
            ((Builder)builder).setOwner(Acl.Entity.fromPb(bucketPb.getOwner().getEntity()));
        }
        if (bucketPb.getVersioning() != null) {
            ((Builder)builder).setVersioningEnabled(bucketPb.getVersioning().getEnabled());
        }
        if ((website = bucketPb.getWebsite()) != null) {
            ((Builder)builder).setIndexPage(website.getMainPageSuffix());
            ((Builder)builder).setNotFoundPage(website.getNotFoundPage());
        }
        if (bucketPb.getLifecycle() != null && bucketPb.getLifecycle().getRule() != null) {
            ((Builder)builder).setLifecycleRules(Lists.transform((List)bucketPb.getLifecycle().getRule(), (Function)new Function<Bucket.Lifecycle.Rule, LifecycleRule>(){

                public LifecycleRule apply(Bucket.Lifecycle.Rule rule) {
                    return LifecycleRule.fromPb(rule);
                }
            }));
            ((Builder)builder).setDeleteRules(Lists.transform((List)bucketPb.getLifecycle().getRule(), (Function)new Function<Bucket.Lifecycle.Rule, DeleteRule>(){

                public DeleteRule apply(Bucket.Lifecycle.Rule rule) {
                    return DeleteRule.fromPb(rule);
                }
            }));
        }
        if (bucketPb.getLabels() != null) {
            ((Builder)builder).setLabels(bucketPb.getLabels());
        }
        if ((billing = bucketPb.getBilling()) != null) {
            ((Builder)builder).setRequesterPays(billing.getRequesterPays());
        }
        if ((encryption = bucketPb.getEncryption()) != null && encryption.getDefaultKmsKeyName() != null && !encryption.getDefaultKmsKeyName().isEmpty()) {
            ((Builder)builder).setDefaultKmsKeyName(encryption.getDefaultKmsKeyName());
        }
        if (bucketPb.getDefaultEventBasedHold() != null) {
            ((Builder)builder).setDefaultEventBasedHold(bucketPb.getDefaultEventBasedHold());
        }
        if ((retentionPolicy = bucketPb.getRetentionPolicy()) != null) {
            if (retentionPolicy.getEffectiveTime() != null) {
                ((Builder)builder).setRetentionEffectiveTime(retentionPolicy.getEffectiveTime().getValue());
            }
            if (retentionPolicy.getIsLocked() != null) {
                ((Builder)builder).setRetentionPolicyIsLocked(retentionPolicy.getIsLocked());
            }
            if (retentionPolicy.getRetentionPeriod() != null) {
                ((Builder)builder).setRetentionPeriod(retentionPolicy.getRetentionPeriod());
            }
        }
        Bucket.IamConfiguration iamConfiguration = bucketPb.getIamConfiguration();
        if (bucketPb.getLocationType() != null) {
            ((Builder)builder).setLocationType(bucketPb.getLocationType());
        }
        if (iamConfiguration != null) {
            ((Builder)builder).setIamConfiguration(IamConfiguration.fromPb(iamConfiguration));
        }
        if ((logging = bucketPb.getLogging()) != null) {
            ((Builder)builder).setLogging(Logging.fromPb(logging));
        }
        return ((Builder)builder).build();
    }

    static final class BuilderImpl
    extends Builder {
        private String generatedId;
        private String name;
        private Acl.Entity owner;
        private String selfLink;
        private Boolean requesterPays;
        private Boolean versioningEnabled;
        private String indexPage;
        private String notFoundPage;
        private List<DeleteRule> deleteRules;
        private List<LifecycleRule> lifecycleRules;
        private StorageClass storageClass;
        private String location;
        private String etag;
        private Long createTime;
        private Long updateTime;
        private Long metageneration;
        private List<Cors> cors;
        private List<Acl> acl;
        private List<Acl> defaultAcl;
        private Map<String, String> labels;
        private String defaultKmsKeyName;
        private Boolean defaultEventBasedHold;
        private Long retentionEffectiveTime;
        private Boolean retentionPolicyIsLocked;
        private Long retentionPeriod;
        private IamConfiguration iamConfiguration;
        private String locationType;
        private Logging logging;

        BuilderImpl(String name) {
            this.name = name;
        }

        BuilderImpl(BucketInfo bucketInfo) {
            this.generatedId = bucketInfo.generatedId;
            this.name = bucketInfo.name;
            this.etag = bucketInfo.etag;
            this.createTime = bucketInfo.createTime;
            this.updateTime = bucketInfo.updateTime;
            this.metageneration = bucketInfo.metageneration;
            this.location = bucketInfo.location;
            this.storageClass = bucketInfo.storageClass;
            this.cors = bucketInfo.cors;
            this.acl = bucketInfo.acl;
            this.defaultAcl = bucketInfo.defaultAcl;
            this.owner = bucketInfo.owner;
            this.selfLink = bucketInfo.selfLink;
            this.versioningEnabled = bucketInfo.versioningEnabled;
            this.indexPage = bucketInfo.indexPage;
            this.notFoundPage = bucketInfo.notFoundPage;
            this.deleteRules = bucketInfo.deleteRules;
            this.lifecycleRules = bucketInfo.lifecycleRules;
            this.labels = bucketInfo.labels;
            this.requesterPays = bucketInfo.requesterPays;
            this.defaultKmsKeyName = bucketInfo.defaultKmsKeyName;
            this.defaultEventBasedHold = bucketInfo.defaultEventBasedHold;
            this.retentionEffectiveTime = bucketInfo.retentionEffectiveTime;
            this.retentionPolicyIsLocked = bucketInfo.retentionPolicyIsLocked;
            this.retentionPeriod = bucketInfo.retentionPeriod;
            this.iamConfiguration = bucketInfo.iamConfiguration;
            this.locationType = bucketInfo.locationType;
            this.logging = bucketInfo.logging;
        }

        @Override
        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        Builder setOwner(Acl.Entity owner) {
            this.owner = owner;
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setVersioningEnabled(Boolean enable) {
            this.versioningEnabled = (Boolean)MoreObjects.firstNonNull((Object)enable, (Object)Data.nullOf(Boolean.class));
            return this;
        }

        @Override
        public Builder setRequesterPays(Boolean enable) {
            this.requesterPays = (Boolean)MoreObjects.firstNonNull((Object)enable, (Object)Data.nullOf(Boolean.class));
            return this;
        }

        @Override
        public Builder setIndexPage(String indexPage) {
            this.indexPage = indexPage;
            return this;
        }

        @Override
        public Builder setNotFoundPage(String notFoundPage) {
            this.notFoundPage = notFoundPage;
            return this;
        }

        @Override
        @Deprecated
        public Builder setDeleteRules(Iterable<? extends DeleteRule> rules) {
            this.deleteRules = rules != null ? ImmutableList.copyOf(rules) : null;
            return this;
        }

        @Override
        public Builder setLifecycleRules(Iterable<? extends LifecycleRule> rules) {
            this.lifecycleRules = rules != null ? ImmutableList.copyOf(rules) : ImmutableList.of();
            return this;
        }

        @Override
        public Builder deleteLifecycleRules() {
            this.setDeleteRules(null);
            this.setLifecycleRules(null);
            return this;
        }

        @Override
        public Builder setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        Builder setCreateTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        Builder setUpdateTime(Long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        Builder setMetageneration(Long metageneration) {
            this.metageneration = metageneration;
            return this;
        }

        @Override
        public Builder setCors(Iterable<Cors> cors) {
            this.cors = cors != null ? ImmutableList.copyOf(cors) : ImmutableList.of();
            return this;
        }

        @Override
        public Builder setAcl(Iterable<Acl> acl) {
            this.acl = acl != null ? ImmutableList.copyOf(acl) : null;
            return this;
        }

        @Override
        public Builder setDefaultAcl(Iterable<Acl> acl) {
            this.defaultAcl = acl != null ? ImmutableList.copyOf(acl) : null;
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            if (labels != null) {
                this.labels = Maps.transformValues(labels, (Function)new Function<String, String>(){

                    public String apply(String input) {
                        return input == null ? (String)Data.nullOf(String.class) : input;
                    }
                });
            }
            return this;
        }

        @Override
        public Builder setDefaultKmsKeyName(String defaultKmsKeyName) {
            this.defaultKmsKeyName = defaultKmsKeyName != null ? defaultKmsKeyName : (String)Data.nullOf(String.class);
            return this;
        }

        @Override
        public Builder setDefaultEventBasedHold(Boolean defaultEventBasedHold) {
            this.defaultEventBasedHold = (Boolean)MoreObjects.firstNonNull((Object)defaultEventBasedHold, (Object)Data.nullOf(Boolean.class));
            return this;
        }

        @Override
        Builder setRetentionEffectiveTime(Long retentionEffectiveTime) {
            this.retentionEffectiveTime = (Long)MoreObjects.firstNonNull((Object)retentionEffectiveTime, (Object)Data.nullOf(Long.class));
            return this;
        }

        @Override
        Builder setRetentionPolicyIsLocked(Boolean retentionPolicyIsLocked) {
            this.retentionPolicyIsLocked = (Boolean)MoreObjects.firstNonNull((Object)retentionPolicyIsLocked, (Object)Data.nullOf(Boolean.class));
            return this;
        }

        @Override
        public Builder setRetentionPeriod(Long retentionPeriod) {
            this.retentionPeriod = (Long)MoreObjects.firstNonNull((Object)retentionPeriod, (Object)Data.nullOf(Long.class));
            return this;
        }

        @Override
        public Builder setIamConfiguration(IamConfiguration iamConfiguration) {
            this.iamConfiguration = iamConfiguration;
            return this;
        }

        @Override
        public Builder setLogging(Logging logging) {
            this.logging = logging != null ? logging : Logging.newBuilder().build();
            return this;
        }

        @Override
        Builder setLocationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        @Override
        public BucketInfo build() {
            Preconditions.checkNotNull((Object)this.name);
            return new BucketInfo(this);
        }
    }

    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setName(String var1);

        abstract Builder setGeneratedId(String var1);

        abstract Builder setOwner(Acl.Entity var1);

        abstract Builder setSelfLink(String var1);

        public abstract Builder setRequesterPays(Boolean var1);

        public abstract Builder setVersioningEnabled(Boolean var1);

        public abstract Builder setIndexPage(String var1);

        public abstract Builder setNotFoundPage(String var1);

        @Deprecated
        public abstract Builder setDeleteRules(Iterable<? extends DeleteRule> var1);

        public abstract Builder setLifecycleRules(Iterable<? extends LifecycleRule> var1);

        public abstract Builder deleteLifecycleRules();

        public abstract Builder setStorageClass(StorageClass var1);

        public abstract Builder setLocation(String var1);

        abstract Builder setEtag(String var1);

        abstract Builder setCreateTime(Long var1);

        abstract Builder setUpdateTime(Long var1);

        abstract Builder setMetageneration(Long var1);

        abstract Builder setLocationType(String var1);

        public abstract Builder setCors(Iterable<Cors> var1);

        public abstract Builder setAcl(Iterable<Acl> var1);

        public abstract Builder setDefaultAcl(Iterable<Acl> var1);

        public abstract Builder setLabels(Map<String, String> var1);

        public abstract Builder setDefaultKmsKeyName(String var1);

        @BetaApi
        public abstract Builder setDefaultEventBasedHold(Boolean var1);

        @BetaApi
        abstract Builder setRetentionEffectiveTime(Long var1);

        @BetaApi
        abstract Builder setRetentionPolicyIsLocked(Boolean var1);

        @BetaApi
        public abstract Builder setRetentionPeriod(Long var1);

        @BetaApi
        public abstract Builder setIamConfiguration(IamConfiguration var1);

        public abstract Builder setLogging(Logging var1);

        public abstract BucketInfo build();
    }

    @Deprecated
    public static class IsLiveDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = -3502994563121313364L;
        private final boolean isLive;

        public IsLiveDeleteRule(boolean isLive) {
            super(DeleteRule.Type.IS_LIVE);
            this.isLive = isLive;
        }

        public boolean isLive() {
            return this.isLive;
        }

        @Override
        void populateCondition(Bucket.Lifecycle.Rule.Condition condition) {
            condition.setIsLive(Boolean.valueOf(this.isLive));
        }
    }

    @Deprecated
    public static class NumNewerVersionsDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = -1955554976528303894L;
        private final int numNewerVersions;

        public NumNewerVersionsDeleteRule(int numNewerVersions) {
            super(DeleteRule.Type.NUM_NEWER_VERSIONS);
            this.numNewerVersions = numNewerVersions;
        }

        public int getNumNewerVersions() {
            return this.numNewerVersions;
        }

        @Override
        void populateCondition(Bucket.Lifecycle.Rule.Condition condition) {
            condition.setNumNewerVersions(Integer.valueOf(this.numNewerVersions));
        }
    }

    @Deprecated
    public static class CreatedBeforeDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = 881692650279195867L;
        private final long timeMillis;

        public CreatedBeforeDeleteRule(long timeMillis) {
            super(DeleteRule.Type.CREATE_BEFORE);
            this.timeMillis = timeMillis;
        }

        public long getTimeMillis() {
            return this.timeMillis;
        }

        @Override
        void populateCondition(Bucket.Lifecycle.Rule.Condition condition) {
            condition.setCreatedBefore(new DateTime(true, this.timeMillis, Integer.valueOf(0)));
        }
    }

    static class RawDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = -7166938278642301933L;
        private transient Bucket.Lifecycle.Rule rule;

        RawDeleteRule(Bucket.Lifecycle.Rule rule) {
            super(DeleteRule.Type.UNKNOWN);
            this.rule = rule;
        }

        @Override
        void populateCondition(Bucket.Lifecycle.Rule.Condition condition) {
            throw new UnsupportedOperationException();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeUTF(this.rule.toString());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.rule = (Bucket.Lifecycle.Rule)new JacksonFactory().fromString(in.readUTF(), Bucket.Lifecycle.Rule.class);
        }

        @Override
        Bucket.Lifecycle.Rule toPb() {
            return this.rule;
        }
    }

    @Deprecated
    public static class AgeDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = 5697166940712116380L;
        private final int daysToLive;

        public AgeDeleteRule(int daysToLive) {
            super(DeleteRule.Type.AGE);
            this.daysToLive = daysToLive;
        }

        public int getDaysToLive() {
            return this.daysToLive;
        }

        @Override
        void populateCondition(Bucket.Lifecycle.Rule.Condition condition) {
            condition.setAge(Integer.valueOf(this.daysToLive));
        }
    }

    @Deprecated
    public static abstract class DeleteRule
    implements Serializable {
        private static final long serialVersionUID = 3137971668395933033L;
        private static final String SUPPORTED_ACTION = "Delete";
        private final Type type;

        DeleteRule(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DeleteRule other = (DeleteRule)obj;
            return Objects.equals(this.toPb(), other.toPb());
        }

        Bucket.Lifecycle.Rule toPb() {
            Bucket.Lifecycle.Rule rule = new Bucket.Lifecycle.Rule();
            rule.setAction(new Bucket.Lifecycle.Rule.Action().setType(SUPPORTED_ACTION));
            Bucket.Lifecycle.Rule.Condition condition = new Bucket.Lifecycle.Rule.Condition();
            this.populateCondition(condition);
            rule.setCondition(condition);
            return rule;
        }

        abstract void populateCondition(Bucket.Lifecycle.Rule.Condition var1);

        static DeleteRule fromPb(Bucket.Lifecycle.Rule rule) {
            if (rule.getAction() != null && SUPPORTED_ACTION.endsWith(rule.getAction().getType())) {
                Bucket.Lifecycle.Rule.Condition condition = rule.getCondition();
                Integer age = condition.getAge();
                if (age != null) {
                    return new AgeDeleteRule(age);
                }
                DateTime dateTime = condition.getCreatedBefore();
                if (dateTime != null) {
                    return new CreatedBeforeDeleteRule(dateTime.getValue());
                }
                Integer numNewerVersions = condition.getNumNewerVersions();
                if (numNewerVersions != null) {
                    return new NumNewerVersionsDeleteRule(numNewerVersions);
                }
                Boolean isLive = condition.getIsLive();
                if (isLive != null) {
                    return new IsLiveDeleteRule(isLive);
                }
            }
            return new RawDeleteRule(rule);
        }

        public static enum Type {
            AGE,
            CREATE_BEFORE,
            NUM_NEWER_VERSIONS,
            IS_LIVE,
            UNKNOWN;

        }
    }

    public static class LifecycleRule
    implements Serializable {
        private static final long serialVersionUID = -5739807320148748613L;
        private final LifecycleAction lifecycleAction;
        private final LifecycleCondition lifecycleCondition;

        public LifecycleRule(LifecycleAction action, LifecycleCondition condition) {
            if (condition.getIsLive() == null && condition.getAge() == null && condition.getCreatedBefore() == null && condition.getMatchesStorageClass() == null && condition.getNumberOfNewerVersions() == null && condition.getDaysSinceNoncurrentTime() == null && condition.getNoncurrentTimeBefore() == null && condition.getCustomTimeBefore() == null && condition.getDaysSinceCustomTime() == null) {
                throw new IllegalArgumentException("You must specify at least one condition to use object lifecycle management. Please see https://cloud.google.com/storage/docs/lifecycle for details.");
            }
            this.lifecycleAction = action;
            this.lifecycleCondition = condition;
        }

        public LifecycleAction getAction() {
            return this.lifecycleAction;
        }

        public LifecycleCondition getCondition() {
            return this.lifecycleCondition;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lifecycleAction", (Object)this.lifecycleAction).add("lifecycleCondition", (Object)this.lifecycleCondition).toString();
        }

        public int hashCode() {
            return Objects.hash(this.lifecycleAction, this.lifecycleCondition);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LifecycleRule other = (LifecycleRule)obj;
            return Objects.equals(this.toPb(), other.toPb());
        }

        Bucket.Lifecycle.Rule toPb() {
            Bucket.Lifecycle.Rule rule = new Bucket.Lifecycle.Rule();
            Bucket.Lifecycle.Rule.Action action = new Bucket.Lifecycle.Rule.Action().setType(this.lifecycleAction.getActionType());
            if (this.lifecycleAction.getActionType().equals("SetStorageClass")) {
                action.setStorageClass(((SetStorageClassLifecycleAction)this.lifecycleAction).getStorageClass().toString());
            }
            rule.setAction(action);
            Bucket.Lifecycle.Rule.Condition condition = new Bucket.Lifecycle.Rule.Condition().setAge(this.lifecycleCondition.getAge()).setCreatedBefore(this.lifecycleCondition.getCreatedBefore() == null ? null : new DateTime(true, this.lifecycleCondition.getCreatedBefore().getValue(), Integer.valueOf(0))).setIsLive(this.lifecycleCondition.getIsLive()).setNumNewerVersions(this.lifecycleCondition.getNumberOfNewerVersions()).setMatchesStorageClass(this.lifecycleCondition.getMatchesStorageClass() == null ? null : Lists.transform(this.lifecycleCondition.getMatchesStorageClass(), (Function)Functions.toStringFunction())).setDaysSinceNoncurrentTime(this.lifecycleCondition.getDaysSinceNoncurrentTime()).setNoncurrentTimeBefore(this.lifecycleCondition.getNoncurrentTimeBefore() == null ? null : new DateTime(true, this.lifecycleCondition.getNoncurrentTimeBefore().getValue(), Integer.valueOf(0))).setCustomTimeBefore(this.lifecycleCondition.getCustomTimeBefore() == null ? null : new DateTime(true, this.lifecycleCondition.getCustomTimeBefore().getValue(), Integer.valueOf(0))).setDaysSinceCustomTime(this.lifecycleCondition.getDaysSinceCustomTime());
            rule.setCondition(condition);
            return rule;
        }

        static LifecycleRule fromPb(Bucket.Lifecycle.Rule rule) {
            LifecycleAction lifecycleAction;
            Bucket.Lifecycle.Rule.Action action = rule.getAction();
            switch (action.getType()) {
                case "Delete": {
                    lifecycleAction = LifecycleAction.newDeleteAction();
                    break;
                }
                case "SetStorageClass": {
                    lifecycleAction = LifecycleAction.newSetStorageClassAction(StorageClass.valueOf(action.getStorageClass()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("The specified lifecycle action " + action.getType() + " is not currently supported");
                }
            }
            Bucket.Lifecycle.Rule.Condition condition = rule.getCondition();
            LifecycleCondition.Builder conditionBuilder = LifecycleCondition.newBuilder().setAge(condition.getAge()).setCreatedBefore(condition.getCreatedBefore()).setIsLive(condition.getIsLive()).setNumberOfNewerVersions(condition.getNumNewerVersions()).setMatchesStorageClass(condition.getMatchesStorageClass() == null ? null : Lists.transform((List)condition.getMatchesStorageClass(), (Function)new Function<String, StorageClass>(){

                public StorageClass apply(String storageClass) {
                    return StorageClass.valueOf(storageClass);
                }
            })).setDaysSinceNoncurrentTime(condition.getDaysSinceNoncurrentTime()).setNoncurrentTimeBefore(condition.getNoncurrentTimeBefore()).setCustomTimeBefore(condition.getCustomTimeBefore()).setDaysSinceCustomTime(condition.getDaysSinceCustomTime());
            return new LifecycleRule(lifecycleAction, conditionBuilder.build());
        }

        public static class SetStorageClassLifecycleAction
        extends LifecycleAction {
            public static final String TYPE = "SetStorageClass";
            private static final long serialVersionUID = -62615467186000899L;
            private final StorageClass storageClass;

            private SetStorageClassLifecycleAction(StorageClass storageClass) {
                this.storageClass = storageClass;
            }

            @Override
            public String getActionType() {
                return TYPE;
            }

            @Override
            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("actionType", (Object)this.getActionType()).add("storageClass", (Object)this.storageClass.name()).toString();
            }

            public StorageClass getStorageClass() {
                return this.storageClass;
            }
        }

        public static class DeleteLifecycleAction
        extends LifecycleAction {
            public static final String TYPE = "Delete";
            private static final long serialVersionUID = -2050986302222644873L;

            private DeleteLifecycleAction() {
            }

            @Override
            public String getActionType() {
                return TYPE;
            }
        }

        public static abstract class LifecycleAction
        implements Serializable {
            private static final long serialVersionUID = 5801228724709173284L;

            public abstract String getActionType();

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("actionType", (Object)this.getActionType()).toString();
            }

            public static DeleteLifecycleAction newDeleteAction() {
                return new DeleteLifecycleAction();
            }

            public static SetStorageClassLifecycleAction newSetStorageClassAction(StorageClass storageClass) {
                return new SetStorageClassLifecycleAction(storageClass);
            }
        }

        public static class LifecycleCondition
        implements Serializable {
            private static final long serialVersionUID = -6482314338394768785L;
            private final Integer age;
            private final DateTime createdBefore;
            private final Integer numberOfNewerVersions;
            private final Boolean isLive;
            private final List<StorageClass> matchesStorageClass;
            private final Integer daysSinceNoncurrentTime;
            private final DateTime noncurrentTimeBefore;
            private final DateTime customTimeBefore;
            private final Integer daysSinceCustomTime;

            private LifecycleCondition(Builder builder) {
                this.age = builder.age;
                this.createdBefore = builder.createdBefore;
                this.numberOfNewerVersions = builder.numberOfNewerVersions;
                this.isLive = builder.isLive;
                this.matchesStorageClass = builder.matchesStorageClass;
                this.daysSinceNoncurrentTime = builder.daysSinceNoncurrentTime;
                this.noncurrentTimeBefore = builder.noncurrentTimeBefore;
                this.customTimeBefore = builder.customTimeBefore;
                this.daysSinceCustomTime = builder.daysSinceCustomTime;
            }

            public Builder toBuilder() {
                return LifecycleCondition.newBuilder().setAge(this.age).setCreatedBefore(this.createdBefore).setNumberOfNewerVersions(this.numberOfNewerVersions).setIsLive(this.isLive).setMatchesStorageClass(this.matchesStorageClass).setDaysSinceNoncurrentTime(this.daysSinceNoncurrentTime).setNoncurrentTimeBefore(this.noncurrentTimeBefore).setCustomTimeBefore(this.customTimeBefore).setDaysSinceCustomTime(this.daysSinceCustomTime);
            }

            public static Builder newBuilder() {
                return new Builder();
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("age", (Object)this.age).add("createBefore", (Object)this.createdBefore).add("numberofNewerVersions", (Object)this.numberOfNewerVersions).add("isLive", (Object)this.isLive).add("matchesStorageClass", this.matchesStorageClass).add("daysSinceNoncurrentTime", (Object)this.daysSinceNoncurrentTime).add("noncurrentTimeBefore", (Object)this.noncurrentTimeBefore).add("customTimeBefore", (Object)this.customTimeBefore).add("daysSinceCustomTime", (Object)this.daysSinceCustomTime).toString();
            }

            public Integer getAge() {
                return this.age;
            }

            public DateTime getCreatedBefore() {
                return this.createdBefore;
            }

            public Integer getNumberOfNewerVersions() {
                return this.numberOfNewerVersions;
            }

            public Boolean getIsLive() {
                return this.isLive;
            }

            public List<StorageClass> getMatchesStorageClass() {
                return this.matchesStorageClass;
            }

            public Integer getDaysSinceNoncurrentTime() {
                return this.daysSinceNoncurrentTime;
            }

            public DateTime getNoncurrentTimeBefore() {
                return this.noncurrentTimeBefore;
            }

            public DateTime getCustomTimeBefore() {
                return this.customTimeBefore;
            }

            public Integer getDaysSinceCustomTime() {
                return this.daysSinceCustomTime;
            }

            public static class Builder {
                private Integer age;
                private DateTime createdBefore;
                private Integer numberOfNewerVersions;
                private Boolean isLive;
                private List<StorageClass> matchesStorageClass;
                private Integer daysSinceNoncurrentTime;
                private DateTime noncurrentTimeBefore;
                private DateTime customTimeBefore;
                private Integer daysSinceCustomTime;

                private Builder() {
                }

                public Builder setAge(Integer age) {
                    this.age = age;
                    return this;
                }

                public Builder setCreatedBefore(DateTime createdBefore) {
                    this.createdBefore = createdBefore;
                    return this;
                }

                public Builder setNumberOfNewerVersions(Integer numberOfNewerVersions) {
                    this.numberOfNewerVersions = numberOfNewerVersions;
                    return this;
                }

                public Builder setIsLive(Boolean live) {
                    this.isLive = live;
                    return this;
                }

                public Builder setMatchesStorageClass(List<StorageClass> matchesStorageClass) {
                    this.matchesStorageClass = matchesStorageClass;
                    return this;
                }

                public Builder setDaysSinceNoncurrentTime(Integer daysSinceNoncurrentTime) {
                    this.daysSinceNoncurrentTime = daysSinceNoncurrentTime;
                    return this;
                }

                public Builder setNoncurrentTimeBefore(DateTime noncurrentTimeBefore) {
                    this.noncurrentTimeBefore = noncurrentTimeBefore;
                    return this;
                }

                public Builder setCustomTimeBefore(DateTime customTimeBefore) {
                    this.customTimeBefore = customTimeBefore;
                    return this;
                }

                public Builder setDaysSinceCustomTime(Integer daysSinceCustomTime) {
                    this.daysSinceCustomTime = daysSinceCustomTime;
                    return this;
                }

                public LifecycleCondition build() {
                    return new LifecycleCondition(this);
                }
            }
        }
    }

    public static class Logging
    implements Serializable {
        private static final long serialVersionUID = -708892101216778492L;
        private String logBucket;
        private String logObjectPrefix;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Logging other = (Logging)o;
            return Objects.equals(this.toPb(), other.toPb());
        }

        public int hashCode() {
            return Objects.hash(this.logBucket, this.logObjectPrefix);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.logBucket = this.logBucket;
            builder.logObjectPrefix = this.logObjectPrefix;
            return builder;
        }

        public String getLogBucket() {
            return this.logBucket;
        }

        public String getLogObjectPrefix() {
            return this.logObjectPrefix;
        }

        Bucket.Logging toPb() {
            Bucket.Logging logging;
            if (this.logBucket != null || this.logObjectPrefix != null) {
                logging = new Bucket.Logging();
                logging.setLogBucket(this.logBucket);
                logging.setLogObjectPrefix(this.logObjectPrefix);
            } else {
                logging = (Bucket.Logging)Data.nullOf(Bucket.Logging.class);
            }
            return logging;
        }

        static Logging fromPb(Bucket.Logging logging) {
            return Logging.newBuilder().setLogBucket(logging.getLogBucket()).setLogObjectPrefix(logging.getLogObjectPrefix()).build();
        }

        private Logging(Builder builder) {
            this.logBucket = builder.logBucket;
            this.logObjectPrefix = builder.logObjectPrefix;
        }

        public static class Builder {
            private String logBucket;
            private String logObjectPrefix;

            public Builder setLogBucket(String logBucket) {
                this.logBucket = logBucket;
                return this;
            }

            public Builder setLogObjectPrefix(String logObjectPrefix) {
                this.logObjectPrefix = logObjectPrefix;
                return this;
            }

            public Logging build() {
                return new Logging(this);
            }
        }
    }

    public static class IamConfiguration
    implements Serializable {
        private static final long serialVersionUID = -8671736104909424616L;
        private Boolean isUniformBucketLevelAccessEnabled;
        private Long uniformBucketLevelAccessLockedTime;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IamConfiguration other = (IamConfiguration)o;
            return Objects.equals(this.toPb(), other.toPb());
        }

        public int hashCode() {
            return Objects.hash(this.isUniformBucketLevelAccessEnabled, this.uniformBucketLevelAccessLockedTime);
        }

        private IamConfiguration(Builder builder) {
            this.isUniformBucketLevelAccessEnabled = builder.isUniformBucketLevelAccessEnabled;
            this.uniformBucketLevelAccessLockedTime = builder.uniformBucketLevelAccessLockedTime;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.isUniformBucketLevelAccessEnabled = this.isUniformBucketLevelAccessEnabled;
            builder.uniformBucketLevelAccessLockedTime = this.uniformBucketLevelAccessLockedTime;
            return builder;
        }

        @Deprecated
        public Boolean isBucketPolicyOnlyEnabled() {
            return this.isUniformBucketLevelAccessEnabled;
        }

        @Deprecated
        public Long getBucketPolicyOnlyLockedTime() {
            return this.uniformBucketLevelAccessLockedTime;
        }

        public Boolean isUniformBucketLevelAccessEnabled() {
            return this.isUniformBucketLevelAccessEnabled;
        }

        public Long getUniformBucketLevelAccessLockedTime() {
            return this.uniformBucketLevelAccessLockedTime;
        }

        Bucket.IamConfiguration toPb() {
            Bucket.IamConfiguration iamConfiguration = new Bucket.IamConfiguration();
            Bucket.IamConfiguration.UniformBucketLevelAccess uniformBucketLevelAccess = new Bucket.IamConfiguration.UniformBucketLevelAccess();
            uniformBucketLevelAccess.setEnabled(this.isUniformBucketLevelAccessEnabled);
            uniformBucketLevelAccess.setLockedTime(this.uniformBucketLevelAccessLockedTime == null ? null : new DateTime(this.uniformBucketLevelAccessLockedTime.longValue()));
            iamConfiguration.setUniformBucketLevelAccess(uniformBucketLevelAccess);
            return iamConfiguration;
        }

        static IamConfiguration fromPb(Bucket.IamConfiguration iamConfiguration) {
            Bucket.IamConfiguration.UniformBucketLevelAccess uniformBucketLevelAccess = iamConfiguration.getUniformBucketLevelAccess();
            DateTime lockedTime = uniformBucketLevelAccess.getLockedTime();
            return IamConfiguration.newBuilder().setIsUniformBucketLevelAccessEnabled(uniformBucketLevelAccess.getEnabled()).setUniformBucketLevelAccessLockedTime(lockedTime == null ? null : Long.valueOf(lockedTime.getValue())).build();
        }

        public static class Builder {
            private Boolean isUniformBucketLevelAccessEnabled;
            private Long uniformBucketLevelAccessLockedTime;

            @Deprecated
            public Builder setIsBucketPolicyOnlyEnabled(Boolean isBucketPolicyOnlyEnabled) {
                this.isUniformBucketLevelAccessEnabled = isBucketPolicyOnlyEnabled;
                return this;
            }

            @Deprecated
            Builder setBucketPolicyOnlyLockedTime(Long bucketPolicyOnlyLockedTime) {
                this.uniformBucketLevelAccessLockedTime = bucketPolicyOnlyLockedTime;
                return this;
            }

            public Builder setIsUniformBucketLevelAccessEnabled(Boolean isUniformBucketLevelAccessEnabled) {
                this.isUniformBucketLevelAccessEnabled = isUniformBucketLevelAccessEnabled;
                return this;
            }

            Builder setUniformBucketLevelAccessLockedTime(Long uniformBucketLevelAccessLockedTime) {
                this.uniformBucketLevelAccessLockedTime = uniformBucketLevelAccessLockedTime;
                return this;
            }

            public IamConfiguration build() {
                return new IamConfiguration(this);
            }
        }
    }
}

