/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.Timestamp;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncResultSetImpl;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.AsyncTransactionManagerImpl;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingAsyncResultSet;
import com.google.cloud.spanner.ForwardingResultSet;
import com.google.cloud.spanner.InstanceNotFoundException;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MetricRegistryConstants;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPoolAsyncTransactionManager;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.Empty;
import com.google.spanner.v1.ResultSetStats;
import io.opencensus.common.Scope;
import io.opencensus.metrics.DerivedLongCumulative;
import io.opencensus.metrics.DerivedLongGauge;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.MetricOptions;
import io.opencensus.metrics.MetricRegistry;
import io.opencensus.metrics.Metrics;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

class SessionPool {
    private static final Logger logger = Logger.getLogger(SessionPool.class.getName());
    private static final Tracer tracer = Tracing.getTracer();
    static final String WAIT_FOR_SESSION = "SessionPool.WaitForSession";
    static final ImmutableSet<ErrorCode> SHOULD_STOP_PREPARE_SESSIONS_ERROR_CODES = ImmutableSet.of((Object)((Object)ErrorCode.UNKNOWN), (Object)((Object)ErrorCode.INVALID_ARGUMENT), (Object)((Object)ErrorCode.PERMISSION_DENIED), (Object)((Object)ErrorCode.UNAUTHENTICATED), (Object)((Object)ErrorCode.RESOURCE_EXHAUSTED), (Object)((Object)ErrorCode.FAILED_PRECONDITION), (Object[])new ErrorCode[]{ErrorCode.OUT_OF_RANGE, ErrorCode.UNIMPLEMENTED, ErrorCode.INTERNAL});
    @VisibleForTesting
    static final Statement DETERMINE_DIALECT_STATEMENT = Statement.newBuilder("SELECT 'POSTGRESQL' AS DIALECT\nFROM INFORMATION_SCHEMA.SCHEMATA\nWHERE SCHEMA_NAME='information_schema'\nUNION ALL\nSELECT 'GOOGLE_STANDARD_SQL' AS DIALECT\nFROM INFORMATION_SCHEMA.SCHEMATA\nWHERE SCHEMA_NAME='INFORMATION_SCHEMA' AND CATALOG_NAME=''").build();
    private final SessionPoolOptions options;
    private final SettableFuture<Dialect> dialect = SettableFuture.create();
    private final SessionClient sessionClient;
    private final ScheduledExecutorService executor;
    private final GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    final PoolMaintainer poolMaintainer;
    private final Clock clock;
    private final Object lock = new Object();
    private final Random random = new Random();
    @GuardedBy(value="lock")
    private boolean detectDialectStarted;
    @GuardedBy(value="lock")
    private int pendingClosure;
    @GuardedBy(value="lock")
    private SettableFuture<Void> closureFuture;
    @GuardedBy(value="lock")
    private SpannerImpl.ClosedException closedException;
    @GuardedBy(value="lock")
    private SpannerException.ResourceNotFoundException resourceNotFoundException;
    @GuardedBy(value="lock")
    private boolean stopAutomaticPrepare;
    @GuardedBy(value="lock")
    private final LinkedList<PooledSession> sessions = new LinkedList();
    @GuardedBy(value="lock")
    private final Queue<WaiterFuture> waiters = new LinkedList<WaiterFuture>();
    @GuardedBy(value="lock")
    private int numSessionsBeingCreated = 0;
    @GuardedBy(value="lock")
    private int numSessionsInUse = 0;
    @GuardedBy(value="lock")
    private int maxSessionsInUse = 0;
    @GuardedBy(value="lock")
    private long numSessionsAcquired = 0L;
    @GuardedBy(value="lock")
    private long numSessionsReleased = 0L;
    @GuardedBy(value="lock")
    private long numIdleSessionsRemoved = 0L;
    private AtomicLong numWaiterTimeouts = new AtomicLong();
    @GuardedBy(value="lock")
    private final Set<PooledSession> allSessions = new HashSet<PooledSession>();
    @GuardedBy(value="lock")
    @VisibleForTesting
    final Set<PooledSessionFuture> checkedOutSessions = new HashSet<PooledSessionFuture>();
    private final SessionClient.SessionConsumer sessionConsumer = new SessionConsumerImpl();
    @VisibleForTesting
    Function<PooledSession, Void> idleSessionRemovedListener;

    private PooledSessionFuture createPooledSessionFuture(ListenableFuture<PooledSession> future, Span span) {
        return new PooledSessionFuture(future, span);
    }

    static SessionPool createPool(SpannerOptions spannerOptions, SessionClient sessionClient, List<LabelValue> labelValues) {
        return SessionPool.createPool(spannerOptions.getSessionPoolOptions(), (GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService>)((GrpcTransportOptions)spannerOptions.getTransportOptions()).getExecutorFactory(), sessionClient, new Clock(), Metrics.getMetricRegistry(), labelValues);
    }

    static SessionPool createPool(SessionPoolOptions poolOptions, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, SessionClient sessionClient) {
        return SessionPool.createPool(poolOptions, executorFactory, sessionClient, new Clock());
    }

    static SessionPool createPool(SessionPoolOptions poolOptions, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, SessionClient sessionClient, Clock clock) {
        return SessionPool.createPool(poolOptions, executorFactory, sessionClient, clock, Metrics.getMetricRegistry(), MetricRegistryConstants.SPANNER_DEFAULT_LABEL_VALUES);
    }

    static SessionPool createPool(SessionPoolOptions poolOptions, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, SessionClient sessionClient, Clock clock, MetricRegistry metricRegistry, List<LabelValue> labelValues) {
        SessionPool pool = new SessionPool(poolOptions, executorFactory, (ScheduledExecutorService)executorFactory.get(), sessionClient, clock, metricRegistry, labelValues);
        pool.initPool();
        return pool;
    }

    private SessionPool(SessionPoolOptions options, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, ScheduledExecutorService executor, SessionClient sessionClient, Clock clock, MetricRegistry metricRegistry, List<LabelValue> labelValues) {
        this.options = options;
        this.executorFactory = executorFactory;
        this.executor = executor;
        this.sessionClient = sessionClient;
        this.clock = clock;
        this.poolMaintainer = new PoolMaintainer();
        this.initMetricsCollection(metricRegistry, labelValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dialect getDialect() {
        boolean mustDetectDialect = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.detectDialectStarted) {
                mustDetectDialect = true;
                this.detectDialectStarted = true;
            }
        }
        if (mustDetectDialect) {
            try (PooledSessionFuture session = this.getSession();){
                this.dialect.set((Object)session.get().determineDialect());
            }
        }
        try {
            return (Dialect)((Object)this.dialect.get(60L, TimeUnit.SECONDS));
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.asSpannerException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
        catch (TimeoutException timeoutException) {
            throw SpannerExceptionFactory.propagateTimeout(timeoutException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfSessionsInUse() {
        Object object = this.lock;
        synchronized (object) {
            return this.numSessionsInUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromPool(PooledSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                this.decrementPendingClosures(1);
                return;
            }
            session.markClosing();
            this.allSessions.remove(session);
            ++this.numIdleSessionsRemoved;
        }
        if (this.idleSessionRemovedListener != null) {
            this.idleSessionRemovedListener.apply((Object)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long numIdleSessionsRemoved() {
        Object object = this.lock;
        synchronized (object) {
            return this.numIdleSessionsRemoved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfSessionsInPool() {
        Object object = this.lock;
        synchronized (object) {
            return this.sessions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfSessionsBeingCreated() {
        Object object = this.lock;
        synchronized (object) {
            return this.numSessionsBeingCreated;
        }
    }

    @VisibleForTesting
    long getNumWaiterTimeouts() {
        return this.numWaiterTimeouts.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPool() {
        Object object = this.lock;
        synchronized (object) {
            this.poolMaintainer.init();
            if (this.options.getMinSessions() > 0) {
                this.createSessions(this.options.getMinSessions(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closureFuture != null;
        }
    }

    private void handleException(SpannerException e, PooledSession session) {
        if (this.isSessionNotFound(e)) {
            this.invalidateSession(session);
        } else {
            this.releaseSession(session, Position.FIRST);
        }
    }

    private boolean isSessionNotFound(SpannerException e) {
        return e.getErrorCode() == ErrorCode.NOT_FOUND && e.getMessage().contains("Session not found");
    }

    private boolean isDatabaseOrInstanceNotFound(SpannerException e) {
        return e instanceof DatabaseNotFoundException || e instanceof InstanceNotFoundException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSession(PooledSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                this.decrementPendingClosures(1);
                return;
            }
            this.allSessions.remove(session);
            this.createSessions(this.getAllowedCreateSessions(1), false);
        }
    }

    private PooledSession findSessionToKeepAlive(Queue<PooledSession> queue, Instant keepAliveThreshold, int numAlreadyChecked) {
        int numChecked = 0;
        Iterator iterator = queue.iterator();
        while (iterator.hasNext() && numChecked + numAlreadyChecked < this.options.getMinSessions() + this.options.getMaxIdleSessions() - this.numSessionsInUse) {
            PooledSession session = (PooledSession)iterator.next();
            if (session.lastUseTime.isBefore(keepAliveThreshold)) {
                iterator.remove();
                return session;
            }
            ++numChecked;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.closureFuture == null && this.resourceNotFoundException == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PooledSessionFuture getSession() throws SpannerException {
        Span span = Tracing.getTracer().getCurrentSpan();
        span.addAnnotation("Acquiring session");
        WaiterFuture waiter = null;
        PooledSession sess = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                span.addAnnotation("Pool has been closed");
                throw new IllegalStateException("Pool has been closed", this.closedException);
            }
            if (this.resourceNotFoundException != null) {
                span.addAnnotation("Database has been deleted");
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.NOT_FOUND, String.format("The session pool has been invalidated because a previous RPC returned 'Database not found': %s", this.resourceNotFoundException.getMessage()), (Throwable)((Object)this.resourceNotFoundException));
            }
            sess = this.sessions.poll();
            if (sess == null) {
                span.addAnnotation("No session available");
                this.maybeCreateSession();
                waiter = new WaiterFuture();
                this.waiters.add(waiter);
            } else {
                span.addAnnotation("Acquired session");
            }
            return this.checkoutSession(span, sess, waiter);
        }
    }

    private PooledSessionFuture checkoutSession(Span span, PooledSession readySession, WaiterFuture waiter) {
        Object sessionFuture;
        if (waiter != null) {
            logger.log(Level.FINE, "No session available in the pool. Blocking for one to become available/created");
            span.addAnnotation("Waiting for a session to come available");
            sessionFuture = waiter;
        } else {
            SettableFuture fut = SettableFuture.create();
            fut.set((Object)readySession);
            sessionFuture = fut;
        }
        PooledSessionFuture res = this.createPooledSessionFuture((ListenableFuture<PooledSession>)sessionFuture, span);
        res.markCheckedOut();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PooledSessionFuture replaceSession(SessionNotFoundException e, PooledSessionFuture session) {
        if (!this.options.isFailIfSessionNotFound() && session.get().allowReplacing) {
            Object object = this.lock;
            synchronized (object) {
                --this.numSessionsInUse;
                ++this.numSessionsReleased;
                this.checkedOutSessions.remove(session);
            }
            session.leakedException = null;
            this.invalidateSession(session.get());
            return this.getSession();
        }
        throw e;
    }

    private Annotation sessionAnnotation(Session session) {
        AttributeValue sessionId = AttributeValue.stringAttributeValue((String)session.getName());
        return Annotation.fromDescriptionAndAttributes((String)"Using Session", (Map)ImmutableMap.of((Object)"sessionId", (Object)sessionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumSessionsInUse() {
        Object object = this.lock;
        synchronized (object) {
            if (this.maxSessionsInUse < ++this.numSessionsInUse) {
                this.maxSessionsInUse = this.numSessionsInUse;
            }
            ++this.numSessionsAcquired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeCreateSession() {
        Span span = Tracing.getTracer().getCurrentSpan();
        Object object = this.lock;
        synchronized (object) {
            if (this.numWaiters() >= this.numSessionsBeingCreated) {
                if (this.canCreateSession()) {
                    span.addAnnotation("Creating sessions");
                    this.createSessions(this.getAllowedCreateSessions(this.options.getIncStep()), false);
                } else if (this.options.isFailIfPoolExhausted()) {
                    span.addAnnotation("Pool exhausted. Failing");
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.RESOURCE_EXHAUSTED, "No session available in the pool. Maximum number of sessions in the pool can be overridden by invoking SessionPoolOptions#Builder#setMaxSessions. Client can be made to block rather than fail by setting SessionPoolOptions#Builder#setBlockIfPoolExhausted.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSession(PooledSession session, Position position) {
        Preconditions.checkNotNull((Object)session);
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                return;
            }
            if (this.waiters.size() == 0) {
                switch (position) {
                    case RANDOM: {
                        if (!this.sessions.isEmpty()) {
                            int pos = this.random.nextInt(this.sessions.size() + 1);
                            this.sessions.add(pos, session);
                            break;
                        }
                    }
                    default: {
                        this.sessions.addFirst(session);
                        break;
                    }
                }
            } else {
                this.waiters.poll().put(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreateSessionsFailure(SpannerException e, int count) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < count && this.waiters.size() > 0; ++i) {
                this.waiters.poll().put(e);
            }
            if (!this.dialect.isDone()) {
                this.dialect.setException((Throwable)((Object)e));
            }
            if (this.isDatabaseOrInstanceNotFound(e)) {
                this.setResourceNotFoundException((SpannerException.ResourceNotFoundException)e);
                this.poolMaintainer.close();
            }
        }
    }

    void setResourceNotFoundException(SpannerException.ResourceNotFoundException e) {
        this.resourceNotFoundException = (SpannerException.ResourceNotFoundException)((Object)MoreObjects.firstNonNull((Object)((Object)this.resourceNotFoundException), (Object)((Object)e)));
    }

    private void decrementPendingClosures(int count) {
        this.pendingClosure -= count;
        if (this.pendingClosure == 0) {
            this.closureFuture.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Void> closeAsync(SpannerImpl.ClosedException closedException) {
        SettableFuture<Void> retFuture = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                throw new IllegalStateException("Close has already been invoked", this.closedException);
            }
            this.closedException = closedException;
            WaiterFuture waiter = this.waiters.poll();
            while (waiter != null) {
                waiter.put(SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Client has been closed"));
                waiter = this.waiters.poll();
            }
            this.closureFuture = SettableFuture.create();
            retFuture = this.closureFuture;
            this.pendingClosure = this.totalSessions() + this.numSessionsBeingCreated;
            if (!this.poolMaintainer.isClosed()) {
                ++this.pendingClosure;
                this.poolMaintainer.close();
            }
            this.sessions.clear();
            for (Session session : this.checkedOutSessions) {
                if (((PooledSessionFuture)session).leakedException == null) continue;
                if (this.options.isFailOnSessionLeak()) {
                    throw ((PooledSessionFuture)session).leakedException;
                }
                logger.log(Level.WARNING, "Leaked session", ((PooledSessionFuture)session).leakedException);
            }
            for (Session session : ImmutableList.copyOf(this.allSessions)) {
                if (((PooledSession)session).state == SessionState.CLOSING) continue;
                this.closeSessionAsync((PooledSession)session);
            }
            if (this.pendingClosure == 0) {
                this.closureFuture.set(null);
            }
        }
        retFuture.addListener(() -> this.executorFactory.release((ExecutorService)this.executor), MoreExecutors.directExecutor());
        return retFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int numWaiters() {
        Object object = this.lock;
        synchronized (object) {
            return this.waiters.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int totalSessions() {
        Object object = this.lock;
        synchronized (object) {
            return this.allSessions.size();
        }
    }

    private ApiFuture<Empty> closeSessionAsync(PooledSession sess) {
        ApiFuture<Empty> res = sess.delegate.asyncClose();
        res.addListener(() -> {
            Object object = this.lock;
            synchronized (object) {
                this.allSessions.remove(sess);
                if (this.isClosed()) {
                    this.decrementPendingClosures(1);
                    return;
                }
                if (this.numWaiters() > this.numSessionsBeingCreated) {
                    this.createSessions(this.getAllowedCreateSessions(this.numWaiters() - this.numSessionsBeingCreated), false);
                }
            }
        }, MoreExecutors.directExecutor());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAllowedCreateSessions(int wantedSessions) {
        Object object = this.lock;
        synchronized (object) {
            return Math.min(wantedSessions, this.options.getMaxSessions() - (this.totalSessions() + this.numSessionsBeingCreated));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCreateSession() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalSessions() + this.numSessionsBeingCreated < this.options.getMaxSessions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessions(int sessionCount, boolean distributeOverChannels) {
        logger.log(Level.FINE, String.format("Creating %d sessions", sessionCount));
        Object object = this.lock;
        synchronized (object) {
            this.numSessionsBeingCreated += sessionCount;
            try {
                this.sessionClient.asyncBatchCreateSessions(sessionCount, distributeOverChannels, this.sessionConsumer);
            }
            catch (Throwable t) {
                this.numSessionsBeingCreated -= sessionCount;
                if (this.isClosed()) {
                    this.decrementPendingClosures(sessionCount);
                }
                this.handleCreateSessionsFailure(SpannerExceptionFactory.newSpannerException(t), sessionCount);
            }
        }
    }

    private void initMetricsCollection(MetricRegistry metricRegistry, List<LabelValue> labelValues) {
        DerivedLongGauge maxInUseSessionsMetric = metricRegistry.addDerivedLongGauge("cloud.google.com/java/spanner/max_in_use_sessions", MetricOptions.builder().setDescription("The maximum number of sessions in use during the last 10 minute interval.").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS).build());
        DerivedLongGauge maxAllowedSessionsMetric = metricRegistry.addDerivedLongGauge("cloud.google.com/java/spanner/max_allowed_sessions", MetricOptions.builder().setDescription("The maximum number of sessions allowed. Configurable by the user.").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS).build());
        DerivedLongCumulative sessionsTimeouts = metricRegistry.addDerivedLongCumulative("cloud.google.com/java/spanner/get_session_timeouts", MetricOptions.builder().setDescription("The number of get sessions timeouts due to pool exhaustion").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS).build());
        DerivedLongCumulative numAcquiredSessionsMetric = metricRegistry.addDerivedLongCumulative("cloud.google.com/java/spanner/num_acquired_sessions", MetricOptions.builder().setDescription("The number of sessions acquired from the session pool.").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS).build());
        DerivedLongCumulative numReleasedSessionsMetric = metricRegistry.addDerivedLongCumulative("cloud.google.com/java/spanner/num_released_sessions", MetricOptions.builder().setDescription("The number of sessions released by the user and pool maintainer.").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS).build());
        DerivedLongGauge numSessionsInPoolMetric = metricRegistry.addDerivedLongGauge("cloud.google.com/java/spanner/num_sessions_in_pool", MetricOptions.builder().setDescription("The number of sessions in the pool.").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS_WITH_TYPE).build());
        maxInUseSessionsMetric.removeTimeSeries(labelValues);
        maxInUseSessionsMetric.createTimeSeries(labelValues, (Object)this, sessionPool -> sessionPool.maxSessionsInUse);
        maxAllowedSessionsMetric.removeTimeSeries(labelValues);
        maxAllowedSessionsMetric.createTimeSeries(labelValues, (Object)this.options, SessionPoolOptions::getMaxSessions);
        sessionsTimeouts.removeTimeSeries(labelValues);
        sessionsTimeouts.createTimeSeries(labelValues, (Object)this, SessionPool::getNumWaiterTimeouts);
        numAcquiredSessionsMetric.removeTimeSeries(labelValues);
        numAcquiredSessionsMetric.createTimeSeries(labelValues, (Object)this, sessionPool -> sessionPool.numSessionsAcquired);
        numReleasedSessionsMetric.removeTimeSeries(labelValues);
        numReleasedSessionsMetric.createTimeSeries(labelValues, (Object)this, sessionPool -> sessionPool.numSessionsReleased);
        ArrayList<LabelValue> labelValuesWithBeingPreparedType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithBeingPreparedType.add(MetricRegistryConstants.NUM_SESSIONS_BEING_PREPARED);
        numSessionsInPoolMetric.removeTimeSeries(labelValuesWithBeingPreparedType);
        numSessionsInPoolMetric.createTimeSeries(labelValuesWithBeingPreparedType, (Object)this, ignored -> 0L);
        ArrayList<LabelValue> labelValuesWithInUseType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithInUseType.add(MetricRegistryConstants.NUM_IN_USE_SESSIONS);
        numSessionsInPoolMetric.removeTimeSeries(labelValuesWithInUseType);
        numSessionsInPoolMetric.createTimeSeries(labelValuesWithInUseType, (Object)this, sessionPool -> sessionPool.numSessionsInUse);
        ArrayList<LabelValue> labelValuesWithReadType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithReadType.add(MetricRegistryConstants.NUM_READ_SESSIONS);
        numSessionsInPoolMetric.removeTimeSeries(labelValuesWithReadType);
        numSessionsInPoolMetric.createTimeSeries(labelValuesWithReadType, (Object)this, sessionPool -> sessionPool.sessions.size());
        ArrayList<LabelValue> labelValuesWithWriteType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithWriteType.add(MetricRegistryConstants.NUM_WRITE_SESSIONS);
        numSessionsInPoolMetric.removeTimeSeries(labelValuesWithWriteType);
        numSessionsInPoolMetric.createTimeSeries(labelValuesWithWriteType, (Object)this, ignored -> 0L);
    }

    class SessionConsumerImpl
    implements SessionClient.SessionConsumer {
        SessionConsumerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionReady(SessionImpl session) {
            PooledSession pooledSession = null;
            boolean closeSession = false;
            Object object = SessionPool.this.lock;
            synchronized (object) {
                pooledSession = new PooledSession(session);
                SessionPool.this.numSessionsBeingCreated--;
                if (SessionPool.this.closureFuture != null) {
                    closeSession = true;
                } else {
                    Preconditions.checkState((SessionPool.this.totalSessions() <= SessionPool.this.options.getMaxSessions() - 1 ? 1 : 0) != 0);
                    SessionPool.this.allSessions.add(pooledSession);
                    if (SessionPool.this.options.isAutoDetectDialect() && !SessionPool.this.detectDialectStarted) {
                        SessionPool.this.detectDialectStarted = true;
                        pooledSession.determineDialectAsync((SettableFuture<Dialect>)SessionPool.this.dialect);
                    } else {
                        SessionPool.this.releaseSession(pooledSession, Position.RANDOM);
                    }
                }
            }
            if (closeSession) {
                SessionPool.this.closeSessionAsync(pooledSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionCreateFailure(Throwable t, int createFailureForSessionCount) {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                SessionPool.this.numSessionsBeingCreated -= createFailureForSessionCount;
                if (SessionPool.this.isClosed()) {
                    SessionPool.this.decrementPendingClosures(createFailureForSessionCount);
                }
                SessionPool.this.handleCreateSessionsFailure(SpannerExceptionFactory.newSpannerException(t), createFailureForSessionCount);
            }
        }
    }

    private static enum Position {
        FIRST,
        RANDOM;

    }

    final class PoolMaintainer {
        private final Duration windowLength = Duration.ofMillis((long)TimeUnit.MINUTES.toMillis(10L));
        @VisibleForTesting
        final long loopFrequency = SessionPool.access$3000(SessionPool.this).getLoopFrequency();
        @VisibleForTesting
        final long numClosureCycles = this.windowLength.toMillis() / this.loopFrequency;
        private final Duration keepAliveMillis = Duration.ofMillis((long)TimeUnit.MINUTES.toMillis(SessionPool.access$3000(SessionPool.this).getKeepAliveIntervalMinutes()));
        @VisibleForTesting
        final long numKeepAliveCycles = this.keepAliveMillis.toMillis() / this.loopFrequency;
        Instant lastResetTime = Instant.ofEpochMilli((long)0L);
        int numSessionsToClose = 0;
        int sessionsToClosePerLoop = 0;
        boolean closed = false;
        @GuardedBy(value="lock")
        ScheduledFuture<?> scheduledFuture;
        @GuardedBy(value="lock")
        boolean running;

        PoolMaintainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                this.scheduledFuture = SessionPool.this.executor.scheduleAtFixedRate(this::maintainPool, this.loopFrequency, this.loopFrequency, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                if (!this.closed) {
                    this.closed = true;
                    this.scheduledFuture.cancel(false);
                    if (!this.running) {
                        SessionPool.this.decrementPendingClosures(1);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isClosed() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                return this.closed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maintainPool() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                if (SessionPool.this.isClosed()) {
                    return;
                }
                this.running = true;
            }
            Instant currTime = SessionPool.this.clock.instant();
            this.removeIdleSessions(currTime);
            this.keepAliveSessions(currTime);
            this.replenishPool();
            Object object2 = SessionPool.this.lock;
            synchronized (object2) {
                this.running = false;
                if (SessionPool.this.isClosed()) {
                    SessionPool.this.decrementPendingClosures(1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeIdleSessions(Instant currTime) {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                Instant minLastUseTime = currTime.minus((TemporalAmount)SessionPool.this.options.getRemoveInactiveSessionAfter());
                Iterator iterator = SessionPool.this.sessions.descendingIterator();
                while (iterator.hasNext()) {
                    PooledSession session = (PooledSession)iterator.next();
                    if (!session.lastUseTime.isBefore(minLastUseTime) || session.state == SessionState.CLOSING) continue;
                    SessionPool.this.removeFromPool(session);
                    iterator.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void keepAliveSessions(Instant currTime) {
            long numSessionsToKeepAlive = 0L;
            Object object = SessionPool.this.lock;
            synchronized (object) {
                if (SessionPool.this.numSessionsInUse >= SessionPool.this.options.getMinSessions() + SessionPool.this.options.getMaxIdleSessions()) {
                    return;
                }
                numSessionsToKeepAlive = (long)Math.ceil((double)(SessionPool.this.options.getMinSessions() + SessionPool.this.options.getMaxIdleSessions() - SessionPool.this.numSessionsInUse) / (double)this.numKeepAliveCycles);
            }
            Instant keepAliveThreshold = currTime.minus((TemporalAmount)this.keepAliveMillis);
            while (numSessionsToKeepAlive > 0L) {
                PooledSession sessionToKeepAlive = null;
                Object object2 = SessionPool.this.lock;
                synchronized (object2) {
                    sessionToKeepAlive = SessionPool.this.findSessionToKeepAlive(SessionPool.this.sessions, keepAliveThreshold, 0);
                }
                if (sessionToKeepAlive == null) break;
                try {
                    logger.log(Level.FINE, "Keeping alive session " + sessionToKeepAlive.getName());
                    --numSessionsToKeepAlive;
                    sessionToKeepAlive.keepAlive();
                    SessionPool.this.releaseSession(sessionToKeepAlive, Position.FIRST);
                }
                catch (SpannerException e) {
                    SessionPool.this.handleException(e, sessionToKeepAlive);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replenishPool() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                int sessionCount = SessionPool.this.options.getMinSessions() - (SessionPool.this.totalSessions() + SessionPool.this.numSessionsBeingCreated);
                if (sessionCount > 0) {
                    SessionPool.this.createSessions(SessionPool.this.getAllowedCreateSessions(sessionCount), false);
                }
            }
        }
    }

    private final class WaiterFuture
    extends ForwardingListenableFuture<PooledSession> {
        private static final long MAX_SESSION_WAIT_TIMEOUT = 240000L;
        private final SettableFuture<PooledSession> waiter = SettableFuture.create();

        private WaiterFuture() {
        }

        protected ListenableFuture<? extends PooledSession> delegate() {
            return this.waiter;
        }

        private void put(PooledSession session) {
            this.waiter.set((Object)session);
        }

        private void put(SpannerException e) {
            this.waiter.setException((Throwable)((Object)e));
        }

        public PooledSession get() {
            long currentTimeout = SessionPool.this.options.getInitialWaitForSessionTimeoutMillis();
            while (true) {
                Span span = tracer.spanBuilder(SessionPool.WAIT_FOR_SESSION).startSpan();
                try {
                    Scope waitScope = tracer.withSpan(span);
                    try {
                        PooledSession s = this.pollUninterruptiblyWithTimeout(currentTimeout);
                        if (s == null) {
                            SessionPool.this.numWaiterTimeouts.incrementAndGet();
                            tracer.getCurrentSpan().setStatus(Status.DEADLINE_EXCEEDED);
                            currentTimeout = Math.min(currentTimeout * 2L, 240000L);
                            continue;
                        }
                        PooledSession pooledSession = s;
                        return pooledSession;
                    }
                    finally {
                        if (waitScope == null) continue;
                        waitScope.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    TraceUtil.setWithFailure(span, e);
                    throw e;
                }
                finally {
                    span.end(TraceUtil.END_SPAN_OPTIONS);
                    continue;
                }
                break;
            }
        }

        private PooledSession pollUninterruptiblyWithTimeout(long timeoutMillis) {
            boolean interrupted = false;
            while (true) {
                try {
                    PooledSession pooledSession = (PooledSession)this.waiter.get(timeoutMillis, TimeUnit.MILLISECONDS);
                    return pooledSession;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                catch (TimeoutException e) {
                    PooledSession pooledSession = null;
                    return pooledSession;
                }
                catch (ExecutionException e) {
                    throw SpannerExceptionFactory.newSpannerException(e.getCause());
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    final class PooledSession
    implements Session {
        @VisibleForTesting
        SessionImpl delegate;
        private volatile Instant lastUseTime;
        private volatile SpannerException lastException;
        private volatile boolean allowReplacing = true;
        @GuardedBy(value="lock")
        private SessionState state;

        private PooledSession(SessionImpl delegate) {
            this.delegate = delegate;
            this.state = SessionState.AVAILABLE;
            this.lastUseTime = SessionPool.this.clock.instant();
        }

        public String toString() {
            return this.getName();
        }

        @VisibleForTesting
        void setAllowReplacing(boolean allowReplacing) {
            this.allowReplacing = allowReplacing;
        }

        @Override
        public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
            return this.writeWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
        }

        @Override
        public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            try {
                this.markUsed();
                return this.delegate.writeWithOptions(mutations, options);
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
        }

        @Override
        public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
            return this.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
        }

        @Override
        public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            try {
                this.markUsed();
                return this.delegate.writeAtLeastOnceWithOptions(mutations, options);
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
        }

        @Override
        public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) throws SpannerException {
            try {
                this.markUsed();
                return this.delegate.executePartitionedUpdate(stmt, options);
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
        }

        @Override
        public ReadContext singleUse() {
            return this.delegate.singleUse();
        }

        @Override
        public ReadContext singleUse(TimestampBound bound) {
            return this.delegate.singleUse(bound);
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction() {
            return this.delegate.singleUseReadOnlyTransaction();
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
            return this.delegate.singleUseReadOnlyTransaction(bound);
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction() {
            return this.delegate.readOnlyTransaction();
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
            return this.delegate.readOnlyTransaction(bound);
        }

        @Override
        public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
            return this.delegate.readWriteTransaction(options);
        }

        @Override
        public AsyncRunner runAsync(Options.TransactionOption ... options) {
            return this.delegate.runAsync(options);
        }

        @Override
        public AsyncTransactionManagerImpl transactionManagerAsync(Options.TransactionOption ... options) {
            return this.delegate.transactionManagerAsync(options);
        }

        @Override
        public ApiFuture<Empty> asyncClose() {
            this.close();
            return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                SessionPool.this.numSessionsInUse--;
                SessionPool.this.numSessionsReleased++;
            }
            if (this.lastException != null && SessionPool.this.isSessionNotFound(this.lastException)) {
                SessionPool.this.invalidateSession(this);
            } else {
                if (this.lastException != null && SessionPool.this.isDatabaseOrInstanceNotFound(this.lastException)) {
                    object = SessionPool.this.lock;
                    synchronized (object) {
                        SessionPool.this.resourceNotFoundException = (SpannerException.ResourceNotFoundException)((Object)MoreObjects.firstNonNull((Object)((Object)SessionPool.this.resourceNotFoundException), (Object)((Object)((SpannerException.ResourceNotFoundException)this.lastException))));
                    }
                }
                this.lastException = null;
                if (this.state != SessionState.CLOSING) {
                    this.state = SessionState.AVAILABLE;
                }
                SessionPool.this.releaseSession(this, Position.FIRST);
            }
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public void prepareReadWriteTransaction() {
            this.markUsed();
            this.delegate.prepareReadWriteTransaction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void keepAlive() {
            this.markUsed();
            Span previousSpan = this.delegate.getCurrentSpan();
            this.delegate.setCurrentSpan((Span)BlankSpan.INSTANCE);
            try (ResultSet resultSet = this.delegate.singleUse(TimestampBound.ofMaxStaleness(60L, TimeUnit.SECONDS)).executeQuery(Statement.newBuilder("SELECT 1").build(), new Options.QueryOption[0]);){
                resultSet.next();
            }
            finally {
                this.delegate.setCurrentSpan(previousSpan);
            }
        }

        private void determineDialectAsync(SettableFuture<Dialect> dialect) {
            Preconditions.checkNotNull(dialect);
            SessionPool.this.executor.submit(() -> {
                try {
                    dialect.set((Object)this.determineDialect());
                }
                catch (Throwable t) {
                    dialect.setException(t);
                }
                finally {
                    SessionPool.this.releaseSession(this, Position.FIRST);
                }
            });
        }

        private Dialect determineDialect() {
            try (ResultSet dialectResultSet = this.delegate.singleUse().executeQuery(DETERMINE_DIALECT_STATEMENT, new Options.QueryOption[0]);){
                if (dialectResultSet.next()) {
                    Dialect dialect = Dialect.fromName(dialectResultSet.getString(0));
                    return dialect;
                }
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.NOT_FOUND, "No dialect found for database");
            }
        }

        private void markBusy(Span span) {
            this.delegate.setCurrentSpan(span);
            this.state = SessionState.BUSY;
        }

        private void markClosing() {
            this.state = SessionState.CLOSING;
        }

        void markUsed() {
            this.lastUseTime = SessionPool.this.clock.instant();
        }

        @Override
        public TransactionManager transactionManager(Options.TransactionOption ... options) {
            return this.delegate.transactionManager(options);
        }
    }

    class PooledSessionFuture
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<PooledSession>
    implements Session {
        private volatile LeakedSessionException leakedException;
        private volatile AtomicBoolean inUse;
        private volatile CountDownLatch initialized;
        private final Span span;

        @VisibleForTesting
        PooledSessionFuture(ListenableFuture<PooledSession> delegate, Span span) {
            super(delegate);
            this.inUse = new AtomicBoolean();
            this.initialized = new CountDownLatch(1);
            this.span = span;
        }

        @VisibleForTesting
        void clearLeakedException() {
            this.leakedException = null;
        }

        private void markCheckedOut() {
            this.leakedException = new LeakedSessionException();
        }

        @Override
        public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
            return this.writeWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            try {
                CommitResponse commitResponse = this.get().writeWithOptions(mutations, options);
                return commitResponse;
            }
            finally {
                this.close();
            }
        }

        @Override
        public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
            return this.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            try {
                CommitResponse commitResponse = this.get().writeAtLeastOnceWithOptions(mutations, options);
                return commitResponse;
            }
            finally {
                this.close();
            }
        }

        @Override
        public ReadContext singleUse() {
            try {
                return new AutoClosingReadContext(session -> {
                    PooledSession ps = session.get();
                    return ps.delegate.singleUse();
                }, SessionPool.this, this, true);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadContext singleUse(TimestampBound bound) {
            try {
                return new AutoClosingReadContext(session -> {
                    PooledSession ps = session.get();
                    return ps.delegate.singleUse(bound);
                }, SessionPool.this, this, true);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction() {
            return this.internalReadOnlyTransaction((Function<PooledSessionFuture, ReadOnlyTransaction>)((Function)session -> {
                PooledSession ps = session.get();
                return ps.delegate.singleUseReadOnlyTransaction();
            }), true);
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
            return this.internalReadOnlyTransaction((Function<PooledSessionFuture, ReadOnlyTransaction>)((Function)session -> {
                PooledSession ps = session.get();
                return ps.delegate.singleUseReadOnlyTransaction(bound);
            }), true);
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction() {
            return this.internalReadOnlyTransaction((Function<PooledSessionFuture, ReadOnlyTransaction>)((Function)session -> {
                PooledSession ps = session.get();
                return ps.delegate.readOnlyTransaction();
            }), false);
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
            return this.internalReadOnlyTransaction((Function<PooledSessionFuture, ReadOnlyTransaction>)((Function)session -> {
                PooledSession ps = session.get();
                return ps.delegate.readOnlyTransaction(bound);
            }), false);
        }

        private ReadOnlyTransaction internalReadOnlyTransaction(Function<PooledSessionFuture, ReadOnlyTransaction> transactionSupplier, boolean isSingleUse) {
            try {
                return new AutoClosingReadTransaction(transactionSupplier, SessionPool.this, this, isSingleUse);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
            return new SessionPoolTransactionRunner(SessionPool.this, this, options);
        }

        @Override
        public TransactionManager transactionManager(Options.TransactionOption ... options) {
            return new AutoClosingTransactionManager(SessionPool.this, this, options);
        }

        @Override
        public AsyncRunner runAsync(Options.TransactionOption ... options) {
            return new SessionPoolAsyncRunner(SessionPool.this, this, options);
        }

        @Override
        public AsyncTransactionManager transactionManagerAsync(Options.TransactionOption ... options) {
            return new SessionPoolAsyncTransactionManager(SessionPool.this, this, options);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
            try {
                long l = this.get().executePartitionedUpdate(stmt, options);
                return l;
            }
            finally {
                this.close();
            }
        }

        @Override
        public String getName() {
            return this.get().getName();
        }

        @Override
        public void prepareReadWriteTransaction() {
            this.get().prepareReadWriteTransaction();
        }

        @Override
        public void close() {
            try {
                this.asyncClose().get();
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.asSpannerException(e.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ApiFuture<Empty> asyncClose() {
            try {
                PooledSession delegate = this.getOrNull();
                if (delegate != null) {
                    ApiFuture<Empty> apiFuture = delegate.asyncClose();
                    return apiFuture;
                }
            }
            finally {
                Object object = SessionPool.this.lock;
                synchronized (object) {
                    this.leakedException = null;
                    SessionPool.this.checkedOutSessions.remove(this);
                }
            }
            return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        }

        private PooledSession getOrNull() {
            try {
                return this.get();
            }
            catch (Throwable t) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PooledSession get() {
            if (this.inUse.compareAndSet(false, true)) {
                PooledSession res = null;
                try {
                    res = (PooledSession)super.get();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (res != null) {
                    res.markBusy(this.span);
                    this.span.addAnnotation(SessionPool.this.sessionAnnotation(res));
                    Object object = SessionPool.this.lock;
                    synchronized (object) {
                        SessionPool.this.incrementNumSessionsInUse();
                        SessionPool.this.checkedOutSessions.add(this);
                    }
                }
                this.initialized.countDown();
            }
            try {
                this.initialized.await();
                return (PooledSession)super.get();
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.newSpannerException(e.getCause());
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
        }
    }

    private static enum SessionState {
        AVAILABLE,
        BUSY,
        CLOSING;

    }

    final class LeakedSessionException
    extends RuntimeException {
        private static final long serialVersionUID = 1451131180314064914L;

        private LeakedSessionException() {
            super("Session was checked out from the pool at " + SessionPool.this.clock.instant());
        }
    }

    private static class SessionPoolAsyncRunner
    implements AsyncRunner {
        private final SessionPool sessionPool;
        private volatile PooledSessionFuture session;
        private final Options.TransactionOption[] options;
        private SettableApiFuture<CommitResponse> commitResponse;

        private SessionPoolAsyncRunner(SessionPool sessionPool, PooledSessionFuture session, Options.TransactionOption ... options) {
            this.sessionPool = sessionPool;
            this.session = session;
            this.options = options;
        }

        @Override
        public <R> ApiFuture<R> runAsync(AsyncRunner.AsyncWork<R> work, Executor executor) {
            this.commitResponse = SettableApiFuture.create();
            SettableApiFuture res = SettableApiFuture.create();
            executor.execute(() -> {
                SpannerException exception = null;
                Object r = null;
                AsyncRunner runner = null;
                while (true) {
                    SpannerException se = null;
                    try {
                        runner = this.session.get().runAsync(this.options);
                        r = runner.runAsync(work, MoreExecutors.directExecutor()).get();
                    }
                    catch (ExecutionException e) {
                        se = SpannerExceptionFactory.asSpannerException(e.getCause());
                        continue;
                    }
                    catch (InterruptedException e) {
                        se = SpannerExceptionFactory.propagateInterrupt(e);
                        continue;
                    }
                    catch (Throwable t) {
                        se = SpannerExceptionFactory.newSpannerException(t);
                        continue;
                    }
                    finally {
                        if (se instanceof SessionNotFoundException) {
                            try {
                                this.session = this.sessionPool.replaceSession((SessionNotFoundException)se, this.session);
                                se = null;
                                continue;
                            }
                            catch (SessionNotFoundException e) {
                                exception = e;
                                break;
                            }
                        }
                        exception = se;
                        break;
                        continue;
                    }
                    break;
                }
                this.session.get().markUsed();
                this.session.close();
                this.setCommitResponse(runner);
                if (exception != null) {
                    res.setException((Throwable)((Object)exception));
                } else {
                    res.set(r);
                }
            });
            return res;
        }

        private void setCommitResponse(AsyncRunner delegate) {
            try {
                this.commitResponse.set((Object)((CommitResponse)delegate.getCommitResponse().get()));
            }
            catch (Throwable t) {
                this.commitResponse.setException(t);
            }
        }

        @Override
        public ApiFuture<Timestamp> getCommitTimestamp() {
            Preconditions.checkState((this.commitResponse != null ? 1 : 0) != 0, (Object)"runAsync() has not yet been called");
            return ApiFutures.transform(this.commitResponse, CommitResponse::getCommitTimestamp, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public ApiFuture<CommitResponse> getCommitResponse() {
            Preconditions.checkState((this.commitResponse != null ? 1 : 0) != 0, (Object)"runAsync() has not yet been called");
            return this.commitResponse;
        }
    }

    private static final class SessionPoolTransactionRunner
    implements TransactionRunner {
        private final SessionPool sessionPool;
        private PooledSessionFuture session;
        private final Options.TransactionOption[] options;
        private TransactionRunner runner;

        private SessionPoolTransactionRunner(SessionPool sessionPool, PooledSessionFuture session, Options.TransactionOption ... options) {
            this.sessionPool = sessionPool;
            this.session = session;
            this.options = options;
        }

        private TransactionRunner getRunner() {
            if (this.runner == null) {
                this.runner = this.session.get().readWriteTransaction(this.options);
            }
            return this.runner;
        }

        @Override
        @Nullable
        public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
            try {
                T result;
                while (true) {
                    try {
                        result = this.getRunner().run(callable);
                    }
                    catch (SessionNotFoundException e) {
                        this.session = this.sessionPool.replaceSession(e, this.session);
                        PooledSession ps = this.session.get();
                        this.runner = ps.delegate.readWriteTransaction(new Options.TransactionOption[0]);
                        continue;
                    }
                    break;
                }
                this.session.get().markUsed();
                T t = result;
                return t;
            }
            catch (SpannerException e) {
                throw this.session.get().lastException = e;
            }
            finally {
                this.session.close();
            }
        }

        @Override
        public Timestamp getCommitTimestamp() {
            return this.getRunner().getCommitTimestamp();
        }

        @Override
        public CommitResponse getCommitResponse() {
            return this.getRunner().getCommitResponse();
        }

        @Override
        public TransactionRunner allowNestedTransaction() {
            this.getRunner().allowNestedTransaction();
            return this;
        }
    }

    private static class AutoClosingTransactionManager
    implements TransactionManager,
    SessionNotFoundHandler {
        private TransactionManager delegate;
        private final SessionPool sessionPool;
        private PooledSessionFuture session;
        private final Options.TransactionOption[] options;
        private boolean closed;
        private boolean restartedAfterSessionNotFound;

        AutoClosingTransactionManager(SessionPool sessionPool, PooledSessionFuture session, Options.TransactionOption ... options) {
            this.sessionPool = sessionPool;
            this.session = session;
            this.options = options;
        }

        @Override
        public TransactionContext begin() {
            this.delegate = this.session.get().transactionManager(this.options);
            return this.internalBegin();
        }

        private TransactionContext internalBegin() {
            SessionPoolTransactionContext res = new SessionPoolTransactionContext(this, this.delegate.begin());
            this.session.get().markUsed();
            return res;
        }

        @Override
        public SpannerException handleSessionNotFound(SessionNotFoundException notFoundException) {
            this.session = this.sessionPool.replaceSession(notFoundException, this.session);
            PooledSession pooledSession = this.session.get();
            this.delegate = pooledSession.delegate.transactionManager(this.options);
            this.restartedAfterSessionNotFound = true;
            return AutoClosingTransactionManager.createAbortedExceptionWithMinimalRetryDelay(notFoundException);
        }

        private static SpannerException createAbortedExceptionWithMinimalRetryDelay(SessionNotFoundException notFoundException) {
            return SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, notFoundException.getMessage(), (Throwable)SpannerExceptionFactory.createAbortedExceptionWithRetryDelay(notFoundException.getMessage(), (Throwable)((Object)notFoundException), 0L, 1));
        }

        @Override
        public void commit() {
            try {
                this.delegate.commit();
            }
            catch (SessionNotFoundException e) {
                throw this.handleSessionNotFound(e);
            }
            finally {
                if (this.getState() != TransactionManager.TransactionState.ABORTED) {
                    this.close();
                }
            }
        }

        @Override
        public void rollback() {
            try {
                this.delegate.rollback();
            }
            finally {
                this.close();
            }
        }

        @Override
        public TransactionContext resetForRetry() {
            while (true) {
                try {
                    if (this.restartedAfterSessionNotFound) {
                        SessionPoolTransactionContext res = new SessionPoolTransactionContext(this, this.delegate.begin());
                        this.restartedAfterSessionNotFound = false;
                        return res;
                    }
                    return new SessionPoolTransactionContext(this, this.delegate.resetForRetry());
                }
                catch (SessionNotFoundException e) {
                    this.session = this.sessionPool.replaceSession(e, this.session);
                    PooledSession pooledSession = this.session.get();
                    this.delegate = pooledSession.delegate.transactionManager(this.options);
                    this.restartedAfterSessionNotFound = true;
                    continue;
                }
                break;
            }
        }

        @Override
        public Timestamp getCommitTimestamp() {
            return this.delegate.getCommitTimestamp();
        }

        @Override
        public CommitResponse getCommitResponse() {
            return this.delegate.getCommitResponse();
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.delegate != null) {
                    this.delegate.close();
                }
            }
            finally {
                this.session.close();
            }
        }

        @Override
        public TransactionManager.TransactionState getState() {
            if (this.restartedAfterSessionNotFound) {
                return TransactionManager.TransactionState.ABORTED;
            }
            return this.delegate == null ? null : this.delegate.getState();
        }
    }

    static class SessionPoolTransactionContext
    implements TransactionContext {
        private final SessionNotFoundHandler handler;
        final TransactionContext delegate;

        SessionPoolTransactionContext(SessionNotFoundHandler handler, TransactionContext delegate) {
            this.handler = (SessionNotFoundHandler)Preconditions.checkNotNull((Object)handler);
            this.delegate = delegate;
        }

        @Override
        public ResultSet read(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return new SessionPoolResultSet(this.handler, this.delegate.read(table, keys, columns, options));
        }

        @Override
        public AsyncResultSet readAsync(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return new AsyncSessionPoolResultSet(this.handler, this.delegate.readAsync(table, keys, columns, options));
        }

        @Override
        public ResultSet readUsingIndex(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return new SessionPoolResultSet(this.handler, this.delegate.readUsingIndex(table, index, keys, columns, options));
        }

        @Override
        public AsyncResultSet readUsingIndexAsync(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return new AsyncSessionPoolResultSet(this.handler, this.delegate.readUsingIndexAsync(table, index, keys, columns, options));
        }

        @Override
        public Struct readRow(String table, Key key, Iterable<String> columns) {
            try {
                return this.delegate.readRow(table, key, columns);
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public ApiFuture<Struct> readRowAsync(String table, Key key, Iterable<String> columns) {
            try (AsyncResultSet rs = this.readAsync(table, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
                ApiFuture apiFuture = ApiFutures.catching(AbstractReadContext.consumeSingleRowAsync(rs), SessionNotFoundException.class, input -> {
                    throw this.handler.handleSessionNotFound((SessionNotFoundException)((Object)input));
                }, (Executor)MoreExecutors.directExecutor());
                return apiFuture;
            }
        }

        @Override
        public void buffer(Mutation mutation) {
            this.delegate.buffer(mutation);
        }

        @Override
        public ApiFuture<Void> bufferAsync(Mutation mutation) {
            return this.delegate.bufferAsync(mutation);
        }

        @Override
        public Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
            try {
                return this.delegate.readRowUsingIndex(table, index, key, columns);
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public ApiFuture<Struct> readRowUsingIndexAsync(String table, String index, Key key, Iterable<String> columns) {
            try (AsyncResultSet rs = this.readUsingIndexAsync(table, index, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
                ApiFuture apiFuture = ApiFutures.catching(AbstractReadContext.consumeSingleRowAsync(rs), SessionNotFoundException.class, input -> {
                    throw this.handler.handleSessionNotFound((SessionNotFoundException)((Object)input));
                }, (Executor)MoreExecutors.directExecutor());
                return apiFuture;
            }
        }

        @Override
        public void buffer(Iterable<Mutation> mutations) {
            this.delegate.buffer(mutations);
        }

        @Override
        public ApiFuture<Void> bufferAsync(Iterable<Mutation> mutations) {
            return this.delegate.bufferAsync(mutations);
        }

        @Override
        public ResultSetStats analyzeUpdate(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode, Options.UpdateOption ... options) {
            try {
                return this.delegate.analyzeUpdate(statement, analyzeMode, options);
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public long executeUpdate(Statement statement, Options.UpdateOption ... options) {
            try {
                return this.delegate.executeUpdate(statement, options);
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public ApiFuture<Long> executeUpdateAsync(Statement statement, Options.UpdateOption ... options) {
            return ApiFutures.catching(this.delegate.executeUpdateAsync(statement, options), SessionNotFoundException.class, input -> {
                throw this.handler.handleSessionNotFound((SessionNotFoundException)((Object)input));
            }, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public long[] batchUpdate(Iterable<Statement> statements, Options.UpdateOption ... options) {
            try {
                return this.delegate.batchUpdate(statements, options);
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public ApiFuture<long[]> batchUpdateAsync(Iterable<Statement> statements, Options.UpdateOption ... options) {
            return ApiFutures.catching(this.delegate.batchUpdateAsync(statements, options), SessionNotFoundException.class, input -> {
                throw this.handler.handleSessionNotFound((SessionNotFoundException)((Object)input));
            }, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public ResultSet executeQuery(Statement statement, Options.QueryOption ... options) {
            return new SessionPoolResultSet(this.handler, this.delegate.executeQuery(statement, options));
        }

        @Override
        public AsyncResultSet executeQueryAsync(Statement statement, Options.QueryOption ... options) {
            return new AsyncSessionPoolResultSet(this.handler, this.delegate.executeQueryAsync(statement, options));
        }

        @Override
        public ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode queryMode) {
            return new SessionPoolResultSet(this.handler, this.delegate.analyzeQuery(statement, queryMode));
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }

    static class AsyncSessionPoolResultSet
    extends ForwardingAsyncResultSet {
        private final SessionNotFoundHandler handler;

        private AsyncSessionPoolResultSet(SessionNotFoundHandler handler, AsyncResultSet delegate) {
            super(delegate);
            this.handler = (SessionNotFoundHandler)Preconditions.checkNotNull((Object)handler);
        }

        @Override
        public ApiFuture<Void> setCallback(Executor executor, AsyncResultSet.ReadyCallback callback) {
            return super.setCallback(executor, resultSet -> {
                try {
                    return callback.cursorReady(resultSet);
                }
                catch (SessionNotFoundException e) {
                    throw this.handler.handleSessionNotFound(e);
                }
            });
        }

        @Override
        public boolean next() {
            try {
                return super.next();
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public AsyncResultSet.CursorState tryNext() {
            try {
                return super.tryNext();
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }
    }

    static class SessionPoolResultSet
    extends ForwardingResultSet {
        private final SessionNotFoundHandler handler;

        private SessionPoolResultSet(SessionNotFoundHandler handler, ResultSet delegate) {
            super(delegate);
            this.handler = (SessionNotFoundHandler)Preconditions.checkNotNull((Object)handler);
        }

        @Override
        public boolean next() {
            try {
                return super.next();
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }
    }

    static interface SessionNotFoundHandler {
        public SpannerException handleSessionNotFound(SessionNotFoundException var1);
    }

    private static class AutoClosingReadTransaction
    extends AutoClosingReadContext<ReadOnlyTransaction>
    implements ReadOnlyTransaction {
        AutoClosingReadTransaction(Function<PooledSessionFuture, ReadOnlyTransaction> txnSupplier, SessionPool sessionPool, PooledSessionFuture session, boolean isSingleUse) {
            super(txnSupplier, sessionPool, session, isSingleUse);
        }

        @Override
        public Timestamp getReadTimestamp() {
            return ((ReadOnlyTransaction)this.getReadContextDelegate()).getReadTimestamp();
        }
    }

    private static class AutoClosingReadContext<T extends ReadContext>
    implements ReadContext {
        private final Function<PooledSessionFuture, T> readContextDelegateSupplier;
        private T readContextDelegate;
        private final SessionPool sessionPool;
        private final boolean isSingleUse;
        private final AtomicInteger asyncOperationsCount = new AtomicInteger();
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private boolean sessionUsedForQuery = false;
        @GuardedBy(value="lock")
        private PooledSessionFuture session;
        @GuardedBy(value="lock")
        private boolean closed;
        @GuardedBy(value="lock")
        private boolean delegateClosed;

        private AutoClosingReadContext(Function<PooledSessionFuture, T> delegateSupplier, SessionPool sessionPool, PooledSessionFuture session, boolean isSingleUse) {
            this.readContextDelegateSupplier = delegateSupplier;
            this.sessionPool = sessionPool;
            this.session = session;
            this.isSingleUse = isSingleUse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getReadContextDelegate() {
            Object object = this.lock;
            synchronized (object) {
                if (this.readContextDelegate == null) {
                    while (true) {
                        try {
                            this.readContextDelegate = (ReadContext)this.readContextDelegateSupplier.apply((Object)this.session);
                        }
                        catch (SessionNotFoundException e) {
                            this.replaceSessionIfPossible(e);
                            continue;
                        }
                        break;
                    }
                }
            }
            return this.readContextDelegate;
        }

        private ResultSet wrap(final CachedResultSetSupplier resultSetSupplier) {
            return new ForwardingResultSet(resultSetSupplier){
                private boolean beforeFirst;
                {
                    super((Supplier<ResultSet>)supplier);
                    this.beforeFirst = true;
                }

                @Override
                public boolean next() throws SpannerException {
                    block4: while (true) {
                        try {
                            return this.internalNext();
                        }
                        catch (SessionNotFoundException e) {
                            while (true) {
                                this.replaceSessionIfPossible(e);
                                try {
                                    this.replaceDelegate(resultSetSupplier.reload());
                                    continue block4;
                                }
                                catch (SessionNotFoundException snfe) {
                                    e = snfe;
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private boolean internalNext() {
                    try {
                        boolean ret = super.next();
                        if (this.beforeFirst) {
                            Object object = lock;
                            synchronized (object) {
                                session.get().markUsed();
                                this.beforeFirst = false;
                                sessionUsedForQuery = true;
                            }
                        }
                        if (!ret && isSingleUse) {
                            this.close();
                        }
                        return ret;
                    }
                    catch (SessionNotFoundException e) {
                        throw e;
                    }
                    catch (SpannerException e) {
                        Object object = lock;
                        synchronized (object) {
                            if (!closed && isSingleUse) {
                                session.get().lastException = e;
                                this.close();
                            }
                        }
                        throw e;
                    }
                }

                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        if (isSingleUse) {
                            this.close();
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceSessionIfPossible(SessionNotFoundException notFound) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isSingleUse && this.sessionUsedForQuery) {
                    throw notFound;
                }
                this.session = this.sessionPool.replaceSession(notFound, this.session);
                this.readContextDelegate = (ReadContext)this.readContextDelegateSupplier.apply((Object)this.session);
            }
        }

        @Override
        public ResultSet read(final String table, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            return this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().read(table, keys, columns, options);
                }
            });
        }

        @Override
        public AsyncResultSet readAsync(final String table, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            Options readOptions = Options.fromReadOptions(options);
            int bufferRows = readOptions.hasBufferRows() ? readOptions.bufferRows() : 10;
            return new AutoClosingReadContextAsyncResultSetImpl(this.sessionPool.sessionClient.getSpanner().getAsyncExecutorProvider(), this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().read(table, keys, columns, options);
                }
            }), bufferRows);
        }

        @Override
        public ResultSet readUsingIndex(final String table, final String index, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            return this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().readUsingIndex(table, index, keys, columns, options);
                }
            });
        }

        @Override
        public AsyncResultSet readUsingIndexAsync(final String table, final String index, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            Options readOptions = Options.fromReadOptions(options);
            int bufferRows = readOptions.hasBufferRows() ? readOptions.bufferRows() : 10;
            return new AutoClosingReadContextAsyncResultSetImpl(this.sessionPool.sessionClient.getSpanner().getAsyncExecutorProvider(), this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().readUsingIndex(table, index, keys, columns, options);
                }
            }), bufferRows);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Struct readRow(String table, Key key, Iterable<String> columns) {
            while (true) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.session.get().markUsed();
                    }
                    object = this.getReadContextDelegate().readRow(table, key, columns);
                    return object;
                }
                catch (SessionNotFoundException e) {
                    this.replaceSessionIfPossible(e);
                    continue;
                }
                break;
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.sessionUsedForQuery = true;
                }
                if (this.isSingleUse) {
                    this.close();
                }
            }
        }

        @Override
        public ApiFuture<Struct> readRowAsync(String table, Key key, Iterable<String> columns) {
            try (AsyncResultSet rs = this.readAsync(table, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
                ApiFuture<Struct> apiFuture = AbstractReadContext.consumeSingleRowAsync(rs);
                return apiFuture;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
            while (true) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.session.get().markUsed();
                    }
                    object = this.getReadContextDelegate().readRowUsingIndex(table, index, key, columns);
                    return object;
                }
                catch (SessionNotFoundException e) {
                    this.replaceSessionIfPossible(e);
                    continue;
                }
                break;
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.sessionUsedForQuery = true;
                }
                if (this.isSingleUse) {
                    this.close();
                }
            }
        }

        @Override
        public ApiFuture<Struct> readRowUsingIndexAsync(String table, String index, Key key, Iterable<String> columns) {
            try (AsyncResultSet rs = this.readUsingIndexAsync(table, index, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
                ApiFuture<Struct> apiFuture = AbstractReadContext.consumeSingleRowAsync(rs);
                return apiFuture;
            }
        }

        @Override
        public ResultSet executeQuery(final Statement statement, final Options.QueryOption ... options) {
            return this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().executeQuery(statement, options);
                }
            });
        }

        @Override
        public AsyncResultSet executeQueryAsync(final Statement statement, final Options.QueryOption ... options) {
            Options queryOptions = Options.fromQueryOptions(options);
            int bufferRows = queryOptions.hasBufferRows() ? queryOptions.bufferRows() : 10;
            return new AutoClosingReadContextAsyncResultSetImpl(this.sessionPool.sessionClient.getSpanner().getAsyncExecutorProvider(), this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().executeQuery(statement, options);
                }
            }), bufferRows);
        }

        @Override
        public ResultSet analyzeQuery(final Statement statement, final ReadContext.QueryAnalyzeMode queryMode) {
            return this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().analyzeQuery(statement, queryMode);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed && this.delegateClosed) {
                    return;
                }
                this.closed = true;
                if (this.asyncOperationsCount.get() == 0) {
                    if (this.readContextDelegate != null) {
                        this.readContextDelegate.close();
                    }
                    this.session.close();
                    this.delegateClosed = true;
                }
            }
        }

        private class AutoClosingReadContextAsyncResultSetImpl
        extends AsyncResultSetImpl {
            private AutoClosingReadContextAsyncResultSetImpl(ExecutorProvider executorProvider, ResultSet delegate, int bufferRows) {
                super(executorProvider, delegate, bufferRows);
            }

            @Override
            public ApiFuture<Void> setCallback(Executor exec, AsyncResultSet.ReadyCallback cb) {
                Runnable listener = () -> {
                    Object object = AutoClosingReadContext.this.lock;
                    synchronized (object) {
                        if (AutoClosingReadContext.this.asyncOperationsCount.decrementAndGet() == 0 && AutoClosingReadContext.this.closed) {
                            AutoClosingReadContext.this.close();
                        }
                    }
                };
                try {
                    AutoClosingReadContext.this.asyncOperationsCount.incrementAndGet();
                    this.addListener(listener);
                    return super.setCallback(exec, cb);
                }
                catch (Throwable t) {
                    this.removeListener(listener);
                    AutoClosingReadContext.this.asyncOperationsCount.decrementAndGet();
                    throw t;
                }
            }
        }
    }

    private static abstract class CachedResultSetSupplier
    implements Supplier<ResultSet> {
        private ResultSet cached;

        private CachedResultSetSupplier() {
        }

        abstract ResultSet load();

        ResultSet reload() {
            this.cached = this.load();
            return this.cached;
        }

        public ResultSet get() {
            if (this.cached == null) {
                this.cached = this.load();
            }
            return this.cached;
        }
    }

    static class Clock {
        Clock() {
        }

        Instant instant() {
            return Instant.now();
        }
    }
}

