/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.encryption;

import com.google.cloud.spanner.encryption.BackupEncryptionConfig;
import com.google.cloud.spanner.encryption.CustomerManagedEncryption;
import com.google.cloud.spanner.encryption.GoogleDefaultEncryption;
import com.google.cloud.spanner.encryption.RestoreEncryptionConfig;
import com.google.cloud.spanner.encryption.UseBackupEncryption;
import com.google.cloud.spanner.encryption.UseDatabaseEncryption;
import com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig;
import com.google.spanner.admin.database.v1.EncryptionConfig;
import com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig;

public class EncryptionConfigProtoMapper {
    public static EncryptionConfig encryptionConfig(CustomerManagedEncryption config) {
        return EncryptionConfig.newBuilder().setKmsKeyName(config.getKmsKeyName()).build();
    }

    public static CreateBackupEncryptionConfig createBackupEncryptionConfig(BackupEncryptionConfig config) {
        if (config instanceof CustomerManagedEncryption) {
            return CreateBackupEncryptionConfig.newBuilder().setEncryptionType(CreateBackupEncryptionConfig.EncryptionType.CUSTOMER_MANAGED_ENCRYPTION).setKmsKeyName(((CustomerManagedEncryption)config).getKmsKeyName()).build();
        }
        if (config instanceof GoogleDefaultEncryption) {
            return CreateBackupEncryptionConfig.newBuilder().setEncryptionType(CreateBackupEncryptionConfig.EncryptionType.GOOGLE_DEFAULT_ENCRYPTION).build();
        }
        if (config instanceof UseDatabaseEncryption) {
            return CreateBackupEncryptionConfig.newBuilder().setEncryptionType(CreateBackupEncryptionConfig.EncryptionType.USE_DATABASE_ENCRYPTION).build();
        }
        throw new IllegalArgumentException("Unknown backup encryption configuration " + config);
    }

    public static RestoreDatabaseEncryptionConfig restoreDatabaseEncryptionConfig(RestoreEncryptionConfig config) {
        if (config instanceof CustomerManagedEncryption) {
            return RestoreDatabaseEncryptionConfig.newBuilder().setEncryptionType(RestoreDatabaseEncryptionConfig.EncryptionType.CUSTOMER_MANAGED_ENCRYPTION).setKmsKeyName(((CustomerManagedEncryption)config).getKmsKeyName()).build();
        }
        if (config instanceof GoogleDefaultEncryption) {
            return RestoreDatabaseEncryptionConfig.newBuilder().setEncryptionType(RestoreDatabaseEncryptionConfig.EncryptionType.GOOGLE_DEFAULT_ENCRYPTION).build();
        }
        if (config instanceof UseBackupEncryption) {
            return RestoreDatabaseEncryptionConfig.newBuilder().setEncryptionType(RestoreDatabaseEncryptionConfig.EncryptionType.USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION).build();
        }
        throw new IllegalArgumentException("Unknown restore encryption configuration " + config);
    }
}

