/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.common.base.Preconditions;
import java.util.Arrays;

final class RetriableBatchUpdate
implements ReadWriteTransaction.RetriableStatement {
    private final ReadWriteTransaction transaction;
    private final Iterable<Statement> statements;
    private final long[] updateCounts;
    private final Options.UpdateOption[] options;

    RetriableBatchUpdate(ReadWriteTransaction transaction, Iterable<Statement> statements, long[] updateCounts, Options.UpdateOption ... options) {
        Preconditions.checkNotNull((Object)transaction);
        Preconditions.checkNotNull(statements);
        this.transaction = transaction;
        this.statements = statements;
        this.updateCounts = updateCounts;
        this.options = options;
    }

    @Override
    public void retry(AbortedException aborted) throws AbortedException {
        long[] newCount;
        try {
            this.transaction.getStatementExecutor().invokeInterceptors(AbstractStatementParser.RUN_BATCH_STATEMENT, StatementExecutionStep.RETRY_STATEMENT, this.transaction);
            newCount = this.transaction.getReadContext().batchUpdate(this.statements, this.options);
        }
        catch (AbortedException e) {
            throw e;
        }
        catch (SpannerException e) {
            throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted, e);
        }
        if (newCount == null || !Arrays.equals(this.updateCounts, newCount)) {
            throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted);
        }
    }
}

