/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.CredentialsService;
import com.google.cloud.spanner.connection.LocalConnectionChecker;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.spanner.v1.ExecuteSqlRequest;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@InternalApi
public class ConnectionOptions {
    private static final LocalConnectionChecker LOCAL_CONNECTION_CHECKER = new LocalConnectionChecker();
    private static final boolean DEFAULT_USE_PLAIN_TEXT = false;
    static final boolean DEFAULT_AUTOCOMMIT = true;
    static final boolean DEFAULT_READONLY = false;
    static final boolean DEFAULT_RETRY_ABORTS_INTERNALLY = true;
    private static final String DEFAULT_CREDENTIALS = null;
    private static final String DEFAULT_OAUTH_TOKEN = null;
    private static final String DEFAULT_MIN_SESSIONS = null;
    private static final String DEFAULT_MAX_SESSIONS = null;
    private static final String DEFAULT_NUM_CHANNELS = null;
    private static final String DEFAULT_CHANNEL_PROVIDER = null;
    private static final String DEFAULT_USER_AGENT = null;
    private static final String DEFAULT_OPTIMIZER_VERSION = "";
    private static final String DEFAULT_OPTIMIZER_STATISTICS_PACKAGE = "";
    private static final Options.RpcPriority DEFAULT_RPC_PRIORITY = null;
    private static final boolean DEFAULT_RETURN_COMMIT_STATS = false;
    private static final boolean DEFAULT_LENIENT = false;
    private static final String PLAIN_TEXT_PROTOCOL = "http:";
    private static final String HOST_PROTOCOL = "https:";
    private static final String DEFAULT_HOST = "https://spanner.googleapis.com";
    private static final String DEFAULT_EMULATOR_HOST = "http://localhost:9010";
    private static final String USE_PLAIN_TEXT_PROPERTY_NAME = "usePlainText";
    public static final String AUTOCOMMIT_PROPERTY_NAME = "autocommit";
    public static final String READONLY_PROPERTY_NAME = "readonly";
    public static final String RETRY_ABORTS_INTERNALLY_PROPERTY_NAME = "retryAbortsInternally";
    public static final String CREDENTIALS_PROPERTY_NAME = "credentials";
    public static final String ENCODED_CREDENTIALS_PROPERTY_NAME = "encodedCredentials";
    public static final String OAUTH_TOKEN_PROPERTY_NAME = "oauthToken";
    public static final String MIN_SESSIONS_PROPERTY_NAME = "minSessions";
    public static final String MAX_SESSIONS_PROPERTY_NAME = "maxSessions";
    public static final String NUM_CHANNELS_PROPERTY_NAME = "numChannels";
    public static final String CHANNEL_PROVIDER_PROPERTY_NAME = "channelProvider";
    private static final String USER_AGENT_PROPERTY_NAME = "userAgent";
    private static final String OPTIMIZER_VERSION_PROPERTY_NAME = "optimizerVersion";
    private static final String OPTIMIZER_STATISTICS_PACKAGE_PROPERTY_NAME = "optimizerStatisticsPackage";
    public static final String LENIENT_PROPERTY_NAME = "lenient";
    public static final String RPC_PRIORITY_NAME = "rpcPriority";
    private static final String DIALECT_PROPERTY_NAME = "dialect";
    public static final Set<ConnectionProperty> VALID_PROPERTIES = Collections.unmodifiableSet(new HashSet<ConnectionProperty>(Arrays.asList(ConnectionProperty.access$000("autocommit", "Should the connection start in autocommit (true/false)", true), ConnectionProperty.access$000("readonly", "Should the connection start in read-only mode (true/false)", false), ConnectionProperty.access$000("retryAbortsInternally", "Should the connection automatically retry Aborted errors (true/false)", true), ConnectionProperty.access$100("credentials", "The location of the credentials file to use for this connection. If neither this property or encoded credentials are set, the connection will use the default Google Cloud credentials for the runtime environment."), ConnectionProperty.access$100("encodedCredentials", "Base64-encoded credentials to use for this connection. If neither this property or a credentials location are set, the connection will use the default Google Cloud credentials for the runtime environment."), ConnectionProperty.access$100("oauthToken", "A valid pre-existing OAuth token to use for authentication for this connection. Setting this property will take precedence over any value set for a credentials file."), ConnectionProperty.access$100("minSessions", "The minimum number of sessions in the backing session pool. The default is 100."), ConnectionProperty.access$100("maxSessions", "The maximum number of sessions in the backing session pool. The default is 400."), ConnectionProperty.access$100("numChannels", "The number of gRPC channels to use to communicate with Cloud Spanner. The default is 4."), ConnectionProperty.access$100("channelProvider", "The name of the channel provider class. The name must reference an implementation of ExternalChannelProvider. If this property is not set, the connection will use the default grpc channel provider."), ConnectionProperty.access$000("usePlainText", "Use a plain text communication channel (i.e. non-TLS) for communicating with the server (true/false). Set this value to true for communication with the Cloud Spanner emulator.", false), ConnectionProperty.access$100("userAgent", "The custom user-agent property name to use when communicating with Cloud Spanner. This property is intended for internal library usage, and should not be set by applications."), ConnectionProperty.access$100("optimizerVersion", "Sets the default query optimizer version to use for this connection."), ConnectionProperty.access$100("optimizerStatisticsPackage", ""), ConnectionProperty.access$000("returnCommitStats", "", false), ConnectionProperty.access$000("autoConfigEmulator", "Automatically configure the connection to try to connect to the Cloud Spanner emulator (true/false). The instance and database in the connection string will automatically be created if these do not yet exist on the emulator.", false), ConnectionProperty.access$000("lenient", "Silently ignore unknown properties in the connection string/properties (true/false)", false), ConnectionProperty.access$100("rpcPriority", "Sets the priority for all RPC invocations from this connection (HIGH/MEDIUM/LOW). The default is HIGH."), ConnectionProperty.access$100("dialect", "Sets the dialect to use for this connection."))));
    private static final Set<ConnectionProperty> INTERNAL_PROPERTIES = Collections.unmodifiableSet(new HashSet<ConnectionProperty>(Collections.singletonList(ConnectionProperty.access$100("userAgent", ""))));
    private static final Set<ConnectionProperty> INTERNAL_VALID_PROPERTIES = Sets.union(VALID_PROPERTIES, INTERNAL_PROPERTIES);
    private final String uri;
    private final String warnings;
    private final String credentialsUrl;
    private final String encodedCredentials;
    private final String oauthToken;
    private final Credentials fixedCredentials;
    private final boolean usePlainText;
    private final String host;
    private final String projectId;
    private final String instanceId;
    private final String databaseName;
    private final Credentials credentials;
    private final SessionPoolOptions sessionPoolOptions;
    private final Integer numChannels;
    private final String channelProvider;
    private final Integer minSessions;
    private final Integer maxSessions;
    private final String userAgent;
    private final ExecuteSqlRequest.QueryOptions queryOptions;
    private final boolean returnCommitStats;
    private final boolean autoConfigEmulator;
    private final Options.RpcPriority rpcPriority;
    private final boolean autocommit;
    private final boolean readOnly;
    private final boolean retryAbortsInternally;
    private final List<StatementExecutionInterceptor> statementExecutionInterceptors;
    private final SpannerOptionsConfigurator configurator;

    public static String getDefaultProjectId(Credentials credentials) {
        String projectId = SpannerOptions.getDefaultProjectId();
        if (projectId == null && credentials != null && credentials instanceof ServiceAccountCredentials) {
            projectId = ((ServiceAccountCredentials)credentials).getProjectId();
        }
        return projectId;
    }

    public static void closeSpanner() {
        SpannerPool.INSTANCE.checkAndCloseSpanners();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private ConnectionOptions(Builder builder) {
        Matcher matcher = Builder.SPANNER_URI_PATTERN.matcher(builder.uri);
        Preconditions.checkArgument((boolean)matcher.find(), (Object)String.format("Invalid connection URI specified: %s", builder.uri));
        this.warnings = ConnectionOptions.checkValidProperties(builder.uri);
        this.uri = builder.uri;
        this.credentialsUrl = builder.credentialsUrl != null ? builder.credentialsUrl : ConnectionOptions.parseCredentials(builder.uri);
        this.encodedCredentials = ConnectionOptions.parseEncodedCredentials(builder.uri);
        Preconditions.checkArgument((this.credentialsUrl == null || this.encodedCredentials == null ? 1 : 0) != 0, (Object)"Cannot specify both a credentials URL and encoded credentials. Only set one of the properties.");
        this.oauthToken = builder.oauthToken != null ? builder.oauthToken : ConnectionOptions.parseOAuthToken(builder.uri);
        this.fixedCredentials = builder.credentials;
        Preconditions.checkArgument((builder.credentials == null && this.credentialsUrl == null && this.encodedCredentials == null || this.oauthToken == null ? 1 : 0) != 0, (Object)"Cannot specify both credentials and an OAuth token.");
        this.userAgent = ConnectionOptions.parseUserAgent(this.uri);
        ExecuteSqlRequest.QueryOptions.Builder queryOptionsBuilder = ExecuteSqlRequest.QueryOptions.newBuilder();
        queryOptionsBuilder.setOptimizerVersion(ConnectionOptions.parseOptimizerVersion(this.uri));
        queryOptionsBuilder.setOptimizerStatisticsPackage(ConnectionOptions.parseOptimizerStatisticsPackage(this.uri));
        this.queryOptions = queryOptionsBuilder.build();
        this.returnCommitStats = ConnectionOptions.parseReturnCommitStats(this.uri);
        this.autoConfigEmulator = ConnectionOptions.parseAutoConfigEmulator(this.uri);
        this.usePlainText = this.autoConfigEmulator || ConnectionOptions.parseUsePlainText(this.uri);
        this.host = ConnectionOptions.determineHost(matcher, this.autoConfigEmulator, this.usePlainText);
        this.rpcPriority = ConnectionOptions.parseRPCPriority(this.uri);
        this.instanceId = matcher.group("INSTANCEGROUP");
        this.databaseName = matcher.group("DATABASEGROUP");
        this.credentials = builder.credentials == null && this.credentialsUrl == null && this.encodedCredentials == null && this.oauthToken == null && this.usePlainText ? NoCredentials.getInstance() : (this.oauthToken != null ? new GoogleCredentials(new AccessToken(this.oauthToken, null)) : (this.fixedCredentials != null ? this.fixedCredentials : (this.encodedCredentials != null ? this.getCredentialsService().decodeCredentials(this.encodedCredentials) : this.getCredentialsService().createCredentials(this.credentialsUrl))));
        this.minSessions = ConnectionOptions.parseIntegerProperty(MIN_SESSIONS_PROPERTY_NAME, ConnectionOptions.parseMinSessions(builder.uri));
        this.maxSessions = ConnectionOptions.parseIntegerProperty(MAX_SESSIONS_PROPERTY_NAME, ConnectionOptions.parseMaxSessions(builder.uri));
        this.numChannels = ConnectionOptions.parseIntegerProperty(NUM_CHANNELS_PROPERTY_NAME, ConnectionOptions.parseNumChannels(builder.uri));
        this.channelProvider = ConnectionOptions.parseChannelProvider(builder.uri);
        String projectId = matcher.group("PROJECTGROUP");
        if ("DEFAULT_PROJECT_ID".equalsIgnoreCase(projectId)) {
            projectId = ConnectionOptions.getDefaultProjectId(this.credentials);
        }
        this.projectId = projectId;
        this.autocommit = ConnectionOptions.parseAutocommit(this.uri);
        this.readOnly = ConnectionOptions.parseReadOnly(this.uri);
        this.retryAbortsInternally = ConnectionOptions.parseRetryAbortsInternally(this.uri);
        this.statementExecutionInterceptors = Collections.unmodifiableList(builder.statementExecutionInterceptors);
        this.configurator = builder.configurator;
        if (this.minSessions != null || this.maxSessions != null) {
            SessionPoolOptions.Builder sessionPoolOptionsBuilder = builder.sessionPoolOptions == null ? SessionPoolOptions.newBuilder() : builder.sessionPoolOptions.toBuilder();
            sessionPoolOptionsBuilder.setAutoDetectDialect(true);
            if (this.minSessions != null) {
                sessionPoolOptionsBuilder.setMinSessions(this.minSessions);
            }
            if (this.maxSessions != null) {
                sessionPoolOptionsBuilder.setMaxSessions(this.maxSessions);
            }
            this.sessionPoolOptions = sessionPoolOptionsBuilder.build();
        } else {
            this.sessionPoolOptions = builder.sessionPoolOptions != null ? builder.sessionPoolOptions : SessionPoolOptions.newBuilder().setAutoDetectDialect(true).build();
        }
    }

    private static String determineHost(Matcher matcher, boolean autoConfigEmulator, boolean usePlainText) {
        if (matcher.group("HOSTGROUP") == null) {
            if (autoConfigEmulator) {
                return DEFAULT_EMULATOR_HOST;
            }
            return DEFAULT_HOST;
        }
        if (usePlainText) {
            return PLAIN_TEXT_PROTOCOL + matcher.group("HOSTGROUP");
        }
        return HOST_PROTOCOL + matcher.group("HOSTGROUP");
    }

    private static Integer parseIntegerProperty(String propertyName, String value) {
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Invalid %s value specified: %s", propertyName, value), e);
            }
        }
        return null;
    }

    SpannerOptionsConfigurator getConfigurator() {
        return this.configurator;
    }

    @VisibleForTesting
    CredentialsService getCredentialsService() {
        return CredentialsService.INSTANCE;
    }

    @VisibleForTesting
    static boolean parseUsePlainText(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, USE_PLAIN_TEXT_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @VisibleForTesting
    static boolean parseAutocommit(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, AUTOCOMMIT_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : true;
    }

    @VisibleForTesting
    static boolean parseReadOnly(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, READONLY_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @VisibleForTesting
    static boolean parseRetryAbortsInternally(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, RETRY_ABORTS_INTERNALLY_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : true;
    }

    @VisibleForTesting
    static String parseCredentials(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, CREDENTIALS_PROPERTY_NAME);
        return value != null ? value : DEFAULT_CREDENTIALS;
    }

    @VisibleForTesting
    static String parseEncodedCredentials(String uri) {
        return ConnectionOptions.parseUriProperty(uri, ENCODED_CREDENTIALS_PROPERTY_NAME);
    }

    @VisibleForTesting
    static String parseOAuthToken(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, OAUTH_TOKEN_PROPERTY_NAME);
        return value != null ? value : DEFAULT_OAUTH_TOKEN;
    }

    @VisibleForTesting
    static String parseMinSessions(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, MIN_SESSIONS_PROPERTY_NAME);
        return value != null ? value : DEFAULT_MIN_SESSIONS;
    }

    @VisibleForTesting
    static String parseMaxSessions(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, MAX_SESSIONS_PROPERTY_NAME);
        return value != null ? value : DEFAULT_MAX_SESSIONS;
    }

    @VisibleForTesting
    static String parseNumChannels(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, NUM_CHANNELS_PROPERTY_NAME);
        return value != null ? value : DEFAULT_NUM_CHANNELS;
    }

    @VisibleForTesting
    static String parseChannelProvider(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, CHANNEL_PROVIDER_PROPERTY_NAME);
        return value != null ? value : DEFAULT_CHANNEL_PROVIDER;
    }

    @VisibleForTesting
    static String parseUserAgent(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, USER_AGENT_PROPERTY_NAME);
        return value != null ? value : DEFAULT_USER_AGENT;
    }

    @VisibleForTesting
    static String parseOptimizerVersion(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, OPTIMIZER_VERSION_PROPERTY_NAME);
        return value != null ? value : "";
    }

    @VisibleForTesting
    static String parseOptimizerStatisticsPackage(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, OPTIMIZER_STATISTICS_PACKAGE_PROPERTY_NAME);
        return value != null ? value : "";
    }

    @VisibleForTesting
    static boolean parseReturnCommitStats(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, "returnCommitStats");
        return Boolean.parseBoolean(value);
    }

    static boolean parseAutoConfigEmulator(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, "autoConfigEmulator");
        return Boolean.parseBoolean(value);
    }

    @VisibleForTesting
    static boolean parseLenient(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, LENIENT_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @VisibleForTesting
    static Options.RpcPriority parseRPCPriority(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, RPC_PRIORITY_NAME);
        return value != null ? Options.RpcPriority.valueOf(value) : DEFAULT_RPC_PRIORITY;
    }

    @VisibleForTesting
    static String parseUriProperty(String uri, String property) {
        Pattern pattern = Pattern.compile(String.format("(?is)(?:;|\\?)%s=(.*?)(?:;|$)", property));
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    @VisibleForTesting
    static String checkValidProperties(String uri) {
        String invalidProperties = "";
        List<String> properties = ConnectionOptions.parseProperties(uri);
        boolean lenient = ConnectionOptions.parseLenient(uri);
        for (String property : properties) {
            if (INTERNAL_VALID_PROPERTIES.contains(ConnectionProperty.createEmptyProperty(property))) continue;
            if (invalidProperties.length() > 0) {
                invalidProperties = invalidProperties + ", ";
            }
            invalidProperties = invalidProperties + property;
        }
        if (lenient) {
            return String.format("Invalid properties found in connection URI: %s", invalidProperties);
        }
        Preconditions.checkArgument((boolean)invalidProperties.isEmpty(), (Object)String.format("Invalid properties found in connection URI. Add lenient=true to the connection string to ignore unknown properties. Invalid properties: %s", invalidProperties));
        return null;
    }

    @VisibleForTesting
    static List<String> parseProperties(String uri) {
        Pattern pattern = Pattern.compile("(?is)(?:\\?|;)(?<PROPERTY>.*?)=(?:.*?)");
        Matcher matcher = pattern.matcher(uri);
        ArrayList<String> res = new ArrayList<String>();
        while (matcher.find() && matcher.group("PROPERTY") != null) {
            res.add(matcher.group("PROPERTY"));
        }
        return res;
    }

    public Connection getConnection() {
        LOCAL_CONNECTION_CHECKER.checkLocalConnection(this);
        return new ConnectionImpl(this);
    }

    public String getUri() {
        return this.uri;
    }

    public String getCredentialsUrl() {
        return this.credentialsUrl;
    }

    String getOAuthToken() {
        return this.oauthToken;
    }

    Credentials getFixedCredentials() {
        return this.fixedCredentials;
    }

    public SessionPoolOptions getSessionPoolOptions() {
        return this.sessionPoolOptions;
    }

    public Integer getMinSessions() {
        return this.minSessions;
    }

    public Integer getMaxSessions() {
        return this.maxSessions;
    }

    public Integer getNumChannels() {
        return this.numChannels;
    }

    public TransportChannelProvider getChannelProvider() {
        if (this.channelProvider == null) {
            return null;
        }
        try {
            URL url = new URL(this.host);
            ExternalChannelProvider provider = (ExternalChannelProvider)ExternalChannelProvider.class.cast(Class.forName(this.channelProvider).newInstance());
            return provider.getChannelProvider(url.getHost(), url.getPort());
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("%s : Failed to create channel with external provider: %s", e.toString(), this.channelProvider));
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseId getDatabaseId() {
        Preconditions.checkState((this.projectId != null ? 1 : 0) != 0, (Object)"Project ID is not specified");
        Preconditions.checkState((this.instanceId != null ? 1 : 0) != 0, (Object)"Instance ID is not specified");
        Preconditions.checkState((this.databaseName != null ? 1 : 0) != 0, (Object)"Database name is not specified");
        return DatabaseId.of(this.projectId, this.instanceId, this.databaseName);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRetryAbortsInternally() {
        return this.retryAbortsInternally;
    }

    @Nullable
    public String getWarnings() {
        return this.warnings;
    }

    boolean isUsePlainText() {
        return this.usePlainText;
    }

    String getUserAgent() {
        return this.userAgent;
    }

    ExecuteSqlRequest.QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public boolean isReturnCommitStats() {
        return this.returnCommitStats;
    }

    public boolean isAutoConfigEmulator() {
        return this.autoConfigEmulator;
    }

    Options.RpcPriority getRPCPriority() {
        return this.rpcPriority;
    }

    List<StatementExecutionInterceptor> getStatementExecutionInterceptors() {
        return this.statementExecutionInterceptors;
    }

    public String toString() {
        return this.getUri();
    }

    public static class Builder {
        private String uri;
        private String credentialsUrl;
        private String oauthToken;
        private Credentials credentials;
        private SessionPoolOptions sessionPoolOptions;
        private List<StatementExecutionInterceptor> statementExecutionInterceptors = Collections.emptyList();
        private SpannerOptionsConfigurator configurator;
        public static final String SPANNER_URI_FORMAT = "(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?";
        private static final String SPANNER_URI_REGEX = "(?is)^(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?$";
        private static final Pattern SPANNER_URI_PATTERN = Pattern.compile("(?is)^(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?$");
        private static final String HOST_GROUP = "HOSTGROUP";
        private static final String PROJECT_GROUP = "PROJECTGROUP";
        private static final String INSTANCE_GROUP = "INSTANCEGROUP";
        private static final String DATABASE_GROUP = "DATABASEGROUP";
        private static final String DEFAULT_PROJECT_ID_PLACEHOLDER = "DEFAULT_PROJECT_ID";

        private Builder() {
        }

        private boolean isValidUri(String uri) {
            return SPANNER_URI_PATTERN.matcher(uri).matches();
        }

        public Builder setUri(String uri) {
            Preconditions.checkArgument((boolean)this.isValidUri(uri), (Object)"The specified URI is not a valid Cloud Spanner connection URI. Please specify a URI in the format \"cloudspanner:[//host[:port]]/projects/project-id[/instances/instance-id[/databases/database-name]][\\?property-name=property-value[;property-name=property-value]*]?\"");
            ConnectionOptions.checkValidProperties(uri);
            this.uri = uri;
            return this;
        }

        public Builder setSessionPoolOptions(SessionPoolOptions sessionPoolOptions) {
            Preconditions.checkNotNull((Object)sessionPoolOptions);
            this.sessionPoolOptions = sessionPoolOptions;
            return this;
        }

        public Builder setCredentialsUrl(String credentialsUrl) {
            this.credentialsUrl = credentialsUrl;
            return this;
        }

        public Builder setOAuthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        @VisibleForTesting
        Builder setStatementExecutionInterceptors(List<StatementExecutionInterceptor> interceptors) {
            this.statementExecutionInterceptors = interceptors;
            return this;
        }

        @VisibleForTesting
        Builder setConfigurator(SpannerOptionsConfigurator configurator) {
            this.configurator = (SpannerOptionsConfigurator)Preconditions.checkNotNull((Object)configurator);
            return this;
        }

        @VisibleForTesting
        Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public ConnectionOptions build() {
            Preconditions.checkState((this.uri != null ? 1 : 0) != 0, (Object)"Connection URI is required");
            return new ConnectionOptions(this);
        }
    }

    public static interface ExternalChannelProvider {
        public TransportChannelProvider getChannelProvider(String var1, int var2);
    }

    @VisibleForTesting
    static interface SpannerOptionsConfigurator {
        public void configure(SpannerOptions.Builder var1);
    }

    public static class ConnectionProperty {
        private static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};
        private final String name;
        private final String description;
        private final String defaultValue;
        private final String[] validValues;
        private final int hashCode;

        private static ConnectionProperty createStringProperty(String name, String description) {
            return new ConnectionProperty(name, description, "", null);
        }

        private static ConnectionProperty createBooleanProperty(String name, String description, boolean defaultValue) {
            return new ConnectionProperty(name, description, String.valueOf(defaultValue), BOOLEAN_VALUES);
        }

        private static ConnectionProperty createEmptyProperty(String name) {
            return new ConnectionProperty(name, "", "", null);
        }

        private ConnectionProperty(String name, String description, String defaultValue, String[] validValues) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)description);
            Preconditions.checkNotNull((Object)defaultValue);
            this.name = name;
            this.description = description;
            this.defaultValue = defaultValue;
            this.validValues = validValues;
            this.hashCode = name.toLowerCase().hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConnectionProperty)) {
                return false;
            }
            return ((ConnectionProperty)o).name.equalsIgnoreCase(this.name);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String[] getValidValues() {
            return this.validValues;
        }

        static /* synthetic */ ConnectionProperty access$000(String x0, String x1, boolean x2) {
            return ConnectionProperty.createBooleanProperty(x0, x1, x2);
        }

        static /* synthetic */ ConnectionProperty access$100(String x0, String x1) {
            return ConnectionProperty.createStringProperty(x0, x1);
        }
    }
}

