/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

class DmlBatch
extends AbstractBaseUnitOfWork {
    private final UnitOfWork transaction;
    private final String statementTag;
    private final List<StatementParser.ParsedStatement> statements = new ArrayList<StatementParser.ParsedStatement>();
    private UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;

    static Builder newBuilder() {
        return new Builder();
    }

    private DmlBatch(Builder builder) {
        super(builder);
        this.transaction = builder.transaction;
        this.statementTag = builder.statementTag;
    }

    @Override
    public UnitOfWork.Type getType() {
        return UnitOfWork.Type.BATCH;
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isActive() {
        return this.getState().isActive();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ApiFuture<ResultSet> executeQueryAsync(StatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing queries is not allowed for DML batches.");
    }

    @Override
    public Timestamp getReadTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no read timestamp available for DML batches.");
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return null;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit timestamp available for DML batches.");
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        return null;
    }

    @Override
    public CommitResponse getCommitResponse() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit response available for DML batches.");
    }

    @Override
    public CommitResponse getCommitResponseOrNull() {
        return null;
    }

    @Override
    public ApiFuture<Void> executeDdlAsync(StatementParser.ParsedStatement ddl) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing DDL statements is not allowed for DML batches.");
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(StatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be used for further statements");
        Preconditions.checkArgument((update.getType() == StatementParser.StatementType.UPDATE ? 1 : 0) != 0, (Object)("Only DML statements are allowed. \"" + update.getSqlWithoutComments() + "\" is not a DML-statement."));
        this.statements.add(update);
        return ApiFutures.immediateFuture((Object)-1L);
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<StatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing batch updates is not allowed for DML batches.");
    }

    @Override
    public ApiFuture<Void> writeAsync(Iterable<Mutation> mutations) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Writing mutations is not allowed for DML batches.");
    }

    @Override
    public ApiFuture<long[]> runBatchAsync() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be ran");
        if (this.statements.isEmpty()) {
            this.state = UnitOfWork.UnitOfWorkState.RAN;
            return ApiFutures.immediateFuture((Object)new long[0]);
        }
        this.state = UnitOfWork.UnitOfWorkState.RUNNING;
        final SettableApiFuture res = SettableApiFuture.create();
        int numOptions = 0;
        if (this.statementTag != null) {
            ++numOptions;
        }
        if (this.rpcPriority != null) {
            ++numOptions;
        }
        Options.UpdateOption[] options = new Options.UpdateOption[numOptions];
        int index = 0;
        if (this.statementTag != null) {
            options[index++] = Options.tag(this.statementTag);
        }
        if (this.rpcPriority != null) {
            options[index++] = Options.priority(this.rpcPriority);
        }
        ApiFuture<long[]> updateCounts = this.transaction.executeBatchUpdateAsync(this.statements, options);
        ApiFutures.addCallback(updateCounts, (ApiFutureCallback)new ApiFutureCallback<long[]>(){

            public void onFailure(Throwable t) {
                DmlBatch.this.state = UnitOfWork.UnitOfWorkState.RUN_FAILED;
                res.setException(t);
            }

            public void onSuccess(long[] result) {
                DmlBatch.this.state = UnitOfWork.UnitOfWorkState.RAN;
                res.set((Object)result);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return res;
    }

    @Override
    public void abortBatch() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be aborted.");
        this.state = UnitOfWork.UnitOfWorkState.ABORTED;
    }

    @Override
    public ApiFuture<Void> commitAsync() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Commit is not allowed for DML batches.");
    }

    @Override
    public ApiFuture<Void> rollbackAsync() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Rollback is not allowed for DML batches.");
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, DmlBatch> {
        private UnitOfWork transaction;
        private String statementTag;

        private Builder() {
        }

        Builder setTransaction(UnitOfWork transaction) {
            Preconditions.checkNotNull((Object)transaction);
            this.transaction = transaction;
            return this;
        }

        Builder setStatementTag(String tag) {
            this.statementTag = tag;
            return this;
        }

        @Override
        DmlBatch build() {
            Preconditions.checkState((this.transaction != null ? 1 : 0) != 0, (Object)"No transaction specified");
            return new DmlBatch(this);
        }
    }
}

