/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.gax.paging.Page;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.BaseService;
import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.PageImpl;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AbstractStructReader;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Operation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.FieldMask;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.instance.v1.CreateInstanceMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstanceMetadata;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import com.google.spanner.v1.TypeCode;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class SpannerImpl
extends BaseService<SpannerOptions>
implements Spanner {
    private static final int MIN_BACKOFF_MS = 1000;
    private static final int MAX_BACKOFF_MS = 32000;
    private static final PathTemplate OP_NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}/instances/{instance}/databases/{database}/operations/{operation}");
    private static final PathTemplate PROJECT_NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}");
    private static final Logger logger = Logger.getLogger(SpannerImpl.class.getName());
    private static final Logger txnLogger = Logger.getLogger(TransactionRunner.class.getName());
    private final Random random = new Random();
    private final SpannerRpc rpc;
    private final int defaultPrefetchChunks;
    @GuardedBy(value="this")
    private final Map<DatabaseId, DatabaseClientImpl> dbClients = new HashMap<DatabaseId, DatabaseClientImpl>();
    private final DatabaseAdminClient dbAdminClient = new DatabaseAdminClientImpl();
    private final InstanceAdminClient instanceClient = new InstanceAdminClientImpl(this.dbAdminClient);
    @GuardedBy(value="this")
    private boolean spannerIsClosed = false;

    SpannerImpl(SpannerRpc rpc, int defaultPrefetchChunks, SpannerOptions options) {
        super((ServiceOptions)options);
        this.rpc = rpc;
        this.defaultPrefetchChunks = defaultPrefetchChunks;
    }

    SpannerImpl(SpannerOptions options) {
        this(options.getSpannerRpcV1(), options.getPrefetchChunks(), options);
    }

    private static ExponentialBackOff newBackOff() {
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setMaxIntervalMillis(32000).setMaxElapsedTimeMillis(Integer.MAX_VALUE).build();
    }

    private static void backoffSleep(Context context, BackOff backoff) throws SpannerException {
        SpannerImpl.backoffSleep(context, SpannerImpl.nextBackOffMillis(backoff));
    }

    private static long nextBackOffMillis(BackOff backoff) throws SpannerException {
        try {
            return backoff.nextBackOffMillis();
        }
        catch (IOException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, e.getMessage(), e);
        }
    }

    private static void backoffSleep(Context context, long backoffMillis) throws SpannerException {
        final CountDownLatch latch = new CountDownLatch(1);
        Context.CancellationListener listener = new Context.CancellationListener(){

            public void cancelled(Context context) {
                latch.countDown();
            }
        };
        context.addListener(listener, (Executor)DirectExecutor.INSTANCE);
        try {
            if (backoffMillis == -1L) {
                backoffMillis = 32000L;
            }
            if (latch.await(backoffMillis, TimeUnit.MILLISECONDS)) {
                throw SpannerExceptionFactory.newSpannerExceptionForCancellation(context, null);
            }
        }
        catch (InterruptedException interruptExcept) {
            throw SpannerExceptionFactory.newSpannerExceptionForCancellation(context, interruptExcept);
        }
        finally {
            context.removeListener(listener);
        }
    }

    /*
     * Loose catch block
     */
    static <T> T runWithRetries(Callable<T> callable) {
        ExponentialBackOff backOff = SpannerImpl.newBackOff();
        Context context = Context.current();
        while (true) {
            try {
                return callable.call();
            }
            catch (SpannerException e) {
                if (!e.isRetryable()) {
                    throw e;
                }
                logger.log(Level.FINE, "Retryable exception, will sleep and retry", (Throwable)((Object)e));
                SpannerImpl.backoffSleep(context, (BackOff)backOff);
                continue;
            }
            break;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    Session createSession(final DatabaseId db) throws SpannerException {
        final Map<SpannerRpc.Option, ?> options = SpannerImpl.optionMap(SessionOption.channelHint(this.random.nextLong()));
        com.google.spanner.v1.Session session = SpannerImpl.runWithRetries(new Callable<com.google.spanner.v1.Session>(){

            @Override
            public com.google.spanner.v1.Session call() throws Exception {
                return SpannerImpl.this.rpc.createSession(db.getName(), options);
            }
        });
        return new SessionImpl(session.getName(), options);
    }

    @Override
    public DatabaseAdminClient getDatabaseAdminClient() {
        return this.dbAdminClient;
    }

    @Override
    public InstanceAdminClient getInstanceAdminClient() {
        return this.instanceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseClient getDatabaseClient(DatabaseId db) {
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            Preconditions.checkState((!this.spannerIsClosed ? 1 : 0) != 0, (Object)"Cloud Spanner client has been closed");
            if (this.dbClients.containsKey(db)) {
                return this.dbClients.get(db);
            }
            SessionPool pool = SessionPool.createPool((SpannerOptions)this.getOptions(), db, this);
            DatabaseClientImpl dbClient = new DatabaseClientImpl(pool);
            this.dbClients.put(db, dbClient);
            return dbClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<ListenableFuture<Void>> closureFutures = null;
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            Preconditions.checkState((!this.spannerIsClosed ? 1 : 0) != 0, (Object)"Cloud Spanner client has been closed");
            this.spannerIsClosed = true;
            closureFutures = new ArrayList<ListenableFuture<Void>>();
            for (DatabaseClientImpl dbClient : this.dbClients.values()) {
                closureFutures.add(dbClient.closeAsync());
            }
            this.dbClients.clear();
        }
        try {
            Futures.successfulAsList(closureFutures).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
        for (ManagedChannel channel : ((SpannerOptions)this.getOptions()).getRpcChannels()) {
            try {
                channel.shutdown();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Failed to close channel", e);
            }
        }
    }

    private static void checkContext(Context context) {
        if (context.isCancelled()) {
            throw SpannerExceptionFactory.newSpannerExceptionForCancellation(context, null);
        }
    }

    static Map<SpannerRpc.Option, ?> optionMap(SessionOption ... options) {
        if (options.length == 0) {
            return Collections.emptyMap();
        }
        EnumMap tmp = Maps.newEnumMap(SpannerRpc.Option.class);
        for (SessionOption option : options) {
            Object prev = tmp.put(option.rpcOption(), option.value());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option.rpcOption()});
        }
        return ImmutableMap.copyOf((Map)tmp);
    }

    private String getProjectId() {
        return ((SpannerOptions)this.getOptions()).getProjectId();
    }

    private String getInstanceName(String instanceId) {
        return new InstanceId(this.getProjectId(), instanceId).getName();
    }

    private String getDatabaseName(String instanceId, String databaseId) {
        return new DatabaseId(new InstanceId(this.getProjectId(), instanceId), databaseId).getName();
    }

    private <T extends Message> T unpack(Any response, Class<T> clazz) throws SpannerException {
        try {
            return (T)response.unpack(clazz);
        }
        catch (InvalidProtocolBufferException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Error unpacking response", e);
        }
    }

    private String randomOperationId() {
        UUID uuid = UUID.randomUUID();
        return ("r" + uuid.toString()).replace("-", "_");
    }

    private static void assertTimestampAvailable(boolean available) {
        Preconditions.checkState((boolean)available, (Object)"Method can only be called after read has returned data or finished");
    }

    private static double valueProtoToFloat64(com.google.protobuf.Value proto) {
        if (proto.getKindCase() == Value.KindCase.STRING_VALUE) {
            switch (proto.getStringValue()) {
                case "-Infinity": {
                    return Double.NEGATIVE_INFINITY;
                }
                case "Infinity": {
                    return Double.POSITIVE_INFINITY;
                }
                case "NaN": {
                    return Double.NaN;
                }
            }
        }
        if (proto.getKindCase() != Value.KindCase.NUMBER_VALUE) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid value for column type " + Type.float64() + " expected NUMBER_VALUE or STRING_VALUE with value one of \"Infinity\", \"-Infinity\", or \"NaN\" but was " + proto.getKindCase() + (proto.getKindCase() == Value.KindCase.STRING_VALUE ? " with value \"" + proto.getStringValue() + "\"" : ""));
        }
        return proto.getNumberValue();
    }

    private static NullPointerException throwNotNull(int columnIndex) {
        throw new NullPointerException("Cannot call array getter for column " + columnIndex + " with null elements");
    }

    private static class Float64Array
    extends PrimitiveArray<Double, double[]> {
        Float64Array(ListValue protoList) {
            super(protoList);
        }

        Float64Array(double[] data, BitSet nulls) {
            super(data, nulls, data.length);
        }

        @Override
        double[] newArray(int size) {
            return new double[size];
        }

        @Override
        void setProto(double[] array, int i, com.google.protobuf.Value protoValue) {
            array[i] = SpannerImpl.valueProtoToFloat64(protoValue);
        }

        @Override
        Double get(double[] array, int i) {
            return array[i];
        }
    }

    private static class Int64Array
    extends PrimitiveArray<Long, long[]> {
        Int64Array(ListValue protoList) {
            super(protoList);
        }

        Int64Array(long[] data, BitSet nulls) {
            super(data, nulls, data.length);
        }

        @Override
        long[] newArray(int size) {
            return new long[size];
        }

        @Override
        void setProto(long[] array, int i, com.google.protobuf.Value protoValue) {
            array[i] = Long.parseLong(protoValue.getStringValue());
        }

        @Override
        Long get(long[] array, int i) {
            return array[i];
        }
    }

    private static abstract class PrimitiveArray<T, A>
    extends AbstractList<T> {
        private final A data;
        private final BitSet nulls;
        private final int size;

        PrimitiveArray(ListValue protoList) {
            this.size = protoList.getValuesCount();
            A data = this.newArray(this.size);
            BitSet nulls = new BitSet(this.size);
            for (int i = 0; i < protoList.getValuesCount(); ++i) {
                if (protoList.getValues(i).getKindCase() == Value.KindCase.NULL_VALUE) {
                    nulls.set(i);
                    continue;
                }
                this.setProto(data, i, protoList.getValues(i));
            }
            this.data = data;
            this.nulls = nulls;
        }

        PrimitiveArray(A data, BitSet nulls, int size) {
            this.data = data;
            this.nulls = nulls;
            this.size = size;
        }

        abstract A newArray(int var1);

        abstract void setProto(A var1, int var2, com.google.protobuf.Value var3);

        abstract T get(A var1, int var2);

        @Override
        public T get(int index) {
            if (index < 0 || index >= this.size) {
                throw new ArrayIndexOutOfBoundsException("index=" + index + " size=" + this.size);
            }
            return this.nulls.get(index) ? null : (T)this.get(this.data, index);
        }

        @Override
        public int size() {
            return this.size;
        }

        A toPrimitiveArray(int columnIndex) {
            if (this.nulls.length() > 0) {
                throw SpannerImpl.throwNotNull(columnIndex);
            }
            A r = this.newArray(this.size);
            System.arraycopy(this.data, 0, r, 0, this.size);
            return r;
        }
    }

    private static class GrpcValueIterator
    extends AbstractIterator<com.google.protobuf.Value> {
        private final CloseableIterator<PartialResultSet> stream;
        private ResultSetMetadata metadata;
        private Type type;
        private PartialResultSet current;
        private int pos;
        private ResultSetStats statistics;

        GrpcValueIterator(CloseableIterator<PartialResultSet> stream) {
            this.stream = stream;
        }

        protected com.google.protobuf.Value computeNext() {
            Object merged;
            com.google.protobuf.Value value;
            Value.KindCase kind;
            if (!this.ensureReady(StreamValue.RESULT)) {
                this.endOfData();
                return null;
            }
            if (!this.isMergeable(kind = (value = this.current.getValues(this.pos++)).getKindCase())) {
                if (this.pos == this.current.getValuesCount() && this.current.getChunkedValue()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Unexpected chunked PartialResultSet.");
                }
                return value;
            }
            if (!this.current.getChunkedValue() || this.pos != this.current.getValuesCount()) {
                return value;
            }
            Object object = merged = kind == Value.KindCase.STRING_VALUE ? value.getStringValue() : new ArrayList(value.getListValue().getValuesList());
            while (this.current.getChunkedValue() && this.pos == this.current.getValuesCount()) {
                com.google.protobuf.Value newValue;
                if (!this.ensureReady(StreamValue.RESULT)) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Stream closed in the middle of chunked value");
                }
                if ((newValue = this.current.getValues(this.pos++)).getKindCase() != kind) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Unexpected type in middle of chunked value. Expected: " + kind + " but got: " + newValue.getKindCase());
                }
                if (kind == Value.KindCase.STRING_VALUE) {
                    merged = (String)merged + newValue.getStringValue();
                    continue;
                }
                this.concatLists((List)merged, newValue.getListValue().getValuesList());
            }
            if (kind == Value.KindCase.STRING_VALUE) {
                return com.google.protobuf.Value.newBuilder().setStringValue((String)merged).build();
            }
            return com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)((List)merged))).build();
        }

        ResultSetMetadata getMetadata() throws SpannerException {
            if (this.metadata == null && !this.ensureReady(StreamValue.METADATA)) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Stream closed without sending metadata");
            }
            return this.metadata;
        }

        ResultSetStats getStats() {
            if (this.statistics == null) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Stream closed without sending query statistics");
            }
            return this.statistics;
        }

        Type type() {
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"metadata has not been received");
            return this.type;
        }

        private boolean ensureReady(StreamValue requiredValue) throws SpannerException {
            while (this.current == null || this.pos >= this.current.getValuesCount()) {
                if (!this.stream.hasNext()) {
                    return false;
                }
                this.current = (PartialResultSet)this.stream.next();
                this.pos = 0;
                if (this.type == null) {
                    if (!this.current.hasMetadata() || !this.current.getMetadata().hasRowType()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing type metadata in first message");
                    }
                    this.metadata = this.current.getMetadata();
                    com.google.spanner.v1.Type typeProto = com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.STRUCT).setStructType(this.metadata.getRowType()).build();
                    try {
                        this.type = Type.fromProto(typeProto);
                    }
                    catch (IllegalArgumentException e) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid type metadata: " + e.getMessage(), e);
                    }
                }
                if (this.current.hasStats()) {
                    this.statistics = this.current.getStats();
                }
                if (requiredValue != StreamValue.METADATA) continue;
                return true;
            }
            return true;
        }

        void close(@Nullable String message) {
            this.stream.close(message);
        }

        private void concatLists(List<com.google.protobuf.Value> a, List<com.google.protobuf.Value> b) {
            if (a.size() == 0 || b.size() == 0) {
                a.addAll(b);
                return;
            }
            com.google.protobuf.Value last = a.get(a.size() - 1);
            com.google.protobuf.Value first = b.get(0);
            Value.KindCase lastKind = last.getKindCase();
            Value.KindCase firstKind = first.getKindCase();
            if (this.isMergeable(lastKind) && lastKind == firstKind) {
                com.google.protobuf.Value merged = null;
                if (lastKind == Value.KindCase.STRING_VALUE) {
                    String lastStr = last.getStringValue();
                    String firstStr = first.getStringValue();
                    merged = com.google.protobuf.Value.newBuilder().setStringValue(lastStr + firstStr).build();
                } else {
                    ArrayList<com.google.protobuf.Value> mergedList = new ArrayList<com.google.protobuf.Value>();
                    mergedList.addAll(last.getListValue().getValuesList());
                    this.concatLists(mergedList, first.getListValue().getValuesList());
                    merged = com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(mergedList)).build();
                }
                a.set(a.size() - 1, merged);
                a.addAll(b.subList(1, b.size()));
            } else {
                a.addAll(b);
            }
        }

        private boolean isMergeable(Value.KindCase kind) {
            return kind == Value.KindCase.STRING_VALUE || kind == Value.KindCase.LIST_VALUE;
        }

        private static enum StreamValue {
            METADATA,
            RESULT;

        }
    }

    @VisibleForTesting
    static abstract class ResumableStreamIterator
    extends AbstractIterator<PartialResultSet>
    implements CloseableIterator<PartialResultSet> {
        private final BackOff backOff = SpannerImpl.access$1800();
        private final LinkedList<PartialResultSet> buffer = new LinkedList();
        private final int maxBufferSize;
        private CloseableIterator<PartialResultSet> stream;
        private ByteString resumeToken;
        private boolean finished;
        private boolean safeToRetry = true;

        protected ResumableStreamIterator(int maxBufferSize) {
            Preconditions.checkArgument((maxBufferSize >= 0 ? 1 : 0) != 0);
            this.maxBufferSize = maxBufferSize;
        }

        abstract CloseableIterator<PartialResultSet> startStream(@Nullable ByteString var1);

        @Override
        public void close(@Nullable String message) {
            if (this.stream != null) {
                this.stream.close(message);
            }
        }

        protected PartialResultSet computeNext() {
            Context context = Context.current();
            while (true) {
                if (this.stream == null) {
                    this.stream = (CloseableIterator)Preconditions.checkNotNull(this.startStream(this.resumeToken));
                }
                if (!(this.buffer.isEmpty() || !this.finished && this.safeToRetry && this.buffer.getLast().getResumeToken().isEmpty())) {
                    return this.buffer.pop();
                }
                try {
                    if (this.stream.hasNext()) {
                        boolean hasResumeToken;
                        PartialResultSet next = (PartialResultSet)this.stream.next();
                        boolean bl = hasResumeToken = !next.getResumeToken().isEmpty();
                        if (hasResumeToken) {
                            this.resumeToken = next.getResumeToken();
                            this.safeToRetry = true;
                        }
                        if ((hasResumeToken || !this.safeToRetry) && this.buffer.isEmpty()) {
                            return next;
                        }
                        this.buffer.add(next);
                        if (this.buffer.size() <= this.maxBufferSize || !this.buffer.getLast().getResumeToken().isEmpty()) continue;
                        this.safeToRetry = false;
                        continue;
                    }
                    this.finished = true;
                    if (!this.buffer.isEmpty()) continue;
                    this.endOfData();
                    return null;
                }
                catch (SpannerException e) {
                    if (this.safeToRetry && e.isRetryable()) {
                        logger.log(Level.FINE, "Retryable exception, will sleep and retry", (Throwable)((Object)e));
                        while (!this.buffer.isEmpty() && this.buffer.getLast().getResumeToken().isEmpty()) {
                            this.buffer.removeLast();
                        }
                        assert (this.buffer.isEmpty() || this.buffer.getLast().getResumeToken().equals((Object)this.resumeToken));
                        this.stream = null;
                        SpannerImpl.backoffSleep(context, this.backOff);
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
    }

    @VisibleForTesting
    static class GrpcStreamIterator
    extends AbstractIterator<PartialResultSet>
    implements CloseableIterator<PartialResultSet> {
        private static final PartialResultSet END_OF_STREAM = PartialResultSet.newBuilder().build();
        private final ConsumerImpl consumer = new ConsumerImpl();
        private final BlockingQueue<PartialResultSet> stream;
        private SpannerRpc.StreamingCall call;
        private SpannerException error;

        GrpcStreamIterator(int prefetchChunks) {
            this.stream = new LinkedBlockingQueue<PartialResultSet>(prefetchChunks + 1);
        }

        protected final SpannerRpc.ResultStreamConsumer consumer() {
            return this.consumer;
        }

        public void setCall(SpannerRpc.StreamingCall call) {
            this.call = call;
        }

        @Override
        public void close(@Nullable String message) {
            if (this.call != null) {
                this.call.cancel(message);
            }
        }

        protected final PartialResultSet computeNext() {
            PartialResultSet next;
            try {
                next = this.stream.take();
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
            if (next != END_OF_STREAM) {
                this.call.request(1);
                return next;
            }
            this.call = null;
            if (this.error != null) {
                throw SpannerExceptionFactory.newSpannerException((Throwable)((Object)this.error));
            }
            this.endOfData();
            return null;
        }

        private void addToStream(PartialResultSet results) {
            Uninterruptibles.putUninterruptibly(this.stream, (Object)results);
        }

        private class ConsumerImpl
        implements SpannerRpc.ResultStreamConsumer {
            private ConsumerImpl() {
            }

            @Override
            public void onPartialResultSet(PartialResultSet results) {
                GrpcStreamIterator.this.addToStream(results);
            }

            @Override
            public void onCompleted() {
                GrpcStreamIterator.this.addToStream(END_OF_STREAM);
            }

            @Override
            public void onError(SpannerException e) {
                GrpcStreamIterator.this.error = e;
                GrpcStreamIterator.this.addToStream(END_OF_STREAM);
            }

            @VisibleForTesting
            void setCall(SpannerRpc.StreamingCall call) {
                GrpcStreamIterator.this.setCall(call);
            }
        }
    }

    @VisibleForTesting
    static interface CloseableIterator<T>
    extends Iterator<T> {
        public void close(@Nullable String var1);
    }

    private static class GrpcStruct
    extends Struct
    implements Serializable {
        protected final Type type;
        protected final List<Object> rowData;

        private Object writeReplace() {
            Struct.Builder builder = Struct.newBuilder();
            List<Type.StructField> structFields = this.getType().getStructFields();
            block20: for (int i = 0; i < structFields.size(); ++i) {
                Type.StructField field = structFields.get(i);
                String fieldName = field.getName();
                Object value = this.rowData.get(i);
                Type fieldType = field.getType();
                switch (fieldType.getCode()) {
                    case BOOL: {
                        builder.set(fieldName).to((Boolean)value);
                        continue block20;
                    }
                    case INT64: {
                        builder.set(fieldName).to((Long)value);
                        continue block20;
                    }
                    case FLOAT64: {
                        builder.set(fieldName).to((Double)value);
                        continue block20;
                    }
                    case STRING: {
                        builder.set(fieldName).to((String)value);
                        continue block20;
                    }
                    case BYTES: {
                        builder.set(fieldName).to((ByteArray)value);
                        continue block20;
                    }
                    case TIMESTAMP: {
                        builder.set(fieldName).to((Timestamp)value);
                        continue block20;
                    }
                    case DATE: {
                        builder.set(fieldName).to((Date)value);
                        continue block20;
                    }
                    case ARRAY: {
                        switch (fieldType.getArrayElementType().getCode()) {
                            case BOOL: {
                                builder.set(fieldName).toBoolArray((Iterable)value);
                                break;
                            }
                            case INT64: {
                                builder.set(fieldName).toInt64Array((Iterable)value);
                                break;
                            }
                            case FLOAT64: {
                                builder.set(fieldName).toFloat64Array((Iterable)value);
                                break;
                            }
                            case STRING: {
                                builder.set(fieldName).toStringArray((Iterable)value);
                                break;
                            }
                            case BYTES: {
                                builder.set(fieldName).toBytesArray((Iterable)value);
                                break;
                            }
                            case TIMESTAMP: {
                                builder.set(fieldName).toTimestampArray((Iterable)value);
                                break;
                            }
                            case DATE: {
                                builder.set(fieldName).toDateArray((Iterable)value);
                                break;
                            }
                            case STRUCT: {
                                builder.add(fieldName, fieldType.getArrayElementType().getStructFields(), (Iterable)value);
                            }
                        }
                        continue block20;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled type code: " + (Object)((Object)fieldType.getCode())));
                    }
                }
            }
            return builder.build();
        }

        GrpcStruct(Type type, List<Object> rowData) {
            this.type = type;
            this.rowData = rowData;
        }

        boolean consumeRow(Iterator<com.google.protobuf.Value> iterator) {
            this.rowData.clear();
            if (!iterator.hasNext()) {
                return false;
            }
            for (Type.StructField fieldType : this.getType().getStructFields()) {
                if (!iterator.hasNext()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid value stream: end of stream reached before row is complete");
                }
                com.google.protobuf.Value value = iterator.next();
                this.rowData.add(GrpcStruct.decodeValue(fieldType.getType(), value));
            }
            return true;
        }

        private static Object decodeValue(Type fieldType, com.google.protobuf.Value proto) {
            if (proto.getKindCase() == Value.KindCase.NULL_VALUE) {
                return null;
            }
            switch (fieldType.getCode()) {
                case BOOL: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.BOOL_VALUE);
                    return proto.getBoolValue();
                }
                case INT64: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                    return Long.parseLong(proto.getStringValue());
                }
                case FLOAT64: {
                    return SpannerImpl.valueProtoToFloat64(proto);
                }
                case STRING: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                    return proto.getStringValue();
                }
                case BYTES: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                    return ByteArray.fromBase64((String)proto.getStringValue());
                }
                case TIMESTAMP: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                    return Timestamp.parseTimestamp((String)proto.getStringValue());
                }
                case DATE: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.STRING_VALUE);
                    return Date.parseDate((String)proto.getStringValue());
                }
                case ARRAY: {
                    GrpcStruct.checkType(fieldType, proto, Value.KindCase.LIST_VALUE);
                    ListValue listValue = proto.getListValue();
                    return GrpcStruct.decodeArrayValue(fieldType.getArrayElementType(), listValue);
                }
            }
            throw new AssertionError((Object)("Unhandled type code: " + (Object)((Object)fieldType.getCode())));
        }

        private static Object decodeArrayValue(Type elementType, ListValue listValue) {
            switch (elementType.getCode()) {
                case BOOL: {
                    return Lists.transform((List)listValue.getValuesList(), (Function)new Function<com.google.protobuf.Value, Boolean>(){

                        public Boolean apply(com.google.protobuf.Value input) {
                            return input.getKindCase() == Value.KindCase.NULL_VALUE ? null : Boolean.valueOf(input.getBoolValue());
                        }
                    });
                }
                case INT64: {
                    return new Int64Array(listValue);
                }
                case FLOAT64: {
                    return new Float64Array(listValue);
                }
                case STRING: {
                    return Lists.transform((List)listValue.getValuesList(), (Function)new Function<com.google.protobuf.Value, String>(){

                        public String apply(com.google.protobuf.Value input) {
                            return input.getKindCase() == Value.KindCase.NULL_VALUE ? null : input.getStringValue();
                        }
                    });
                }
                case BYTES: {
                    ArrayList<ByteArray> list = new ArrayList<ByteArray>(listValue.getValuesCount());
                    for (com.google.protobuf.Value value : listValue.getValuesList()) {
                        list.add(value.getKindCase() == Value.KindCase.NULL_VALUE ? null : ByteArray.fromBase64((String)value.getStringValue()));
                    }
                    return list;
                }
                case TIMESTAMP: {
                    ArrayList<Timestamp> list = new ArrayList<Timestamp>(listValue.getValuesCount());
                    for (com.google.protobuf.Value value : listValue.getValuesList()) {
                        list.add(value.getKindCase() == Value.KindCase.NULL_VALUE ? null : Timestamp.parseTimestamp((String)value.getStringValue()));
                    }
                    return list;
                }
                case DATE: {
                    ArrayList<Date> list = new ArrayList<Date>(listValue.getValuesCount());
                    for (com.google.protobuf.Value value : listValue.getValuesList()) {
                        list.add(value.getKindCase() == Value.KindCase.NULL_VALUE ? null : Date.parseDate((String)value.getStringValue()));
                    }
                    return list;
                }
                case STRUCT: {
                    ArrayList<GrpcStruct> list = new ArrayList<GrpcStruct>(listValue.getValuesCount());
                    for (com.google.protobuf.Value value : listValue.getValuesList()) {
                        if (value.getKindCase() == Value.KindCase.NULL_VALUE) {
                            list.add(null);
                            continue;
                        }
                        List<Type.StructField> fieldTypes = elementType.getStructFields();
                        ArrayList<Object> fields = new ArrayList<Object>(fieldTypes.size());
                        ListValue structValues = value.getListValue();
                        Preconditions.checkArgument((structValues.getValuesCount() == fieldTypes.size() ? 1 : 0) != 0, (Object)"Size mismatch between type descriptor and actual values.");
                        for (int i = 0; i < fieldTypes.size(); ++i) {
                            fields.add(GrpcStruct.decodeValue(fieldTypes.get(i).getType(), structValues.getValues(i)));
                        }
                        list.add(new GrpcStruct(elementType, fields));
                    }
                    return list;
                }
            }
            throw new AssertionError((Object)("Unhandled type code: " + (Object)((Object)elementType.getCode())));
        }

        private static void checkType(Type fieldType, com.google.protobuf.Value proto, Value.KindCase expected) {
            if (proto.getKindCase() != expected) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid value for column type " + fieldType + " expected " + expected + " but was " + proto.getKindCase());
            }
        }

        Struct immutableCopy() {
            return new GrpcStruct(this.type, new ArrayList<Object>(this.rowData));
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean isNull(int columnIndex) {
            return this.rowData.get(columnIndex) == null;
        }

        @Override
        protected boolean getBooleanInternal(int columnIndex) {
            return (Boolean)this.rowData.get(columnIndex);
        }

        @Override
        protected long getLongInternal(int columnIndex) {
            return (Long)this.rowData.get(columnIndex);
        }

        @Override
        protected double getDoubleInternal(int columnIndex) {
            return (Double)this.rowData.get(columnIndex);
        }

        @Override
        protected String getStringInternal(int columnIndex) {
            return (String)this.rowData.get(columnIndex);
        }

        @Override
        protected ByteArray getBytesInternal(int columnIndex) {
            return (ByteArray)this.rowData.get(columnIndex);
        }

        @Override
        protected Timestamp getTimestampInternal(int columnIndex) {
            return (Timestamp)this.rowData.get(columnIndex);
        }

        @Override
        protected Date getDateInternal(int columnIndex) {
            return (Date)this.rowData.get(columnIndex);
        }

        @Override
        protected boolean[] getBooleanArrayInternal(int columnIndex) {
            List values = (List)this.rowData.get(columnIndex);
            boolean[] r = new boolean[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) == null) {
                    throw SpannerImpl.throwNotNull(columnIndex);
                }
                r[i] = (Boolean)values.get(i);
            }
            return r;
        }

        @Override
        protected List<Boolean> getBooleanListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }

        @Override
        protected long[] getLongArrayInternal(int columnIndex) {
            return (long[])this.getLongListInternal(columnIndex).toPrimitiveArray(columnIndex);
        }

        protected Int64Array getLongListInternal(int columnIndex) {
            return (Int64Array)this.rowData.get(columnIndex);
        }

        @Override
        protected double[] getDoubleArrayInternal(int columnIndex) {
            return (double[])this.getDoubleListInternal(columnIndex).toPrimitiveArray(columnIndex);
        }

        protected Float64Array getDoubleListInternal(int columnIndex) {
            return (Float64Array)this.rowData.get(columnIndex);
        }

        @Override
        protected List<String> getStringListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }

        @Override
        protected List<ByteArray> getBytesListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }

        @Override
        protected List<Timestamp> getTimestampListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }

        @Override
        protected List<Date> getDateListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }

        @Override
        protected List<Struct> getStructListInternal(int columnIndex) {
            return Collections.unmodifiableList((List)this.rowData.get(columnIndex));
        }
    }

    @VisibleForTesting
    static class GrpcResultSet
    extends AbstractResultSet<List<Object>> {
        private final GrpcValueIterator iterator;
        private final AbstractResultSet.Listener listener;
        private final ExecuteSqlRequest.QueryMode queryMode;
        private GrpcStruct currRow;
        private SpannerException error;
        private ResultSetStats statistics;
        private boolean closed;

        GrpcResultSet(CloseableIterator<PartialResultSet> iterator, AbstractResultSet.Listener listener, ExecuteSqlRequest.QueryMode queryMode) {
            this.iterator = new GrpcValueIterator(iterator);
            this.listener = listener;
            this.queryMode = queryMode;
        }

        @Override
        protected GrpcStruct currRow() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"ResultSet is closed");
            Preconditions.checkState((this.currRow != null ? 1 : 0) != 0, (Object)"next() call required");
            return this.currRow;
        }

        @Override
        public boolean next() throws SpannerException {
            if (this.error != null) {
                throw SpannerExceptionFactory.newSpannerException((Throwable)((Object)this.error));
            }
            try {
                if (this.currRow == null) {
                    ResultSetMetadata metadata = this.iterator.getMetadata();
                    if (metadata.hasTransaction()) {
                        this.listener.onTransactionMetadata(metadata.getTransaction());
                    }
                    this.currRow = new GrpcStruct(this.iterator.type(), new ArrayList<Object>());
                }
                boolean hasNext = this.currRow.consumeRow((Iterator<com.google.protobuf.Value>)((Object)this.iterator));
                if (this.queryMode != ExecuteSqlRequest.QueryMode.NORMAL && !hasNext) {
                    this.statistics = this.iterator.getStats();
                }
                return hasNext;
            }
            catch (SpannerException e) {
                throw this.yieldError(e);
            }
        }

        @Override
        public ResultSetStats getStats() {
            if (this.queryMode == ExecuteSqlRequest.QueryMode.NORMAL) {
                throw new UnsupportedOperationException("ResultSetStats are available only in PLAN and PROFILE execution modes");
            }
            Preconditions.checkState((this.statistics != null ? 1 : 0) != 0, (Object)"ResultSetStats requested before consuming the entire ResultSet");
            return this.statistics;
        }

        @Override
        public void close() {
            this.iterator.close("ResultSet closed");
            this.closed = true;
        }

        @Override
        public Type getType() {
            Preconditions.checkState((this.currRow != null ? 1 : 0) != 0, (Object)"next() call required");
            return this.currRow.getType();
        }

        private SpannerException yieldError(SpannerException e) {
            this.close();
            this.listener.onError(e);
            throw e;
        }
    }

    @VisibleForTesting
    static abstract class AbstractResultSet<R>
    extends AbstractStructReader
    implements ResultSet {
        AbstractResultSet() {
        }

        protected abstract GrpcStruct currRow();

        @Override
        public Struct getCurrentRowAsStruct() {
            return this.currRow().immutableCopy();
        }

        @Override
        protected boolean getBooleanInternal(int columnIndex) {
            return this.currRow().getBooleanInternal(columnIndex);
        }

        @Override
        protected long getLongInternal(int columnIndex) {
            return this.currRow().getLongInternal(columnIndex);
        }

        @Override
        protected double getDoubleInternal(int columnIndex) {
            return this.currRow().getDoubleInternal(columnIndex);
        }

        @Override
        protected String getStringInternal(int columnIndex) {
            return this.currRow().getStringInternal(columnIndex);
        }

        @Override
        protected ByteArray getBytesInternal(int columnIndex) {
            return this.currRow().getBytesInternal(columnIndex);
        }

        @Override
        protected Timestamp getTimestampInternal(int columnIndex) {
            return this.currRow().getTimestampInternal(columnIndex);
        }

        @Override
        protected Date getDateInternal(int columnIndex) {
            return this.currRow().getDateInternal(columnIndex);
        }

        @Override
        protected boolean[] getBooleanArrayInternal(int columnIndex) {
            return this.currRow().getBooleanArrayInternal(columnIndex);
        }

        @Override
        protected List<Boolean> getBooleanListInternal(int columnIndex) {
            return this.currRow().getBooleanListInternal(columnIndex);
        }

        @Override
        protected long[] getLongArrayInternal(int columnIndex) {
            return this.currRow().getLongArrayInternal(columnIndex);
        }

        @Override
        protected List<Long> getLongListInternal(int columnIndex) {
            return this.currRow().getLongListInternal(columnIndex);
        }

        @Override
        protected double[] getDoubleArrayInternal(int columnIndex) {
            return this.currRow().getDoubleArrayInternal(columnIndex);
        }

        @Override
        protected List<Double> getDoubleListInternal(int columnIndex) {
            return this.currRow().getDoubleListInternal(columnIndex);
        }

        @Override
        protected List<String> getStringListInternal(int columnIndex) {
            return this.currRow().getStringListInternal(columnIndex);
        }

        @Override
        protected List<ByteArray> getBytesListInternal(int columnIndex) {
            return this.currRow().getBytesListInternal(columnIndex);
        }

        @Override
        protected List<Timestamp> getTimestampListInternal(int columnIndex) {
            return this.currRow().getTimestampListInternal(columnIndex);
        }

        @Override
        protected List<Date> getDateListInternal(int columnIndex) {
            return this.currRow().getDateListInternal(columnIndex);
        }

        @Override
        protected List<Struct> getStructListInternal(int columnIndex) {
            return this.currRow().getStructListInternal(columnIndex);
        }

        @Override
        public boolean isNull(int columnIndex) {
            return this.currRow().isNull(columnIndex);
        }

        static interface Listener {
            public void onTransactionMetadata(Transaction var1) throws SpannerException;

            public void onError(SpannerException var1);

            public void onDone();
        }
    }

    private class MultiUseReadOnlyTransaction
    extends AbstractReadContext
    implements ReadOnlyTransaction {
        private final TimestampBound bound;
        private final Object txnLock;
        @GuardedBy(value="txnLock")
        private Timestamp timestamp;
        @GuardedBy(value="txnLock")
        private ByteString transactionId;

        private MultiUseReadOnlyTransaction(SessionImpl session, TimestampBound bound, SpannerRpc rpc, int defaultPrefetchChunks) {
            super(session, rpc, defaultPrefetchChunks);
            this.txnLock = new Object();
            Preconditions.checkArgument((bound.getMode() != TimestampBound.Mode.MAX_STALENESS && bound.getMode() != TimestampBound.Mode.MIN_READ_TIMESTAMP ? 1 : 0) != 0, (String)"Bounded staleness mode %s is not supported for multi-use read-only transactions. Create a single-use read or read-only transaction instead.", (Object[])new Object[]{bound.getMode()});
            this.bound = bound;
        }

        @Override
        void beforeReadOrQuery() {
            super.beforeReadOrQuery();
            this.initTransaction();
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            TransactionSelector selector = TransactionSelector.newBuilder().setId(this.transactionId).build();
            return selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Timestamp getReadTimestamp() {
            Object object = this.txnLock;
            synchronized (object) {
                SpannerImpl.assertTimestampAvailable(this.timestamp != null);
                return this.timestamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initTransaction() {
            Object object = this.txnLock;
            synchronized (object) {
                if (this.transactionId != null) {
                    return;
                }
                TransactionOptions.Builder options = TransactionOptions.newBuilder();
                this.bound.applyToBuilder(options.getReadOnlyBuilder()).setReturnReadTimestamp(true);
                final BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(this.session.getName()).setOptions(options).build();
                Transaction transaction = SpannerImpl.runWithRetries(new Callable<Transaction>(){

                    @Override
                    public Transaction call() throws Exception {
                        return MultiUseReadOnlyTransaction.this.rpc.beginTransaction(request, MultiUseReadOnlyTransaction.this.session.options);
                    }
                });
                if (!transaction.hasReadTimestamp()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing expected transaction.read_timestamp metadata field");
                }
                if (transaction.getId().isEmpty()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing expected transaction.id metadata field");
                }
                try {
                    this.timestamp = Timestamp.fromProto((com.google.protobuf.Timestamp)transaction.getReadTimestamp());
                }
                catch (IllegalArgumentException e) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Bad value in transaction.read_timestamp metadata field", e);
                }
                this.transactionId = transaction.getId();
            }
        }
    }

    private class SingleUseReadOnlyTransaction
    extends SingleReadContext
    implements ReadOnlyTransaction {
        @GuardedBy(value="lock")
        private Timestamp timestamp;

        private SingleUseReadOnlyTransaction(SessionImpl session, TimestampBound bound, SpannerRpc rpc, int defaultPrefetchChunks) {
            super(session, bound, rpc, defaultPrefetchChunks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Timestamp getReadTimestamp() {
            Object object = this.lock;
            synchronized (object) {
                SpannerImpl.assertTimestampAvailable(this.timestamp != null);
                return this.timestamp;
            }
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            TransactionOptions.Builder options = TransactionOptions.newBuilder();
            this.bound.applyToBuilder(options.getReadOnlyBuilder()).setReturnReadTimestamp(true);
            return TransactionSelector.newBuilder().setSingleUse(options).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTransactionMetadata(Transaction transaction) {
            Object object = this.lock;
            synchronized (object) {
                if (!transaction.hasReadTimestamp()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing expected transaction.read_timestamp metadata field");
                }
                try {
                    this.timestamp = Timestamp.fromProto((com.google.protobuf.Timestamp)transaction.getReadTimestamp());
                }
                catch (IllegalArgumentException e) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Bad value in transaction.read_timestamp metadata field", e);
                }
            }
        }
    }

    private static class SingleReadContext
    extends AbstractReadContext {
        final TimestampBound bound;
        @GuardedBy(value="lock")
        private boolean used;

        private SingleReadContext(SessionImpl session, TimestampBound bound, SpannerRpc rpc, int defaultPrefetchChunks) {
            super(session, rpc, defaultPrefetchChunks);
            this.bound = bound;
        }

        @Override
        @GuardedBy(value="lock")
        void beforeReadOrQueryLocked() {
            super.beforeReadOrQueryLocked();
            Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"Cannot use a single-read ReadContext for multiple reads");
            this.used = true;
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            if (this.bound.getMode() == TimestampBound.Mode.STRONG) {
                return null;
            }
            return TransactionSelector.newBuilder().setSingleUse(TransactionOptions.newBuilder().setReadOnly(this.bound.toProto())).build();
        }
    }

    @VisibleForTesting
    static class TransactionContextImpl
    extends AbstractReadContext
    implements TransactionContext {
        @GuardedBy(value="lock")
        private List<Mutation> mutations = new ArrayList<Mutation>();
        @GuardedBy(value="lock")
        private boolean aborted;
        @GuardedBy(value="lock")
        private long retryDelayInMillis = -1L;
        private ByteString transactionId;
        private Timestamp commitTimestamp;

        TransactionContextImpl(SessionImpl session, @Nullable ByteString transactionId, SpannerRpc rpc, int defaultPrefetchChunks) {
            super(session, rpc, defaultPrefetchChunks);
            this.transactionId = transactionId;
        }

        void ensureTxn() {
            if (this.transactionId == null) {
                this.transactionId = this.session.beginTransaction();
                txnLogger.log(Level.FINER, "Started transaction {0}", txnLogger.isLoggable(Level.FINER) ? this.transactionId.asReadOnlyByteBuffer() : null);
            } else {
                txnLogger.log(Level.FINER, "Using prepared transaction {0}", txnLogger.isLoggable(Level.FINER) ? this.transactionId.asReadOnlyByteBuffer() : null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commit() {
            CommitRequest.Builder builder = CommitRequest.newBuilder().setSession(this.session.getName()).setTransactionId(this.transactionId);
            Object object = this.lock;
            synchronized (object) {
                if (!this.mutations.isEmpty()) {
                    ArrayList<com.google.spanner.v1.Mutation> mutationsProto = new ArrayList<com.google.spanner.v1.Mutation>();
                    Mutation.toProto(this.mutations, mutationsProto);
                    builder.addAllMutations(mutationsProto);
                }
                this.mutations = null;
            }
            final CommitRequest commitRequest = builder.build();
            CommitResponse commitResponse = SpannerImpl.runWithRetries(new Callable<CommitResponse>(){

                @Override
                public CommitResponse call() throws Exception {
                    return TransactionContextImpl.this.rpc.commit(commitRequest, TransactionContextImpl.this.session.options);
                }
            });
            if (!commitResponse.hasCommitTimestamp()) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing commitTimestamp:\n" + this.session.getName());
            }
            this.commitTimestamp = Timestamp.fromProto((com.google.protobuf.Timestamp)commitResponse.getCommitTimestamp());
        }

        Timestamp commitTimestamp() {
            Preconditions.checkState((this.commitTimestamp != null ? 1 : 0) != 0, (Object)"run() has not yet returned normally");
            return this.commitTimestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAborted() {
            Object object = this.lock;
            synchronized (object) {
                return this.aborted;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getRetryDelayInMillis(BackOff backoff) {
            long delay = SpannerImpl.nextBackOffMillis(backoff);
            Object object = this.lock;
            synchronized (object) {
                if (this.retryDelayInMillis >= 0L) {
                    return this.retryDelayInMillis;
                }
            }
            return delay;
        }

        void rollback() {
            try {
                this.rpc.rollback(RollbackRequest.newBuilder().setSession(this.session.getName()).setTransactionId(this.transactionId).build(), this.session.options);
            }
            catch (SpannerException e) {
                txnLogger.log(Level.FINE, "Exception during rollback", (Throwable)((Object)e));
            }
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            return TransactionSelector.newBuilder().setId(this.transactionId).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(SpannerException e) {
            if (e.getErrorCode() == ErrorCode.ABORTED) {
                long delay = -1L;
                if (e instanceof AbortedException) {
                    delay = ((AbortedException)e).getRetryDelayInMillis();
                }
                if (delay == -1L) {
                    txnLogger.log(Level.FINE, "Retry duration is missing from the exception.", (Throwable)((Object)e));
                }
                Object object = this.lock;
                synchronized (object) {
                    this.retryDelayInMillis = delay;
                    this.aborted = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buffer(Mutation mutation) {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkNotNull(this.mutations, (Object)"Context is closed");
                this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buffer(Iterable<Mutation> mutations) {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkNotNull(this.mutations, (Object)"Context is closed");
                for (Mutation mutation : mutations) {
                    this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
                }
            }
        }
    }

    @VisibleForTesting
    static class TransactionRunnerImpl
    implements SessionTransaction,
    TransactionRunner {
        private final SessionImpl session;
        private final Sleeper sleeper;
        private TransactionContextImpl txn;
        private volatile boolean isValid = true;

        TransactionRunnerImpl(SessionImpl session, SpannerRpc rpc, Sleeper sleeper, int defaultPrefetchChunks) {
            ByteString transactionId = session.readyTransactionId;
            session.readyTransactionId = null;
            this.session = session;
            this.sleeper = sleeper;
            this.txn = new TransactionContextImpl(session, transactionId, rpc, defaultPrefetchChunks);
        }

        TransactionRunnerImpl(SessionImpl session, SpannerRpc rpc, int defaultPrefetchChunks) {
            this(session, rpc, new Sleeper(), defaultPrefetchChunks);
        }

        @Override
        @Nullable
        public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
            ExponentialBackOff backoff = SpannerImpl.newBackOff();
            Context context = Context.current();
            while (true) {
                T result;
                Preconditions.checkState((boolean)this.isValid, (Object)"TransactionRunner has been invalidated by a new operation on the session");
                SpannerImpl.checkContext(context);
                this.txn.ensureTxn();
                boolean shouldRollback = true;
                try {
                    result = callable.run(this.txn);
                    shouldRollback = false;
                }
                catch (Exception e) {
                    txnLogger.log(Level.FINE, "User-provided TransactionCallable raised exception", e);
                    if (this.txn.isAborted()) {
                        shouldRollback = false;
                        this.backoff(context, (BackOff)backoff);
                        continue;
                    }
                    if (e instanceof SpannerException) {
                        throw (SpannerException)((Object)e);
                    }
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.UNKNOWN, e.getMessage(), e);
                }
                finally {
                    if (!shouldRollback) continue;
                    this.txn.rollback();
                    continue;
                }
                try {
                    this.txn.commit();
                    return result;
                }
                catch (AbortedException e) {
                    txnLogger.log(Level.FINE, "Commit aborted", (Throwable)((Object)e));
                    this.backoff(context, (BackOff)backoff);
                    continue;
                }
                break;
            }
        }

        @Override
        public Timestamp getCommitTimestamp() {
            return this.txn.commitTimestamp();
        }

        @Override
        public void invalidate() {
            this.isValid = false;
        }

        private void backoff(Context context, BackOff backoff) {
            long delay = this.txn.getRetryDelayInMillis(backoff);
            this.txn = new TransactionContextImpl(this.session, null, this.txn.rpc, this.txn.defaultPrefetchChunks);
            this.sleeper.backoffSleep(context, delay);
        }

        static class Sleeper {
            Sleeper() {
            }

            void backoffSleep(Context context, long backoffMillis) {
                SpannerImpl.backoffSleep(context, backoffMillis);
            }
        }
    }

    private static enum DirectExecutor implements Executor
    {
        INSTANCE;


        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    private static abstract class AbstractReadContext
    implements ReadContext,
    AbstractResultSet.Listener,
    SessionTransaction {
        final Object lock = new Object();
        final SessionImpl session;
        final SpannerRpc rpc;
        final int defaultPrefetchChunks;
        @GuardedBy(value="lock")
        private boolean isValid = true;
        @GuardedBy(value="lock")
        private boolean isClosed = false;
        private static final int MAX_BUFFERED_CHUNKS = 2048;

        private AbstractReadContext(SessionImpl session, SpannerRpc rpc, int defaultPrefetchChunks) {
            this.session = session;
            this.rpc = rpc;
            this.defaultPrefetchChunks = defaultPrefetchChunks;
        }

        @Override
        public final ResultSet read(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return this.readInternal(table, null, keys, columns, options);
        }

        @Override
        public final ResultSet readUsingIndex(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return this.readInternal(table, (String)Preconditions.checkNotNull((Object)index), keys, columns, options);
        }

        @Override
        @Nullable
        public final Struct readRow(String table, Key key, Iterable<String> columns) {
            try (ResultSet resultSet = this.read(table, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
                Struct struct = this.consumeSingleRow(resultSet);
                return struct;
            }
        }

        @Override
        @Nullable
        public final Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
            try (ResultSet resultSet = this.readUsingIndex(table, index, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
                Struct struct = this.consumeSingleRow(resultSet);
                return struct;
            }
        }

        @Override
        public final ResultSet executeQuery(Statement statement, Options.QueryOption ... options) {
            return this.executeQueryInternal(statement, ExecuteSqlRequest.QueryMode.NORMAL, options);
        }

        @Override
        public final ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode readContextQueryMode) {
            switch (readContextQueryMode) {
                case PROFILE: {
                    return this.executeQueryInternal(statement, ExecuteSqlRequest.QueryMode.PROFILE, new Options.QueryOption[0]);
                }
                case PLAN: {
                    return this.executeQueryInternal(statement, ExecuteSqlRequest.QueryMode.PLAN, new Options.QueryOption[0]);
                }
            }
            throw new IllegalStateException("Unknown value for QueryAnalyzeMode : " + (Object)((Object)readContextQueryMode));
        }

        private ResultSet executeQueryInternal(Statement statement, ExecuteSqlRequest.QueryMode queryMode, Options.QueryOption ... options) {
            TransactionSelector selector;
            this.beforeReadOrQuery();
            ExecuteSqlRequest.Builder builder = ExecuteSqlRequest.newBuilder().setSql(statement.getSql()).setQueryMode(queryMode).setSession(this.session.name);
            Map<String, Value> stmtParameters = statement.getParameters();
            if (!stmtParameters.isEmpty()) {
                Struct.Builder paramsBuilder = builder.getParamsBuilder();
                for (Map.Entry<String, Value> param : stmtParameters.entrySet()) {
                    paramsBuilder.putFields(param.getKey(), param.getValue().toProto());
                    builder.putParamTypes(param.getKey(), param.getValue().getType().toProto());
                }
            }
            if ((selector = this.getTransactionSelector()) != null) {
                builder.setTransaction(selector);
            }
            final ExecuteSqlRequest request = builder.build();
            Options readOptions = Options.fromQueryOptions(options);
            final int prefetchChunks = readOptions.hasPrefetchChunks() ? readOptions.prefetchChunks() : this.defaultPrefetchChunks;
            ResumableStreamIterator stream = new ResumableStreamIterator(2048){

                @Override
                CloseableIterator<PartialResultSet> startStream(@Nullable ByteString resumeToken) {
                    GrpcStreamIterator stream = new GrpcStreamIterator(prefetchChunks);
                    SpannerRpc.StreamingCall call = AbstractReadContext.this.rpc.executeQuery(resumeToken == null ? request : request.toBuilder().setResumeToken(resumeToken).build(), stream.consumer(), AbstractReadContext.this.session.options);
                    if (prefetchChunks > 1) {
                        call.request(prefetchChunks - 1);
                    }
                    stream.setCall(call);
                    return stream;
                }
            };
            return new GrpcResultSet(stream, this, queryMode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void beforeReadOrQuery() {
            Object object = this.lock;
            synchronized (object) {
                this.beforeReadOrQueryLocked();
            }
        }

        @GuardedBy(value="lock")
        void beforeReadOrQueryLocked() {
            Preconditions.checkState((boolean)this.isValid, (Object)"Context has been invalidated by a new operation on the session");
            Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"Context has been closed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void invalidate() {
            Object object = this.lock;
            synchronized (object) {
                this.isValid = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.isClosed = true;
            }
        }

        @Nullable
        abstract TransactionSelector getTransactionSelector();

        @Override
        public void onTransactionMetadata(Transaction transaction) {
        }

        @Override
        public void onError(SpannerException e) {
        }

        @Override
        public void onDone() {
        }

        private ResultSet readInternal(String table, @Nullable String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            TransactionSelector selector;
            this.beforeReadOrQuery();
            ReadRequest.Builder builder = ReadRequest.newBuilder().setSession(this.session.name).setTable((String)Preconditions.checkNotNull((Object)table)).addAllColumns(columns);
            Options readOptions = Options.fromReadOptions(options);
            if (readOptions.hasLimit()) {
                builder.setLimit(readOptions.limit());
            }
            keys.appendToProto(builder.getKeySetBuilder());
            if (index != null) {
                builder.setIndex(index);
            }
            if ((selector = this.getTransactionSelector()) != null) {
                builder.setTransaction(selector);
            }
            final ReadRequest request = builder.build();
            final int prefetchChunks = readOptions.hasPrefetchChunks() ? readOptions.prefetchChunks() : this.defaultPrefetchChunks;
            ResumableStreamIterator stream = new ResumableStreamIterator(2048){

                @Override
                CloseableIterator<PartialResultSet> startStream(@Nullable ByteString resumeToken) {
                    GrpcStreamIterator stream = new GrpcStreamIterator(prefetchChunks);
                    SpannerRpc.StreamingCall call = AbstractReadContext.this.rpc.read(resumeToken == null ? request : request.toBuilder().setResumeToken(resumeToken).build(), stream.consumer(), AbstractReadContext.this.session.options);
                    if (prefetchChunks > 1) {
                        call.request(prefetchChunks - 1);
                    }
                    stream.setCall(call);
                    return stream;
                }
            };
            GrpcResultSet resultSet = new GrpcResultSet(stream, this, ExecuteSqlRequest.QueryMode.NORMAL);
            return resultSet;
        }

        private Struct consumeSingleRow(ResultSet resultSet) {
            if (!resultSet.next()) {
                return null;
            }
            Struct row = resultSet.getCurrentRowAsStruct();
            if (resultSet.next()) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Multiple rows returned for single key");
            }
            return row;
        }
    }

    private static interface SessionTransaction {
        public void invalidate();
    }

    class SessionImpl
    implements Session {
        private final String name;
        private SessionTransaction activeTransaction;
        private ByteString readyTransactionId;
        private final Map<SpannerRpc.Option, ?> options;

        SessionImpl(String name, Map<SpannerRpc.Option, ?> options) {
            this.options = options;
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
            TransactionRunner runner = this.readWriteTransaction();
            final Collection finalMutations = mutations instanceof Collection ? (Collection)mutations : Lists.newArrayList(mutations);
            runner.run(new TransactionRunner.TransactionCallable<Void>(){

                @Override
                public Void run(TransactionContext ctx) {
                    ctx.buffer(finalMutations);
                    return null;
                }
            });
            return runner.getCommitTimestamp();
        }

        @Override
        public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
            this.setActive(null);
            ArrayList<com.google.spanner.v1.Mutation> mutationsProto = new ArrayList<com.google.spanner.v1.Mutation>();
            Mutation.toProto(mutations, mutationsProto);
            final CommitRequest request = CommitRequest.newBuilder().setSession(this.name).addAllMutations(mutationsProto).setSingleUseTransaction(TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance())).build();
            CommitResponse response = SpannerImpl.runWithRetries(new Callable<CommitResponse>(){

                @Override
                public CommitResponse call() throws Exception {
                    return SpannerImpl.this.rpc.commit(request, SessionImpl.this.options);
                }
            });
            try {
                return Timestamp.fromProto((com.google.protobuf.Timestamp)response.getCommitTimestamp());
            }
            catch (IllegalArgumentException e) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Could not parse commit timestamp", e);
            }
        }

        @Override
        public ReadContext singleUse() {
            return this.singleUse(TimestampBound.strong());
        }

        @Override
        public ReadContext singleUse(TimestampBound bound) {
            return this.setActive(new SingleReadContext(this, bound, SpannerImpl.this.rpc, SpannerImpl.this.defaultPrefetchChunks));
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction() {
            return this.singleUseReadOnlyTransaction(TimestampBound.strong());
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
            return this.setActive(new SingleUseReadOnlyTransaction(this, bound, SpannerImpl.this.rpc, SpannerImpl.this.defaultPrefetchChunks));
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction() {
            return this.readOnlyTransaction(TimestampBound.strong());
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
            return this.setActive(new MultiUseReadOnlyTransaction(this, bound, SpannerImpl.this.rpc, SpannerImpl.this.defaultPrefetchChunks));
        }

        @Override
        public TransactionRunner readWriteTransaction() {
            return this.setActive(new TransactionRunnerImpl(this, SpannerImpl.this.rpc, SpannerImpl.this.defaultPrefetchChunks));
        }

        @Override
        public void prepareReadWriteTransaction() {
            this.setActive(null);
            this.readyTransactionId = this.beginTransaction();
        }

        @Override
        public void close() {
            SpannerImpl.runWithRetries(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SpannerImpl.this.rpc.deleteSession(SessionImpl.this.name, SessionImpl.this.options);
                    return null;
                }
            });
        }

        ByteString beginTransaction() {
            final BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(this.name).setOptions(TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance())).build();
            Transaction txn = SpannerImpl.runWithRetries(new Callable<Transaction>(){

                @Override
                public Transaction call() throws Exception {
                    return SpannerImpl.this.rpc.beginTransaction(request, SessionImpl.this.options);
                }
            });
            if (txn.getId().isEmpty()) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing id in transaction\n" + this.getName());
            }
            return txn.getId();
        }

        private <T extends SessionTransaction> T setActive(@Nullable T ctx) {
            if (this.activeTransaction != null) {
                this.activeTransaction.invalidate();
            }
            this.activeTransaction = ctx;
            this.readyTransactionId = null;
            return ctx;
        }
    }

    class InstanceAdminClientImpl
    implements InstanceAdminClient {
        final DatabaseAdminClient dbClient;

        InstanceAdminClientImpl(DatabaseAdminClient dbClient) {
            this.dbClient = dbClient;
        }

        @Override
        public InstanceConfig getInstanceConfig(String configId) throws SpannerException {
            final String instanceConfigName = new InstanceConfigId(SpannerImpl.this.getProjectId(), configId).getName();
            return SpannerImpl.runWithRetries(new Callable<InstanceConfig>(){

                @Override
                public InstanceConfig call() {
                    return InstanceConfig.fromProto(SpannerImpl.this.rpc.getInstanceConfig(instanceConfigName), InstanceAdminClientImpl.this);
                }
            });
        }

        @Override
        public Page<InstanceConfig> listInstanceConfigs(Options.ListOption ... options) {
            Options listOptions = Options.fromListOptions(options);
            Preconditions.checkArgument((!listOptions.hasFilter() ? 1 : 0) != 0, (Object)"Filter option is not supported by listInstanceConfigs");
            final int pageSize = listOptions.hasPageSize() ? listOptions.pageSize() : 0;
            PageFetcher<InstanceConfig, com.google.spanner.admin.instance.v1.InstanceConfig> pageFetcher = new PageFetcher<InstanceConfig, com.google.spanner.admin.instance.v1.InstanceConfig>(){

                @Override
                public SpannerRpc.Paginated<com.google.spanner.admin.instance.v1.InstanceConfig> getNextPage(String nextPageToken) {
                    return SpannerImpl.this.rpc.listInstanceConfigs(pageSize, nextPageToken);
                }

                @Override
                public InstanceConfig fromProto(com.google.spanner.admin.instance.v1.InstanceConfig proto) {
                    return InstanceConfig.fromProto(proto, InstanceAdminClientImpl.this);
                }
            };
            if (listOptions.hasPageToken()) {
                ((PageFetcher)pageFetcher).nextPageToken = listOptions.pageToken();
            }
            return pageFetcher.getNextPage();
        }

        @Override
        public Operation<Instance, CreateInstanceMetadata> createInstance(InstanceInfo instance) throws SpannerException {
            String projectName = PROJECT_NAME_TEMPLATE.instantiate(new String[]{"project", SpannerImpl.this.getProjectId()});
            com.google.longrunning.Operation op = SpannerImpl.this.rpc.createInstance(projectName, instance.getId().getInstance(), instance.toProto());
            return Operation.create(SpannerImpl.this.rpc, op, new Operation.Parser<Instance, CreateInstanceMetadata>(){

                @Override
                public Instance parseResult(Any response) {
                    return Instance.fromProto((com.google.spanner.admin.instance.v1.Instance)SpannerImpl.this.unpack(response, com.google.spanner.admin.instance.v1.Instance.class), InstanceAdminClientImpl.this, InstanceAdminClientImpl.this.dbClient);
                }

                @Override
                public CreateInstanceMetadata parseMetadata(Any metadata) {
                    return (CreateInstanceMetadata)SpannerImpl.this.unpack(metadata, CreateInstanceMetadata.class);
                }
            });
        }

        @Override
        public Instance getInstance(String instanceId) throws SpannerException {
            final String instanceName = new InstanceId(SpannerImpl.this.getProjectId(), instanceId).getName();
            return SpannerImpl.runWithRetries(new Callable<Instance>(){

                @Override
                public Instance call() {
                    return Instance.fromProto(SpannerImpl.this.rpc.getInstance(instanceName), InstanceAdminClientImpl.this, InstanceAdminClientImpl.this.dbClient);
                }
            });
        }

        @Override
        public Page<Instance> listInstances(Options.ListOption ... options) throws SpannerException {
            Options listOptions = Options.fromListOptions(options);
            final int pageSize = listOptions.hasPageSize() ? listOptions.pageSize() : 0;
            final String filter = listOptions.filter();
            PageFetcher<Instance, com.google.spanner.admin.instance.v1.Instance> pageFetcher = new PageFetcher<Instance, com.google.spanner.admin.instance.v1.Instance>(){

                @Override
                public SpannerRpc.Paginated<com.google.spanner.admin.instance.v1.Instance> getNextPage(String nextPageToken) {
                    return SpannerImpl.this.rpc.listInstances(pageSize, nextPageToken, filter);
                }

                @Override
                public Instance fromProto(com.google.spanner.admin.instance.v1.Instance proto) {
                    return Instance.fromProto(proto, InstanceAdminClientImpl.this, InstanceAdminClientImpl.this.dbClient);
                }
            };
            if (listOptions.hasPageToken()) {
                ((PageFetcher)pageFetcher).nextPageToken = listOptions.pageToken();
            }
            return pageFetcher.getNextPage();
        }

        @Override
        public void deleteInstance(final String instanceId) throws SpannerException {
            SpannerImpl.runWithRetries(new Callable<Void>(){

                @Override
                public Void call() {
                    SpannerImpl.this.rpc.deleteInstance(new InstanceId(SpannerImpl.this.getProjectId(), instanceId).getName());
                    return null;
                }
            });
        }

        @Override
        public Operation<Instance, UpdateInstanceMetadata> updateInstance(InstanceInfo instance, InstanceInfo.InstanceField ... fieldsToUpdate) {
            FieldMask fieldMask = fieldsToUpdate.length == 0 ? InstanceInfo.InstanceField.toFieldMask(InstanceInfo.InstanceField.values()) : InstanceInfo.InstanceField.toFieldMask(fieldsToUpdate);
            com.google.longrunning.Operation op = SpannerImpl.this.rpc.updateInstance(instance.toProto(), fieldMask);
            return Operation.create(SpannerImpl.this.rpc, op, new Operation.Parser<Instance, UpdateInstanceMetadata>(){

                @Override
                public Instance parseResult(Any response) {
                    return Instance.fromProto((com.google.spanner.admin.instance.v1.Instance)SpannerImpl.this.unpack(response, com.google.spanner.admin.instance.v1.Instance.class), InstanceAdminClientImpl.this, InstanceAdminClientImpl.this.dbClient);
                }

                @Override
                public UpdateInstanceMetadata parseMetadata(Any metadata) {
                    return (UpdateInstanceMetadata)SpannerImpl.this.unpack(metadata, UpdateInstanceMetadata.class);
                }
            });
        }

        @Override
        public Instance.Builder newInstanceBuilder(InstanceId id) {
            return new Instance.Builder(this, this.dbClient, id);
        }
    }

    class DatabaseAdminClientImpl
    implements DatabaseAdminClient {
        DatabaseAdminClientImpl() {
        }

        @Override
        public Operation<Database, CreateDatabaseMetadata> createDatabase(String instanceId, String databaseId, Iterable<String> statements) throws SpannerException {
            String instanceName = SpannerImpl.this.getInstanceName(instanceId);
            String createStatement = "CREATE DATABASE `" + databaseId + "`";
            com.google.longrunning.Operation op = SpannerImpl.this.rpc.createDatabase(instanceName, createStatement, statements);
            return Operation.create(SpannerImpl.this.rpc, op, new Operation.Parser<Database, CreateDatabaseMetadata>(){

                @Override
                public Database parseResult(Any response) {
                    return Database.fromProto((com.google.spanner.admin.database.v1.Database)SpannerImpl.this.unpack(response, com.google.spanner.admin.database.v1.Database.class), DatabaseAdminClientImpl.this);
                }

                @Override
                public CreateDatabaseMetadata parseMetadata(Any metadata) {
                    return (CreateDatabaseMetadata)SpannerImpl.this.unpack(metadata, CreateDatabaseMetadata.class);
                }
            });
        }

        @Override
        public Database getDatabase(String instanceId, String databaseId) throws SpannerException {
            final String dbName = SpannerImpl.this.getDatabaseName(instanceId, databaseId);
            Callable<Database> callable = new Callable<Database>(){

                @Override
                public Database call() throws Exception {
                    return Database.fromProto(SpannerImpl.this.rpc.getDatabase(dbName), DatabaseAdminClientImpl.this);
                }
            };
            return SpannerImpl.runWithRetries(callable);
        }

        @Override
        public Operation<Void, UpdateDatabaseDdlMetadata> updateDatabaseDdl(final String instanceId, final String databaseId, final Iterable<String> statements, @Nullable String operationId) throws SpannerException {
            final String dbName = SpannerImpl.this.getDatabaseName(instanceId, databaseId);
            final String opId = operationId != null ? operationId : SpannerImpl.this.randomOperationId();
            Callable<Operation<Void, UpdateDatabaseDdlMetadata>> callable = new Callable<Operation<Void, UpdateDatabaseDdlMetadata>>(){

                @Override
                public Operation<Void, UpdateDatabaseDdlMetadata> call() {
                    com.google.longrunning.Operation op = null;
                    try {
                        op = SpannerImpl.this.rpc.updateDatabaseDdl(dbName, statements, opId);
                    }
                    catch (SpannerException e) {
                        if (e.getErrorCode() == ErrorCode.ALREADY_EXISTS) {
                            String opName = OP_NAME_TEMPLATE.instantiate(new String[]{"project", SpannerImpl.this.getProjectId(), "instance", instanceId, "database", databaseId, "operation", opId});
                            op = com.google.longrunning.Operation.newBuilder().setName(opName).build();
                        }
                        throw e;
                    }
                    return Operation.create(SpannerImpl.this.rpc, op, new Operation.Parser<Void, UpdateDatabaseDdlMetadata>(){

                        @Override
                        public Void parseResult(Any response) {
                            return null;
                        }

                        @Override
                        public UpdateDatabaseDdlMetadata parseMetadata(Any metadata) {
                            return (UpdateDatabaseDdlMetadata)SpannerImpl.this.unpack(metadata, UpdateDatabaseDdlMetadata.class);
                        }
                    });
                }
            };
            return SpannerImpl.runWithRetries(callable);
        }

        @Override
        public void dropDatabase(String instanceId, String databaseId) throws SpannerException {
            final String dbName = SpannerImpl.this.getDatabaseName(instanceId, databaseId);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SpannerImpl.this.rpc.dropDatabase(dbName);
                    return null;
                }
            };
            SpannerImpl.runWithRetries(callable);
        }

        @Override
        public List<String> getDatabaseDdl(String instanceId, String databaseId) {
            final String dbName = SpannerImpl.this.getDatabaseName(instanceId, databaseId);
            Callable<List<String>> callable = new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return SpannerImpl.this.rpc.getDatabaseDdl(dbName);
                }
            };
            return SpannerImpl.runWithRetries(callable);
        }

        @Override
        public Page<Database> listDatabases(String instanceId, Options.ListOption ... options) {
            final String instanceName = SpannerImpl.this.getInstanceName(instanceId);
            Options listOptions = Options.fromListOptions(options);
            Preconditions.checkArgument((!listOptions.hasFilter() ? 1 : 0) != 0, (Object)"Filter option is not support bylistDatabases");
            final int pageSize = listOptions.hasPageSize() ? listOptions.pageSize() : 0;
            PageFetcher<Database, com.google.spanner.admin.database.v1.Database> pageFetcher = new PageFetcher<Database, com.google.spanner.admin.database.v1.Database>(){

                @Override
                public SpannerRpc.Paginated<com.google.spanner.admin.database.v1.Database> getNextPage(String nextPageToken) {
                    return SpannerImpl.this.rpc.listDatabases(instanceName, pageSize, nextPageToken);
                }

                @Override
                public Database fromProto(com.google.spanner.admin.database.v1.Database proto) {
                    return Database.fromProto(proto, DatabaseAdminClientImpl.this);
                }
            };
            if (listOptions.hasPageToken()) {
                ((PageFetcher)pageFetcher).nextPageToken = listOptions.pageToken();
            }
            return pageFetcher.getNextPage();
        }
    }

    private abstract class PageFetcher<S, T>
    implements PageImpl.NextPageFetcher<S> {
        private String nextPageToken;

        private PageFetcher() {
        }

        public Page<S> getNextPage() {
            SpannerRpc.Paginated nextPage = (SpannerRpc.Paginated)SpannerImpl.runWithRetries(new Callable<SpannerRpc.Paginated<T>>(){

                @Override
                public SpannerRpc.Paginated<T> call() {
                    return PageFetcher.this.getNextPage(PageFetcher.this.nextPageToken);
                }
            });
            this.nextPageToken = nextPage.getNextPageToken();
            ArrayList<S> results = new ArrayList<S>();
            for (Object proto : nextPage.getResults()) {
                results.add(this.fromProto(proto));
            }
            return new PageImpl((PageImpl.NextPageFetcher)this, this.nextPageToken, results);
        }

        abstract SpannerRpc.Paginated<T> getNextPage(@Nullable String var1);

        abstract S fromProto(T var1);
    }

    static class SessionOption {
        private final SpannerRpc.Option rpcOption;
        private final Object value;

        SessionOption(SpannerRpc.Option option, Object value) {
            this.rpcOption = (SpannerRpc.Option)((Object)Preconditions.checkNotNull((Object)((Object)option)));
            this.value = value;
        }

        static SessionOption channelHint(long hint) {
            return new SessionOption(SpannerRpc.Option.CHANNEL_HINT, hint);
        }

        SpannerRpc.Option rpcOption() {
            return this.rpcOption;
        }

        Object value() {
            return this.value;
        }
    }
}

