/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.AlarmFactory;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.MoreApiFutures;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.wire.ApiServiceUtils;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Optional;
import java.util.concurrent.Future;

public class BatchingCommitter
extends ProxyService
implements Committer {
    private final Committer underlying;
    @GuardedBy(value="this")
    private SettableApiFuture<Void> currentFuture = SettableApiFuture.create();
    @GuardedBy(value="this")
    private Optional<Offset> currentOffset = Optional.empty();

    BatchingCommitter(Committer underlying, AlarmFactory alarmFactory) {
        super(underlying);
        this.underlying = underlying;
        Future<?> alarm = alarmFactory.newAlarm(this::flush);
        this.addServices(ApiServiceUtils.autoCloseableAsApiService(() -> alarm.cancel(false)));
    }

    @Override
    public synchronized ApiFuture<Void> commitOffset(Offset offset) {
        this.currentOffset = Optional.of(offset);
        return this.currentFuture;
    }

    @Override
    public void waitUntilEmpty() throws CheckedApiException {
        this.flush();
        this.underlying.waitUntilEmpty();
    }

    @Override
    protected void stop() {
        this.flush();
    }

    private synchronized void flush() {
        if (!this.currentOffset.isPresent()) {
            return;
        }
        ApiFuture<Void> underlyingFuture = this.underlying.commitOffset(this.currentOffset.get());
        MoreApiFutures.connectFutures(underlyingFuture, this.currentFuture);
        this.currentOffset = Optional.empty();
        this.currentFuture = SettableApiFuture.create();
    }
}

