/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;

public final class SerialExecutor
implements AutoCloseable,
Executor {
    private final Executor executor;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    @GuardedBy(value="this")
    private final Queue<Runnable> tasks;
    @GuardedBy(value="this")
    private boolean isTaskActive;

    public SerialExecutor(Executor executor) {
        this.executor = executor;
        this.tasks = new ArrayDeque<Runnable>();
        this.isTaskActive = false;
    }

    @Override
    public void close() {
        this.isShutdown.set(true);
    }

    @Override
    public synchronized void execute(Runnable r) {
        if (this.isShutdown.get()) {
            return;
        }
        this.tasks.add(() -> {
            if (this.isShutdown.get()) {
                return;
            }
            try {
                r.run();
            }
            finally {
                this.scheduleNextTask();
            }
        });
        if (!this.isTaskActive) {
            this.scheduleNextTask();
        }
    }

    private synchronized void scheduleNextTask() {
        boolean bl = this.isTaskActive = !this.tasks.isEmpty();
        if (this.isTaskActive) {
            this.executor.execute(this.tasks.poll());
        }
    }
}

