/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.StatusCode;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.PublishSequenceNumber;
import com.google.cloud.pubsublite.internal.wire.AutoValue_SerialBatcher_UnbatchedMessage;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

class SerialBatcher {
    private final long byteLimit;
    private final long messageLimit;
    private Deque<UnbatchedMessage> messages = new ArrayDeque<UnbatchedMessage>();

    private static boolean hasSequenceDiscontinuity(PublishSequenceNumber previous, PublishSequenceNumber current) {
        return previous.value() + 1L != current.value();
    }

    SerialBatcher(long byteLimit, long messageLimit) {
        this.byteLimit = byteLimit;
        this.messageLimit = messageLimit;
    }

    ApiFuture<Offset> add(PubSubMessage message, PublishSequenceNumber sequenceNumber) throws CheckedApiException {
        if (!this.messages.isEmpty() && SerialBatcher.hasSequenceDiscontinuity(this.messages.peekLast().sequenceNumber(), sequenceNumber)) {
            throw new CheckedApiException(String.format("Discontinuity in publish sequence numbers; previous: %s, next: %s", this.messages.peekLast().sequenceNumber(), sequenceNumber), StatusCode.Code.FAILED_PRECONDITION);
        }
        SettableApiFuture future = SettableApiFuture.create();
        this.messages.add(UnbatchedMessage.of(message, sequenceNumber, (SettableApiFuture<Offset>)future));
        return future;
    }

    List<List<UnbatchedMessage>> flush() {
        ArrayList<List<UnbatchedMessage>> toReturn = new ArrayList<List<UnbatchedMessage>>();
        ArrayList<UnbatchedMessage> currentBatch = new ArrayList<UnbatchedMessage>();
        toReturn.add(currentBatch);
        long currentBatchBytes = 0L;
        for (UnbatchedMessage message : this.messages) {
            long newBatchBytes = currentBatchBytes + (long)message.message().getSerializedSize();
            if ((long)(currentBatch.size() + 1) > this.messageLimit || newBatchBytes > this.byteLimit) {
                currentBatch = new ArrayList();
                toReturn.add(currentBatch);
                newBatchBytes = message.message().getSerializedSize();
            }
            currentBatchBytes = newBatchBytes;
            currentBatch.add(message);
        }
        this.messages = new ArrayDeque<UnbatchedMessage>();
        return toReturn;
    }

    @AutoValue
    public static abstract class UnbatchedMessage {
        public abstract PubSubMessage message();

        public abstract PublishSequenceNumber sequenceNumber();

        public abstract SettableApiFuture<Offset> future();

        public static UnbatchedMessage of(PubSubMessage message, PublishSequenceNumber sequenceNumber, SettableApiFuture<Offset> future) {
            return new AutoValue_SerialBatcher_UnbatchedMessage(message, sequenceNumber, future);
        }
    }
}

