/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PartitionPublisherFactory;
import java.time.Duration;

final class AutoValue_PartitionCountWatchingPublisherSettings
extends PartitionCountWatchingPublisherSettings {
    private final TopicPath topic;
    private final PartitionPublisherFactory publisherFactory;
    private final AdminClient adminClient;
    private final Duration configPollPeriod;
    private final RoutingPolicy.Factory routingPolicyFactory;

    private AutoValue_PartitionCountWatchingPublisherSettings(TopicPath topic, PartitionPublisherFactory publisherFactory, AdminClient adminClient, Duration configPollPeriod, RoutingPolicy.Factory routingPolicyFactory) {
        this.topic = topic;
        this.publisherFactory = publisherFactory;
        this.adminClient = adminClient;
        this.configPollPeriod = configPollPeriod;
        this.routingPolicyFactory = routingPolicyFactory;
    }

    @Override
    TopicPath topic() {
        return this.topic;
    }

    @Override
    PartitionPublisherFactory publisherFactory() {
        return this.publisherFactory;
    }

    @Override
    AdminClient adminClient() {
        return this.adminClient;
    }

    @Override
    Duration configPollPeriod() {
        return this.configPollPeriod;
    }

    @Override
    RoutingPolicy.Factory routingPolicyFactory() {
        return this.routingPolicyFactory;
    }

    public String toString() {
        return "PartitionCountWatchingPublisherSettings{topic=" + this.topic + ", publisherFactory=" + this.publisherFactory + ", adminClient=" + this.adminClient + ", configPollPeriod=" + this.configPollPeriod + ", routingPolicyFactory=" + this.routingPolicyFactory + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PartitionCountWatchingPublisherSettings) {
            PartitionCountWatchingPublisherSettings that = (PartitionCountWatchingPublisherSettings)o;
            return this.topic.equals(that.topic()) && this.publisherFactory.equals(that.publisherFactory()) && this.adminClient.equals(that.adminClient()) && this.configPollPeriod.equals(that.configPollPeriod()) && this.routingPolicyFactory.equals(that.routingPolicyFactory());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.publisherFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.adminClient.hashCode();
        h$ *= 1000003;
        h$ ^= this.configPollPeriod.hashCode();
        h$ *= 1000003;
        return h$ ^= this.routingPolicyFactory.hashCode();
    }

    static final class Builder
    extends PartitionCountWatchingPublisherSettings.Builder {
        private TopicPath topic;
        private PartitionPublisherFactory publisherFactory;
        private AdminClient adminClient;
        private Duration configPollPeriod;
        private RoutingPolicy.Factory routingPolicyFactory;

        Builder() {
        }

        @Override
        public PartitionCountWatchingPublisherSettings.Builder setTopic(TopicPath topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public PartitionCountWatchingPublisherSettings.Builder setPublisherFactory(PartitionPublisherFactory publisherFactory) {
            if (publisherFactory == null) {
                throw new NullPointerException("Null publisherFactory");
            }
            this.publisherFactory = publisherFactory;
            return this;
        }

        @Override
        public PartitionCountWatchingPublisherSettings.Builder setAdminClient(AdminClient adminClient) {
            if (adminClient == null) {
                throw new NullPointerException("Null adminClient");
            }
            this.adminClient = adminClient;
            return this;
        }

        @Override
        public PartitionCountWatchingPublisherSettings.Builder setConfigPollPeriod(Duration configPollPeriod) {
            if (configPollPeriod == null) {
                throw new NullPointerException("Null configPollPeriod");
            }
            this.configPollPeriod = configPollPeriod;
            return this;
        }

        @Override
        public PartitionCountWatchingPublisherSettings.Builder setRoutingPolicyFactory(RoutingPolicy.Factory routingPolicyFactory) {
            if (routingPolicyFactory == null) {
                throw new NullPointerException("Null routingPolicyFactory");
            }
            this.routingPolicyFactory = routingPolicyFactory;
            return this;
        }

        @Override
        public PartitionCountWatchingPublisherSettings build() {
            if (this.topic == null || this.publisherFactory == null || this.adminClient == null || this.configPollPeriod == null || this.routingPolicyFactory == null) {
                StringBuilder missing = new StringBuilder();
                if (this.topic == null) {
                    missing.append(" topic");
                }
                if (this.publisherFactory == null) {
                    missing.append(" publisherFactory");
                }
                if (this.adminClient == null) {
                    missing.append(" adminClient");
                }
                if (this.configPollPeriod == null) {
                    missing.append(" configPollPeriod");
                }
                if (this.routingPolicyFactory == null) {
                    missing.append(" routingPolicyFactory");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PartitionCountWatchingPublisherSettings(this.topic, this.publisherFactory, this.adminClient, this.configPollPeriod, this.routingPolicyFactory);
        }
    }
}

