/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_Message;
import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.common.collect.ImmutableListMultimap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.util.Optional;

@AutoValue
public abstract class Message {
    public abstract ByteString key();

    public abstract ByteString data();

    public abstract ImmutableListMultimap<String, ByteString> attributes();

    public abstract Optional<Timestamp> eventTime();

    public static Builder builder() {
        return new AutoValue_Message.Builder().setKey(ByteString.EMPTY).setData(ByteString.EMPTY).setAttributes((ImmutableListMultimap<String, ByteString>)ImmutableListMultimap.of());
    }

    public abstract Builder toBuilder();

    public PubSubMessage toProto() {
        PubSubMessage.Builder builder = PubSubMessage.newBuilder();
        builder.setKey(this.key());
        builder.setData(this.data());
        this.eventTime().ifPresent(t -> builder.setEventTime(t));
        this.attributes().asMap().forEach((key, values) -> {
            AttributeValues values_proto = AttributeValues.newBuilder().addAllValues((Iterable)values).build();
            builder.putAttributes(key, values_proto);
        });
        return builder.build();
    }

    public static Message fromProto(PubSubMessage proto) {
        Builder builder = Message.builder().setKey(proto.getKey()).setData(proto.getData());
        if (proto.hasEventTime()) {
            builder = builder.setEventTime(proto.getEventTime());
        }
        ImmutableListMultimap.Builder mapBuilder = ImmutableListMultimap.builder();
        proto.getAttributesMap().forEach((key, attributeValues) -> attributeValues.getValuesList().forEach(value -> mapBuilder.put(key, value)));
        builder = builder.setAttributes((ImmutableListMultimap<String, ByteString>)mapBuilder.build());
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setKey(ByteString var1);

        public abstract Builder setData(ByteString var1);

        public abstract Builder setAttributes(ImmutableListMultimap<String, ByteString> var1);

        public abstract Builder setEventTime(Timestamp var1);

        public abstract Message build();
    }
}

