package com.google.cloud.pubsublite;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LocationPath extends LocationPath {

  private final ProjectIdOrNumber project;

  private final CloudRegionOrZone location;

  private AutoValue_LocationPath(
      ProjectIdOrNumber project,
      CloudRegionOrZone location) {
    this.project = project;
    this.location = location;
  }

  @Override
  public ProjectIdOrNumber project() {
    return project;
  }

  @Override
  public CloudRegionOrZone location() {
    return location;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LocationPath) {
      LocationPath that = (LocationPath) o;
      return this.project.equals(that.project())
          && this.location.equals(that.location());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= location.hashCode();
    return h$;
  }

  @Override
  public LocationPath.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends LocationPath.Builder {
    private ProjectIdOrNumber project;
    private CloudRegionOrZone location;
    Builder() {
    }
    private Builder(LocationPath source) {
      this.project = source.project();
      this.location = source.location();
    }
    @Override
    public LocationPath.Builder setProject(ProjectIdOrNumber project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    public LocationPath.Builder setLocation(CloudRegionOrZone location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public LocationPath build() {
      if (this.project == null
          || this.location == null) {
        StringBuilder missing = new StringBuilder();
        if (this.project == null) {
          missing.append(" project");
        }
        if (this.location == null) {
          missing.append(" location");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LocationPath(
          this.project,
          this.location);
    }
  }

}
