/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.cloud.pubsublite.Message;
import com.google.common.collect.ImmutableListMultimap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.util.Optional;

final class AutoValue_Message
extends Message {
    private final ByteString key;
    private final ByteString data;
    private final ImmutableListMultimap<String, ByteString> attributes;
    private final Optional<Timestamp> eventTime;

    private AutoValue_Message(ByteString key, ByteString data, ImmutableListMultimap<String, ByteString> attributes, Optional<Timestamp> eventTime) {
        this.key = key;
        this.data = data;
        this.attributes = attributes;
        this.eventTime = eventTime;
    }

    @Override
    public ByteString key() {
        return this.key;
    }

    @Override
    public ByteString data() {
        return this.data;
    }

    @Override
    public ImmutableListMultimap<String, ByteString> attributes() {
        return this.attributes;
    }

    @Override
    public Optional<Timestamp> eventTime() {
        return this.eventTime;
    }

    public String toString() {
        return "Message{key=" + this.key + ", data=" + this.data + ", attributes=" + this.attributes + ", eventTime=" + this.eventTime + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Message) {
            Message that = (Message)o;
            return this.key.equals((Object)that.key()) && this.data.equals((Object)that.data()) && this.attributes.equals(that.attributes()) && this.eventTime.equals(that.eventTime());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.key.hashCode();
        h$ *= 1000003;
        h$ ^= this.data.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.eventTime.hashCode();
    }

    @Override
    public Message.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Message.Builder {
        private ByteString key;
        private ByteString data;
        private ImmutableListMultimap<String, ByteString> attributes;
        private Optional<Timestamp> eventTime = Optional.empty();

        Builder() {
        }

        private Builder(Message source) {
            this.key = source.key();
            this.data = source.data();
            this.attributes = source.attributes();
            this.eventTime = source.eventTime();
        }

        @Override
        public Message.Builder setKey(ByteString key) {
            if (key == null) {
                throw new NullPointerException("Null key");
            }
            this.key = key;
            return this;
        }

        @Override
        public Message.Builder setData(ByteString data) {
            if (data == null) {
                throw new NullPointerException("Null data");
            }
            this.data = data;
            return this;
        }

        @Override
        public Message.Builder setAttributes(ImmutableListMultimap<String, ByteString> attributes) {
            if (attributes == null) {
                throw new NullPointerException("Null attributes");
            }
            this.attributes = attributes;
            return this;
        }

        @Override
        public Message.Builder setEventTime(Timestamp eventTime) {
            this.eventTime = Optional.of(eventTime);
            return this;
        }

        @Override
        public Message build() {
            if (this.key == null || this.data == null || this.attributes == null) {
                StringBuilder missing = new StringBuilder();
                if (this.key == null) {
                    missing.append(" key");
                }
                if (this.data == null) {
                    missing.append(" data");
                }
                if (this.attributes == null) {
                    missing.append(" attributes");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Message(this.key, this.data, this.attributes, this.eventTime);
        }
    }
}

