/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.ServiceMonitoringServiceClient;
import com.google.cloud.monitoring.v3.stub.GrpcServiceMonitoringServiceStub;
import com.google.cloud.monitoring.v3.stub.ServiceMonitoringServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateServiceLevelObjectiveRequest;
import com.google.monitoring.v3.CreateServiceRequest;
import com.google.monitoring.v3.DeleteServiceLevelObjectiveRequest;
import com.google.monitoring.v3.DeleteServiceRequest;
import com.google.monitoring.v3.GetServiceLevelObjectiveRequest;
import com.google.monitoring.v3.GetServiceRequest;
import com.google.monitoring.v3.ListServiceLevelObjectivesRequest;
import com.google.monitoring.v3.ListServiceLevelObjectivesResponse;
import com.google.monitoring.v3.ListServicesRequest;
import com.google.monitoring.v3.ListServicesResponse;
import com.google.monitoring.v3.Service;
import com.google.monitoring.v3.ServiceLevelObjective;
import com.google.monitoring.v3.UpdateServiceLevelObjectiveRequest;
import com.google.monitoring.v3.UpdateServiceRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ServiceMonitoringServiceStubSettings
extends StubSettings<ServiceMonitoringServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/monitoring").add((Object)"https://www.googleapis.com/auth/monitoring.read").build();
    private final UnaryCallSettings<CreateServiceRequest, Service> createServiceSettings;
    private final UnaryCallSettings<GetServiceRequest, Service> getServiceSettings;
    private final PagedCallSettings<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse> listServicesSettings;
    private final UnaryCallSettings<UpdateServiceRequest, Service> updateServiceSettings;
    private final UnaryCallSettings<DeleteServiceRequest, Empty> deleteServiceSettings;
    private final UnaryCallSettings<CreateServiceLevelObjectiveRequest, ServiceLevelObjective> createServiceLevelObjectiveSettings;
    private final UnaryCallSettings<GetServiceLevelObjectiveRequest, ServiceLevelObjective> getServiceLevelObjectiveSettings;
    private final PagedCallSettings<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> listServiceLevelObjectivesSettings;
    private final UnaryCallSettings<UpdateServiceLevelObjectiveRequest, ServiceLevelObjective> updateServiceLevelObjectiveSettings;
    private final UnaryCallSettings<DeleteServiceLevelObjectiveRequest, Empty> deleteServiceLevelObjectiveSettings;
    private static final PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service> LIST_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service>(){

        public String emptyToken() {
            return "";
        }

        public ListServicesRequest injectToken(ListServicesRequest payload, String token) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageToken(token).build();
        }

        public ListServicesRequest injectPageSize(ListServicesRequest payload, int pageSize) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Service> extractResources(ListServicesResponse payload) {
            return payload.getServicesList() == null ? ImmutableList.of() : payload.getServicesList();
        }
    };
    private static final PagedListDescriptor<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective> LIST_SERVICE_LEVEL_OBJECTIVES_PAGE_STR_DESC = new PagedListDescriptor<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective>(){

        public String emptyToken() {
            return "";
        }

        public ListServiceLevelObjectivesRequest injectToken(ListServiceLevelObjectivesRequest payload, String token) {
            return ListServiceLevelObjectivesRequest.newBuilder((ListServiceLevelObjectivesRequest)payload).setPageToken(token).build();
        }

        public ListServiceLevelObjectivesRequest injectPageSize(ListServiceLevelObjectivesRequest payload, int pageSize) {
            return ListServiceLevelObjectivesRequest.newBuilder((ListServiceLevelObjectivesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServiceLevelObjectivesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServiceLevelObjectivesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ServiceLevelObjective> extractResources(ListServiceLevelObjectivesResponse payload) {
            return payload.getServiceLevelObjectivesList() == null ? ImmutableList.of() : payload.getServiceLevelObjectivesList();
        }
    };
    private static final PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse> LIST_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse>(){

        public ApiFuture<ServiceMonitoringServiceClient.ListServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicesRequest, ListServicesResponse> callable, ListServicesRequest request, ApiCallContext context, ApiFuture<ListServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceMonitoringServiceClient.ListServicesPagedResponse.createAsync((PageContext<ListServicesRequest, ListServicesResponse, Service>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> LIST_SERVICE_LEVEL_OBJECTIVES_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse>(){

        public ApiFuture<ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse> callable, ListServiceLevelObjectivesRequest request, ApiCallContext context, ApiFuture<ListServiceLevelObjectivesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_LEVEL_OBJECTIVES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse.createAsync((PageContext<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceLevelObjective>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateServiceRequest, Service> createServiceSettings() {
        return this.createServiceSettings;
    }

    public UnaryCallSettings<GetServiceRequest, Service> getServiceSettings() {
        return this.getServiceSettings;
    }

    public PagedCallSettings<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse> listServicesSettings() {
        return this.listServicesSettings;
    }

    public UnaryCallSettings<UpdateServiceRequest, Service> updateServiceSettings() {
        return this.updateServiceSettings;
    }

    public UnaryCallSettings<DeleteServiceRequest, Empty> deleteServiceSettings() {
        return this.deleteServiceSettings;
    }

    public UnaryCallSettings<CreateServiceLevelObjectiveRequest, ServiceLevelObjective> createServiceLevelObjectiveSettings() {
        return this.createServiceLevelObjectiveSettings;
    }

    public UnaryCallSettings<GetServiceLevelObjectiveRequest, ServiceLevelObjective> getServiceLevelObjectiveSettings() {
        return this.getServiceLevelObjectiveSettings;
    }

    public PagedCallSettings<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> listServiceLevelObjectivesSettings() {
        return this.listServiceLevelObjectivesSettings;
    }

    public UnaryCallSettings<UpdateServiceLevelObjectiveRequest, ServiceLevelObjective> updateServiceLevelObjectiveSettings() {
        return this.updateServiceLevelObjectiveSettings;
    }

    public UnaryCallSettings<DeleteServiceLevelObjectiveRequest, Empty> deleteServiceLevelObjectiveSettings() {
        return this.deleteServiceLevelObjectiveSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ServiceMonitoringServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcServiceMonitoringServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "monitoring.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ServiceMonitoringServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServiceMonitoringServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ServiceMonitoringServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createServiceSettings = settingsBuilder.createServiceSettings().build();
        this.getServiceSettings = settingsBuilder.getServiceSettings().build();
        this.listServicesSettings = settingsBuilder.listServicesSettings().build();
        this.updateServiceSettings = settingsBuilder.updateServiceSettings().build();
        this.deleteServiceSettings = settingsBuilder.deleteServiceSettings().build();
        this.createServiceLevelObjectiveSettings = settingsBuilder.createServiceLevelObjectiveSettings().build();
        this.getServiceLevelObjectiveSettings = settingsBuilder.getServiceLevelObjectiveSettings().build();
        this.listServiceLevelObjectivesSettings = settingsBuilder.listServiceLevelObjectivesSettings().build();
        this.updateServiceLevelObjectiveSettings = settingsBuilder.updateServiceLevelObjectiveSettings().build();
        this.deleteServiceLevelObjectiveSettings = settingsBuilder.deleteServiceLevelObjectiveSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ServiceMonitoringServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateServiceRequest, Service> createServiceSettings;
        private final UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings;
        private final PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse> listServicesSettings;
        private final UnaryCallSettings.Builder<UpdateServiceRequest, Service> updateServiceSettings;
        private final UnaryCallSettings.Builder<DeleteServiceRequest, Empty> deleteServiceSettings;
        private final UnaryCallSettings.Builder<CreateServiceLevelObjectiveRequest, ServiceLevelObjective> createServiceLevelObjectiveSettings;
        private final UnaryCallSettings.Builder<GetServiceLevelObjectiveRequest, ServiceLevelObjective> getServiceLevelObjectiveSettings;
        private final PagedCallSettings.Builder<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> listServiceLevelObjectivesSettings;
        private final UnaryCallSettings.Builder<UpdateServiceLevelObjectiveRequest, ServiceLevelObjective> updateServiceLevelObjectiveSettings;
        private final UnaryCallSettings.Builder<DeleteServiceLevelObjectiveRequest, Empty> deleteServiceLevelObjectiveSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICES_PAGE_STR_FACT);
            this.updateServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceLevelObjectiveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getServiceLevelObjectiveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServiceLevelObjectivesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_LEVEL_OBJECTIVES_PAGE_STR_FACT);
            this.updateServiceLevelObjectiveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceLevelObjectiveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createServiceSettings, this.getServiceSettings, this.listServicesSettings, this.updateServiceSettings, this.deleteServiceSettings, this.createServiceLevelObjectiveSettings, this.getServiceLevelObjectiveSettings, this.listServiceLevelObjectivesSettings, this.updateServiceLevelObjectiveSettings, this.deleteServiceLevelObjectiveSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ServiceMonitoringServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createServiceSettings = settings.createServiceSettings.toBuilder();
            this.getServiceSettings = settings.getServiceSettings.toBuilder();
            this.listServicesSettings = settings.listServicesSettings.toBuilder();
            this.updateServiceSettings = settings.updateServiceSettings.toBuilder();
            this.deleteServiceSettings = settings.deleteServiceSettings.toBuilder();
            this.createServiceLevelObjectiveSettings = settings.createServiceLevelObjectiveSettings.toBuilder();
            this.getServiceLevelObjectiveSettings = settings.getServiceLevelObjectiveSettings.toBuilder();
            this.listServiceLevelObjectivesSettings = settings.listServiceLevelObjectivesSettings.toBuilder();
            this.updateServiceLevelObjectiveSettings = settings.updateServiceLevelObjectiveSettings.toBuilder();
            this.deleteServiceLevelObjectiveSettings = settings.deleteServiceLevelObjectiveSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createServiceSettings, this.getServiceSettings, this.listServicesSettings, this.updateServiceSettings, this.deleteServiceSettings, this.createServiceLevelObjectiveSettings, this.getServiceLevelObjectiveSettings, this.listServiceLevelObjectivesSettings, this.updateServiceLevelObjectiveSettings, this.deleteServiceLevelObjectiveSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ServiceMonitoringServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ServiceMonitoringServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServiceMonitoringServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ServiceMonitoringServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ServiceMonitoringServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.getServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.listServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.updateServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.deleteServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.createServiceLevelObjectiveSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.getServiceLevelObjectiveSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.listServiceLevelObjectivesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            builder.updateServiceLevelObjectiveSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_6_params"));
            builder.deleteServiceLevelObjectiveSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_7_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateServiceRequest, Service> createServiceSettings() {
            return this.createServiceSettings;
        }

        public UnaryCallSettings.Builder<GetServiceRequest, Service> getServiceSettings() {
            return this.getServiceSettings;
        }

        public PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServiceMonitoringServiceClient.ListServicesPagedResponse> listServicesSettings() {
            return this.listServicesSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceRequest, Service> updateServiceSettings() {
            return this.updateServiceSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceRequest, Empty> deleteServiceSettings() {
            return this.deleteServiceSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceLevelObjectiveRequest, ServiceLevelObjective> createServiceLevelObjectiveSettings() {
            return this.createServiceLevelObjectiveSettings;
        }

        public UnaryCallSettings.Builder<GetServiceLevelObjectiveRequest, ServiceLevelObjective> getServiceLevelObjectiveSettings() {
            return this.getServiceLevelObjectiveSettings;
        }

        public PagedCallSettings.Builder<ListServiceLevelObjectivesRequest, ListServiceLevelObjectivesResponse, ServiceMonitoringServiceClient.ListServiceLevelObjectivesPagedResponse> listServiceLevelObjectivesSettings() {
            return this.listServiceLevelObjectivesSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceLevelObjectiveRequest, ServiceLevelObjective> updateServiceLevelObjectiveSettings() {
            return this.updateServiceLevelObjectiveSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceLevelObjectiveRequest, Empty> deleteServiceLevelObjectiveSettings() {
            return this.deleteServiceLevelObjectiveSettings;
        }

        public ServiceMonitoringServiceStubSettings build() throws IOException {
            return new ServiceMonitoringServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_6_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_7_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"no_retry_6_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)30000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_7_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

