/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.functions.v2.CreateFunctionRequest;
import com.google.cloud.functions.v2.DeleteFunctionRequest;
import com.google.cloud.functions.v2.Function;
import com.google.cloud.functions.v2.FunctionServiceClient;
import com.google.cloud.functions.v2.GenerateDownloadUrlRequest;
import com.google.cloud.functions.v2.GenerateDownloadUrlResponse;
import com.google.cloud.functions.v2.GenerateUploadUrlRequest;
import com.google.cloud.functions.v2.GenerateUploadUrlResponse;
import com.google.cloud.functions.v2.GetFunctionRequest;
import com.google.cloud.functions.v2.ListFunctionsRequest;
import com.google.cloud.functions.v2.ListFunctionsResponse;
import com.google.cloud.functions.v2.ListRuntimesRequest;
import com.google.cloud.functions.v2.ListRuntimesResponse;
import com.google.cloud.functions.v2.OperationMetadata;
import com.google.cloud.functions.v2.UpdateFunctionRequest;
import com.google.cloud.functions.v2.stub.FunctionServiceStub;
import com.google.cloud.functions.v2.stub.FunctionServiceStubSettings;
import com.google.cloud.functions.v2.stub.GrpcFunctionServiceCallableFactory;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcFunctionServiceStub
extends FunctionServiceStub {
    private static final MethodDescriptor<GetFunctionRequest, Function> getFunctionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2.FunctionService/GetFunction").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFunctionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Function.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListFunctionsRequest, ListFunctionsResponse> listFunctionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2.FunctionService/ListFunctions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFunctionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFunctionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateFunctionRequest, Operation> createFunctionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2.FunctionService/CreateFunction").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateFunctionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateFunctionRequest, Operation> updateFunctionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2.FunctionService/UpdateFunction").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateFunctionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteFunctionRequest, Operation> deleteFunctionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2.FunctionService/DeleteFunction").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteFunctionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2.FunctionService/GenerateUploadUrl").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateUploadUrlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateUploadUrlResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2.FunctionService/GenerateDownloadUrl").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateDownloadUrlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateDownloadUrlResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListRuntimesRequest, ListRuntimesResponse> listRuntimesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2.FunctionService/ListRuntimes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRuntimesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRuntimesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetFunctionRequest, Function> getFunctionCallable;
    private final UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> listFunctionsCallable;
    private final UnaryCallable<ListFunctionsRequest, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsPagedCallable;
    private final UnaryCallable<CreateFunctionRequest, Operation> createFunctionCallable;
    private final OperationCallable<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationCallable;
    private final UnaryCallable<UpdateFunctionRequest, Operation> updateFunctionCallable;
    private final OperationCallable<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationCallable;
    private final UnaryCallable<DeleteFunctionRequest, Operation> deleteFunctionCallable;
    private final OperationCallable<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationCallable;
    private final UnaryCallable<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlCallable;
    private final UnaryCallable<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlCallable;
    private final UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> listRuntimesCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, FunctionServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFunctionServiceStub create(FunctionServiceStubSettings settings) throws IOException {
        return new GrpcFunctionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFunctionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcFunctionServiceStub(FunctionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFunctionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFunctionServiceStub(FunctionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFunctionServiceStub(FunctionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFunctionServiceCallableFactory());
    }

    protected GrpcFunctionServiceStub(FunctionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getFunctionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFunctionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listFunctionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFunctionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createFunctionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createFunctionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateFunctionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateFunctionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("function.name", String.valueOf(request.getFunction().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteFunctionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteFunctionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings generateUploadUrlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateUploadUrlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings generateDownloadUrlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateDownloadUrlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listRuntimesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRuntimesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.getFunctionCallable = callableFactory.createUnaryCallable(getFunctionTransportSettings, settings.getFunctionSettings(), clientContext);
        this.listFunctionsCallable = callableFactory.createUnaryCallable(listFunctionsTransportSettings, settings.listFunctionsSettings(), clientContext);
        this.listFunctionsPagedCallable = callableFactory.createPagedCallable(listFunctionsTransportSettings, settings.listFunctionsSettings(), clientContext);
        this.createFunctionCallable = callableFactory.createUnaryCallable(createFunctionTransportSettings, settings.createFunctionSettings(), clientContext);
        this.createFunctionOperationCallable = callableFactory.createOperationCallable(createFunctionTransportSettings, settings.createFunctionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateFunctionCallable = callableFactory.createUnaryCallable(updateFunctionTransportSettings, settings.updateFunctionSettings(), clientContext);
        this.updateFunctionOperationCallable = callableFactory.createOperationCallable(updateFunctionTransportSettings, settings.updateFunctionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteFunctionCallable = callableFactory.createUnaryCallable(deleteFunctionTransportSettings, settings.deleteFunctionSettings(), clientContext);
        this.deleteFunctionOperationCallable = callableFactory.createOperationCallable(deleteFunctionTransportSettings, settings.deleteFunctionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.generateUploadUrlCallable = callableFactory.createUnaryCallable(generateUploadUrlTransportSettings, settings.generateUploadUrlSettings(), clientContext);
        this.generateDownloadUrlCallable = callableFactory.createUnaryCallable(generateDownloadUrlTransportSettings, settings.generateDownloadUrlSettings(), clientContext);
        this.listRuntimesCallable = callableFactory.createUnaryCallable(listRuntimesTransportSettings, settings.listRuntimesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetFunctionRequest, Function> getFunctionCallable() {
        return this.getFunctionCallable;
    }

    @Override
    public UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> listFunctionsCallable() {
        return this.listFunctionsCallable;
    }

    @Override
    public UnaryCallable<ListFunctionsRequest, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsPagedCallable() {
        return this.listFunctionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateFunctionRequest, Operation> createFunctionCallable() {
        return this.createFunctionCallable;
    }

    @Override
    public OperationCallable<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationCallable() {
        return this.createFunctionOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateFunctionRequest, Operation> updateFunctionCallable() {
        return this.updateFunctionCallable;
    }

    @Override
    public OperationCallable<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationCallable() {
        return this.updateFunctionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFunctionRequest, Operation> deleteFunctionCallable() {
        return this.deleteFunctionCallable;
    }

    @Override
    public OperationCallable<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationCallable() {
        return this.deleteFunctionOperationCallable;
    }

    @Override
    public UnaryCallable<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlCallable() {
        return this.generateUploadUrlCallable;
    }

    @Override
    public UnaryCallable<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlCallable() {
        return this.generateDownloadUrlCallable;
    }

    @Override
    public UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> listRuntimesCallable() {
        return this.listRuntimesCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, FunctionServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

