/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.Control;
import com.google.cloud.discoveryengine.v1beta.ControlName;
import com.google.cloud.discoveryengine.v1beta.ControlServiceSettings;
import com.google.cloud.discoveryengine.v1beta.CreateControlRequest;
import com.google.cloud.discoveryengine.v1beta.DataStoreName;
import com.google.cloud.discoveryengine.v1beta.DeleteControlRequest;
import com.google.cloud.discoveryengine.v1beta.EngineName;
import com.google.cloud.discoveryengine.v1beta.GetControlRequest;
import com.google.cloud.discoveryengine.v1beta.ListControlsRequest;
import com.google.cloud.discoveryengine.v1beta.ListControlsResponse;
import com.google.cloud.discoveryengine.v1beta.UpdateControlRequest;
import com.google.cloud.discoveryengine.v1beta.stub.ControlServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.ControlServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ControlServiceClient
implements BackgroundResource {
    private final ControlServiceSettings settings;
    private final ControlServiceStub stub;

    public static final ControlServiceClient create() throws IOException {
        return ControlServiceClient.create(ControlServiceSettings.newBuilder().build());
    }

    public static final ControlServiceClient create(ControlServiceSettings settings) throws IOException {
        return new ControlServiceClient(settings);
    }

    public static final ControlServiceClient create(ControlServiceStub stub) {
        return new ControlServiceClient(stub);
    }

    protected ControlServiceClient(ControlServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ControlServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ControlServiceClient(ControlServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ControlServiceSettings getSettings() {
        return this.settings;
    }

    public ControlServiceStub getStub() {
        return this.stub;
    }

    public final Control createControl(DataStoreName parent, Control control, String controlId) {
        CreateControlRequest request = CreateControlRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setControl(control).setControlId(controlId).build();
        return this.createControl(request);
    }

    public final Control createControl(EngineName parent, Control control, String controlId) {
        CreateControlRequest request = CreateControlRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setControl(control).setControlId(controlId).build();
        return this.createControl(request);
    }

    public final Control createControl(String parent, Control control, String controlId) {
        CreateControlRequest request = CreateControlRequest.newBuilder().setParent(parent).setControl(control).setControlId(controlId).build();
        return this.createControl(request);
    }

    public final Control createControl(CreateControlRequest request) {
        return (Control)this.createControlCallable().call((Object)request);
    }

    public final UnaryCallable<CreateControlRequest, Control> createControlCallable() {
        return this.stub.createControlCallable();
    }

    public final void deleteControl(ControlName name) {
        DeleteControlRequest request = DeleteControlRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteControl(request);
    }

    public final void deleteControl(String name) {
        DeleteControlRequest request = DeleteControlRequest.newBuilder().setName(name).build();
        this.deleteControl(request);
    }

    public final void deleteControl(DeleteControlRequest request) {
        this.deleteControlCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteControlRequest, Empty> deleteControlCallable() {
        return this.stub.deleteControlCallable();
    }

    public final Control updateControl(Control control, FieldMask updateMask) {
        UpdateControlRequest request = UpdateControlRequest.newBuilder().setControl(control).setUpdateMask(updateMask).build();
        return this.updateControl(request);
    }

    public final Control updateControl(UpdateControlRequest request) {
        return (Control)this.updateControlCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateControlRequest, Control> updateControlCallable() {
        return this.stub.updateControlCallable();
    }

    public final Control getControl(ControlName name) {
        GetControlRequest request = GetControlRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getControl(request);
    }

    public final Control getControl(String name) {
        GetControlRequest request = GetControlRequest.newBuilder().setName(name).build();
        return this.getControl(request);
    }

    public final Control getControl(GetControlRequest request) {
        return (Control)this.getControlCallable().call((Object)request);
    }

    public final UnaryCallable<GetControlRequest, Control> getControlCallable() {
        return this.stub.getControlCallable();
    }

    public final ListControlsPagedResponse listControls(DataStoreName parent) {
        ListControlsRequest request = ListControlsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listControls(request);
    }

    public final ListControlsPagedResponse listControls(EngineName parent) {
        ListControlsRequest request = ListControlsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listControls(request);
    }

    public final ListControlsPagedResponse listControls(String parent) {
        ListControlsRequest request = ListControlsRequest.newBuilder().setParent(parent).build();
        return this.listControls(request);
    }

    public final ListControlsPagedResponse listControls(ListControlsRequest request) {
        return (ListControlsPagedResponse)((Object)this.listControlsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListControlsRequest, ListControlsPagedResponse> listControlsPagedCallable() {
        return this.stub.listControlsPagedCallable();
    }

    public final UnaryCallable<ListControlsRequest, ListControlsResponse> listControlsCallable() {
        return this.stub.listControlsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListControlsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListControlsRequest, ListControlsResponse, Control, ListControlsPage, ListControlsFixedSizeCollection> {
        private ListControlsFixedSizeCollection(List<ListControlsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListControlsFixedSizeCollection createEmptyCollection() {
            return new ListControlsFixedSizeCollection(null, 0);
        }

        protected ListControlsFixedSizeCollection createCollection(List<ListControlsPage> pages, int collectionSize) {
            return new ListControlsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListControlsPage
    extends AbstractPage<ListControlsRequest, ListControlsResponse, Control, ListControlsPage> {
        private ListControlsPage(PageContext<ListControlsRequest, ListControlsResponse, Control> context, ListControlsResponse response) {
            super(context, (Object)response);
        }

        private static ListControlsPage createEmptyPage() {
            return new ListControlsPage(null, null);
        }

        protected ListControlsPage createPage(PageContext<ListControlsRequest, ListControlsResponse, Control> context, ListControlsResponse response) {
            return new ListControlsPage(context, response);
        }

        public ApiFuture<ListControlsPage> createPageAsync(PageContext<ListControlsRequest, ListControlsResponse, Control> context, ApiFuture<ListControlsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListControlsPagedResponse
    extends AbstractPagedListResponse<ListControlsRequest, ListControlsResponse, Control, ListControlsPage, ListControlsFixedSizeCollection> {
        public static ApiFuture<ListControlsPagedResponse> createAsync(PageContext<ListControlsRequest, ListControlsResponse, Control> context, ApiFuture<ListControlsResponse> futureResponse) {
            ApiFuture<ListControlsPage> futurePage = ListControlsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListControlsPagedResponse((ListControlsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListControlsPagedResponse(ListControlsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListControlsFixedSizeCollection.createEmptyCollection());
        }
    }
}

