/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeMetadata;
import com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest;
import com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.EstimateBillingServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.EstimateBillingServiceStubSettings;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcEstimateBillingServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcEstimateBillingServiceStub
extends EstimateBillingServiceStub {
    private static final MethodDescriptor<EstimateDataSizeRequest, Operation> estimateDataSizeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.EstimateBillingService/EstimateDataSize").setRequestMarshaller(ProtoUtils.marshaller((Message)EstimateDataSizeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<EstimateDataSizeRequest, Operation> estimateDataSizeCallable;
    private final OperationCallable<EstimateDataSizeRequest, EstimateDataSizeResponse, EstimateDataSizeMetadata> estimateDataSizeOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcEstimateBillingServiceStub create(EstimateBillingServiceStubSettings settings) throws IOException {
        return new GrpcEstimateBillingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcEstimateBillingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcEstimateBillingServiceStub(EstimateBillingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcEstimateBillingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcEstimateBillingServiceStub(EstimateBillingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcEstimateBillingServiceStub(EstimateBillingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcEstimateBillingServiceCallableFactory());
    }

    protected GrpcEstimateBillingServiceStub(EstimateBillingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings estimateDataSizeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(estimateDataSizeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("location", String.valueOf(request.getLocation()));
            return builder.build();
        }).build();
        this.estimateDataSizeCallable = callableFactory.createUnaryCallable(estimateDataSizeTransportSettings, settings.estimateDataSizeSettings(), clientContext);
        this.estimateDataSizeOperationCallable = callableFactory.createOperationCallable(estimateDataSizeTransportSettings, settings.estimateDataSizeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<EstimateDataSizeRequest, Operation> estimateDataSizeCallable() {
        return this.estimateDataSizeCallable;
    }

    @Override
    public OperationCallable<EstimateDataSizeRequest, EstimateDataSizeResponse, EstimateDataSizeMetadata> estimateDataSizeOperationCallable() {
        return this.estimateDataSizeOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

