/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest;
import com.google.cloud.discoveryengine.v1.DeleteIdentityMappingStoreMetadata;
import com.google.cloud.discoveryengine.v1.DeleteIdentityMappingStoreRequest;
import com.google.cloud.discoveryengine.v1.GetIdentityMappingStoreRequest;
import com.google.cloud.discoveryengine.v1.IdentityMappingEntry;
import com.google.cloud.discoveryengine.v1.IdentityMappingEntryOperationMetadata;
import com.google.cloud.discoveryengine.v1.IdentityMappingStore;
import com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceClient;
import com.google.cloud.discoveryengine.v1.ImportIdentityMappingsRequest;
import com.google.cloud.discoveryengine.v1.ImportIdentityMappingsResponse;
import com.google.cloud.discoveryengine.v1.ListIdentityMappingStoresRequest;
import com.google.cloud.discoveryengine.v1.ListIdentityMappingStoresResponse;
import com.google.cloud.discoveryengine.v1.ListIdentityMappingsRequest;
import com.google.cloud.discoveryengine.v1.ListIdentityMappingsResponse;
import com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest;
import com.google.cloud.discoveryengine.v1.stub.GrpcIdentityMappingStoreServiceStub;
import com.google.cloud.discoveryengine.v1.stub.HttpJsonIdentityMappingStoreServiceStub;
import com.google.cloud.discoveryengine.v1.stub.IdentityMappingStoreServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class IdentityMappingStoreServiceStubSettings
extends StubSettings<IdentityMappingStoreServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateIdentityMappingStoreRequest, IdentityMappingStore> createIdentityMappingStoreSettings;
    private final UnaryCallSettings<GetIdentityMappingStoreRequest, IdentityMappingStore> getIdentityMappingStoreSettings;
    private final UnaryCallSettings<DeleteIdentityMappingStoreRequest, Operation> deleteIdentityMappingStoreSettings;
    private final OperationCallSettings<DeleteIdentityMappingStoreRequest, Empty, DeleteIdentityMappingStoreMetadata> deleteIdentityMappingStoreOperationSettings;
    private final UnaryCallSettings<ImportIdentityMappingsRequest, Operation> importIdentityMappingsSettings;
    private final OperationCallSettings<ImportIdentityMappingsRequest, ImportIdentityMappingsResponse, IdentityMappingEntryOperationMetadata> importIdentityMappingsOperationSettings;
    private final UnaryCallSettings<PurgeIdentityMappingsRequest, Operation> purgeIdentityMappingsSettings;
    private final OperationCallSettings<PurgeIdentityMappingsRequest, Empty, IdentityMappingEntryOperationMetadata> purgeIdentityMappingsOperationSettings;
    private final PagedCallSettings<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingStoreServiceClient.ListIdentityMappingsPagedResponse> listIdentityMappingsSettings;
    private final PagedCallSettings<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStoreServiceClient.ListIdentityMappingStoresPagedResponse> listIdentityMappingStoresSettings;
    private static final PagedListDescriptor<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingEntry> LIST_IDENTITY_MAPPINGS_PAGE_STR_DESC = new PagedListDescriptor<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingEntry>(){

        public String emptyToken() {
            return "";
        }

        public ListIdentityMappingsRequest injectToken(ListIdentityMappingsRequest payload, String token) {
            return ListIdentityMappingsRequest.newBuilder((ListIdentityMappingsRequest)payload).setPageToken(token).build();
        }

        public ListIdentityMappingsRequest injectPageSize(ListIdentityMappingsRequest payload, int pageSize) {
            return ListIdentityMappingsRequest.newBuilder((ListIdentityMappingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIdentityMappingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIdentityMappingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<IdentityMappingEntry> extractResources(ListIdentityMappingsResponse payload) {
            return payload.getIdentityMappingEntriesList();
        }
    };
    private static final PagedListDescriptor<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStore> LIST_IDENTITY_MAPPING_STORES_PAGE_STR_DESC = new PagedListDescriptor<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStore>(){

        public String emptyToken() {
            return "";
        }

        public ListIdentityMappingStoresRequest injectToken(ListIdentityMappingStoresRequest payload, String token) {
            return ListIdentityMappingStoresRequest.newBuilder((ListIdentityMappingStoresRequest)payload).setPageToken(token).build();
        }

        public ListIdentityMappingStoresRequest injectPageSize(ListIdentityMappingStoresRequest payload, int pageSize) {
            return ListIdentityMappingStoresRequest.newBuilder((ListIdentityMappingStoresRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIdentityMappingStoresRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIdentityMappingStoresResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<IdentityMappingStore> extractResources(ListIdentityMappingStoresResponse payload) {
            return payload.getIdentityMappingStoresList();
        }
    };
    private static final PagedListResponseFactory<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingStoreServiceClient.ListIdentityMappingsPagedResponse> LIST_IDENTITY_MAPPINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingStoreServiceClient.ListIdentityMappingsPagedResponse>(){

        public ApiFuture<IdentityMappingStoreServiceClient.ListIdentityMappingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListIdentityMappingsRequest, ListIdentityMappingsResponse> callable, ListIdentityMappingsRequest request, ApiCallContext context, ApiFuture<ListIdentityMappingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_IDENTITY_MAPPINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IdentityMappingStoreServiceClient.ListIdentityMappingsPagedResponse.createAsync((PageContext<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingEntry>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStoreServiceClient.ListIdentityMappingStoresPagedResponse> LIST_IDENTITY_MAPPING_STORES_PAGE_STR_FACT = new PagedListResponseFactory<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStoreServiceClient.ListIdentityMappingStoresPagedResponse>(){

        public ApiFuture<IdentityMappingStoreServiceClient.ListIdentityMappingStoresPagedResponse> getFuturePagedResponse(UnaryCallable<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse> callable, ListIdentityMappingStoresRequest request, ApiCallContext context, ApiFuture<ListIdentityMappingStoresResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_IDENTITY_MAPPING_STORES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IdentityMappingStoreServiceClient.ListIdentityMappingStoresPagedResponse.createAsync((PageContext<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStore>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateIdentityMappingStoreRequest, IdentityMappingStore> createIdentityMappingStoreSettings() {
        return this.createIdentityMappingStoreSettings;
    }

    public UnaryCallSettings<GetIdentityMappingStoreRequest, IdentityMappingStore> getIdentityMappingStoreSettings() {
        return this.getIdentityMappingStoreSettings;
    }

    public UnaryCallSettings<DeleteIdentityMappingStoreRequest, Operation> deleteIdentityMappingStoreSettings() {
        return this.deleteIdentityMappingStoreSettings;
    }

    public OperationCallSettings<DeleteIdentityMappingStoreRequest, Empty, DeleteIdentityMappingStoreMetadata> deleteIdentityMappingStoreOperationSettings() {
        return this.deleteIdentityMappingStoreOperationSettings;
    }

    public UnaryCallSettings<ImportIdentityMappingsRequest, Operation> importIdentityMappingsSettings() {
        return this.importIdentityMappingsSettings;
    }

    public OperationCallSettings<ImportIdentityMappingsRequest, ImportIdentityMappingsResponse, IdentityMappingEntryOperationMetadata> importIdentityMappingsOperationSettings() {
        return this.importIdentityMappingsOperationSettings;
    }

    public UnaryCallSettings<PurgeIdentityMappingsRequest, Operation> purgeIdentityMappingsSettings() {
        return this.purgeIdentityMappingsSettings;
    }

    public OperationCallSettings<PurgeIdentityMappingsRequest, Empty, IdentityMappingEntryOperationMetadata> purgeIdentityMappingsOperationSettings() {
        return this.purgeIdentityMappingsOperationSettings;
    }

    public PagedCallSettings<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingStoreServiceClient.ListIdentityMappingsPagedResponse> listIdentityMappingsSettings() {
        return this.listIdentityMappingsSettings;
    }

    public PagedCallSettings<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStoreServiceClient.ListIdentityMappingStoresPagedResponse> listIdentityMappingStoresSettings() {
        return this.listIdentityMappingStoresSettings;
    }

    public IdentityMappingStoreServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIdentityMappingStoreServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonIdentityMappingStoreServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IdentityMappingStoreServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IdentityMappingStoreServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IdentityMappingStoreServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return IdentityMappingStoreServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IdentityMappingStoreServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createIdentityMappingStoreSettings = settingsBuilder.createIdentityMappingStoreSettings().build();
        this.getIdentityMappingStoreSettings = settingsBuilder.getIdentityMappingStoreSettings().build();
        this.deleteIdentityMappingStoreSettings = settingsBuilder.deleteIdentityMappingStoreSettings().build();
        this.deleteIdentityMappingStoreOperationSettings = settingsBuilder.deleteIdentityMappingStoreOperationSettings().build();
        this.importIdentityMappingsSettings = settingsBuilder.importIdentityMappingsSettings().build();
        this.importIdentityMappingsOperationSettings = settingsBuilder.importIdentityMappingsOperationSettings().build();
        this.purgeIdentityMappingsSettings = settingsBuilder.purgeIdentityMappingsSettings().build();
        this.purgeIdentityMappingsOperationSettings = settingsBuilder.purgeIdentityMappingsOperationSettings().build();
        this.listIdentityMappingsSettings = settingsBuilder.listIdentityMappingsSettings().build();
        this.listIdentityMappingStoresSettings = settingsBuilder.listIdentityMappingStoresSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IdentityMappingStoreServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateIdentityMappingStoreRequest, IdentityMappingStore> createIdentityMappingStoreSettings;
        private final UnaryCallSettings.Builder<GetIdentityMappingStoreRequest, IdentityMappingStore> getIdentityMappingStoreSettings;
        private final UnaryCallSettings.Builder<DeleteIdentityMappingStoreRequest, Operation> deleteIdentityMappingStoreSettings;
        private final OperationCallSettings.Builder<DeleteIdentityMappingStoreRequest, Empty, DeleteIdentityMappingStoreMetadata> deleteIdentityMappingStoreOperationSettings;
        private final UnaryCallSettings.Builder<ImportIdentityMappingsRequest, Operation> importIdentityMappingsSettings;
        private final OperationCallSettings.Builder<ImportIdentityMappingsRequest, ImportIdentityMappingsResponse, IdentityMappingEntryOperationMetadata> importIdentityMappingsOperationSettings;
        private final UnaryCallSettings.Builder<PurgeIdentityMappingsRequest, Operation> purgeIdentityMappingsSettings;
        private final OperationCallSettings.Builder<PurgeIdentityMappingsRequest, Empty, IdentityMappingEntryOperationMetadata> purgeIdentityMappingsOperationSettings;
        private final PagedCallSettings.Builder<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingStoreServiceClient.ListIdentityMappingsPagedResponse> listIdentityMappingsSettings;
        private final PagedCallSettings.Builder<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStoreServiceClient.ListIdentityMappingStoresPagedResponse> listIdentityMappingStoresSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createIdentityMappingStoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIdentityMappingStoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIdentityMappingStoreSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIdentityMappingStoreOperationSettings = OperationCallSettings.newBuilder();
            this.importIdentityMappingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importIdentityMappingsOperationSettings = OperationCallSettings.newBuilder();
            this.purgeIdentityMappingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.purgeIdentityMappingsOperationSettings = OperationCallSettings.newBuilder();
            this.listIdentityMappingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_IDENTITY_MAPPINGS_PAGE_STR_FACT);
            this.listIdentityMappingStoresSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_IDENTITY_MAPPING_STORES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createIdentityMappingStoreSettings, this.getIdentityMappingStoreSettings, this.deleteIdentityMappingStoreSettings, this.importIdentityMappingsSettings, this.purgeIdentityMappingsSettings, this.listIdentityMappingsSettings, this.listIdentityMappingStoresSettings);
            Builder.initDefaults(this);
        }

        protected Builder(IdentityMappingStoreServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createIdentityMappingStoreSettings = settings.createIdentityMappingStoreSettings.toBuilder();
            this.getIdentityMappingStoreSettings = settings.getIdentityMappingStoreSettings.toBuilder();
            this.deleteIdentityMappingStoreSettings = settings.deleteIdentityMappingStoreSettings.toBuilder();
            this.deleteIdentityMappingStoreOperationSettings = settings.deleteIdentityMappingStoreOperationSettings.toBuilder();
            this.importIdentityMappingsSettings = settings.importIdentityMappingsSettings.toBuilder();
            this.importIdentityMappingsOperationSettings = settings.importIdentityMappingsOperationSettings.toBuilder();
            this.purgeIdentityMappingsSettings = settings.purgeIdentityMappingsSettings.toBuilder();
            this.purgeIdentityMappingsOperationSettings = settings.purgeIdentityMappingsOperationSettings.toBuilder();
            this.listIdentityMappingsSettings = settings.listIdentityMappingsSettings.toBuilder();
            this.listIdentityMappingStoresSettings = settings.listIdentityMappingStoresSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createIdentityMappingStoreSettings, this.getIdentityMappingStoreSettings, this.deleteIdentityMappingStoreSettings, this.importIdentityMappingsSettings, this.purgeIdentityMappingsSettings, this.listIdentityMappingsSettings, this.listIdentityMappingStoresSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IdentityMappingStoreServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IdentityMappingStoreServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IdentityMappingStoreServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IdentityMappingStoreServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)IdentityMappingStoreServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)IdentityMappingStoreServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IdentityMappingStoreServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IdentityMappingStoreServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createIdentityMappingStoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIdentityMappingStoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteIdentityMappingStoreSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.importIdentityMappingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.purgeIdentityMappingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listIdentityMappingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listIdentityMappingStoresSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteIdentityMappingStoreOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteIdentityMappingStoreMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.importIdentityMappingsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportIdentityMappingsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(IdentityMappingEntryOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.purgeIdentityMappingsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(IdentityMappingEntryOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateIdentityMappingStoreRequest, IdentityMappingStore> createIdentityMappingStoreSettings() {
            return this.createIdentityMappingStoreSettings;
        }

        public UnaryCallSettings.Builder<GetIdentityMappingStoreRequest, IdentityMappingStore> getIdentityMappingStoreSettings() {
            return this.getIdentityMappingStoreSettings;
        }

        public UnaryCallSettings.Builder<DeleteIdentityMappingStoreRequest, Operation> deleteIdentityMappingStoreSettings() {
            return this.deleteIdentityMappingStoreSettings;
        }

        public OperationCallSettings.Builder<DeleteIdentityMappingStoreRequest, Empty, DeleteIdentityMappingStoreMetadata> deleteIdentityMappingStoreOperationSettings() {
            return this.deleteIdentityMappingStoreOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportIdentityMappingsRequest, Operation> importIdentityMappingsSettings() {
            return this.importIdentityMappingsSettings;
        }

        public OperationCallSettings.Builder<ImportIdentityMappingsRequest, ImportIdentityMappingsResponse, IdentityMappingEntryOperationMetadata> importIdentityMappingsOperationSettings() {
            return this.importIdentityMappingsOperationSettings;
        }

        public UnaryCallSettings.Builder<PurgeIdentityMappingsRequest, Operation> purgeIdentityMappingsSettings() {
            return this.purgeIdentityMappingsSettings;
        }

        public OperationCallSettings.Builder<PurgeIdentityMappingsRequest, Empty, IdentityMappingEntryOperationMetadata> purgeIdentityMappingsOperationSettings() {
            return this.purgeIdentityMappingsOperationSettings;
        }

        public PagedCallSettings.Builder<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingStoreServiceClient.ListIdentityMappingsPagedResponse> listIdentityMappingsSettings() {
            return this.listIdentityMappingsSettings;
        }

        public PagedCallSettings.Builder<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStoreServiceClient.ListIdentityMappingStoresPagedResponse> listIdentityMappingStoresSettings() {
            return this.listIdentityMappingStoresSettings;
        }

        public IdentityMappingStoreServiceStubSettings build() throws IOException {
            return new IdentityMappingStoreServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

