/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.GetServingConfigRequest;
import com.google.cloud.discoveryengine.v1beta.ListServingConfigsRequest;
import com.google.cloud.discoveryengine.v1beta.ListServingConfigsResponse;
import com.google.cloud.discoveryengine.v1beta.ServingConfig;
import com.google.cloud.discoveryengine.v1beta.ServingConfigServiceClient;
import com.google.cloud.discoveryengine.v1beta.UpdateServingConfigRequest;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonServingConfigServiceCallableFactory;
import com.google.cloud.discoveryengine.v1beta.stub.ServingConfigServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.ServingConfigServiceStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonServingConfigServiceStub
extends ServingConfigServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<UpdateServingConfigRequest, ServingConfig> updateServingConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.ServingConfigService/UpdateServingConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{servingConfig.name=projects/*/locations/*/dataStores/*/servingConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "servingConfig.name", (Object)request.getServingConfig().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{servingConfig.name=projects/*/locations/*/collections/*/dataStores/*/servingConfigs/*}", "/v1beta/{servingConfig.name=projects/*/locations/*/collections/*/engines/*/servingConfigs/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("servingConfig", (Message)request.getServingConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ServingConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetServingConfigRequest, ServingConfig> getServingConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.ServingConfigService/GetServingConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/dataStores/*/servingConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/servingConfigs/*}", "/v1beta/{name=projects/*/locations/*/collections/*/engines/*/servingConfigs/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ServingConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListServingConfigsRequest, ListServingConfigsResponse> listServingConfigsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.ServingConfigService/ListServingConfigs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*/dataStores/*}/servingConfigs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{parent=projects/*/locations/*/collections/*/dataStores/*}/servingConfigs", "/v1beta/{parent=projects/*/locations/*/collections/*/engines/*}/servingConfigs"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListServingConfigsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<UpdateServingConfigRequest, ServingConfig> updateServingConfigCallable;
    private final UnaryCallable<GetServingConfigRequest, ServingConfig> getServingConfigCallable;
    private final UnaryCallable<ListServingConfigsRequest, ListServingConfigsResponse> listServingConfigsCallable;
    private final UnaryCallable<ListServingConfigsRequest, ServingConfigServiceClient.ListServingConfigsPagedResponse> listServingConfigsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonServingConfigServiceStub create(ServingConfigServiceStubSettings settings) throws IOException {
        return new HttpJsonServingConfigServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonServingConfigServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonServingConfigServiceStub(ServingConfigServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonServingConfigServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonServingConfigServiceStub(ServingConfigServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonServingConfigServiceStub(ServingConfigServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonServingConfigServiceCallableFactory());
    }

    protected HttpJsonServingConfigServiceStub(ServingConfigServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings updateServingConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateServingConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("serving_config.name", String.valueOf(request.getServingConfig().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getServingConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getServingConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listServingConfigsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listServingConfigsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.updateServingConfigCallable = callableFactory.createUnaryCallable(updateServingConfigTransportSettings, settings.updateServingConfigSettings(), clientContext);
        this.getServingConfigCallable = callableFactory.createUnaryCallable(getServingConfigTransportSettings, settings.getServingConfigSettings(), clientContext);
        this.listServingConfigsCallable = callableFactory.createUnaryCallable(listServingConfigsTransportSettings, settings.listServingConfigsSettings(), clientContext);
        this.listServingConfigsPagedCallable = callableFactory.createPagedCallable(listServingConfigsTransportSettings, settings.listServingConfigsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(updateServingConfigMethodDescriptor);
        methodDescriptors.add(getServingConfigMethodDescriptor);
        methodDescriptors.add(listServingConfigsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<UpdateServingConfigRequest, ServingConfig> updateServingConfigCallable() {
        return this.updateServingConfigCallable;
    }

    @Override
    public UnaryCallable<GetServingConfigRequest, ServingConfig> getServingConfigCallable() {
        return this.getServingConfigCallable;
    }

    @Override
    public UnaryCallable<ListServingConfigsRequest, ListServingConfigsResponse> listServingConfigsCallable() {
        return this.listServingConfigsCallable;
    }

    @Override
    public UnaryCallable<ListServingConfigsRequest, ServingConfigServiceClient.ListServingConfigsPagedResponse> listServingConfigsPagedCallable() {
        return this.listServingConfigsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

