/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.ConversationDataset;
import com.google.cloud.dialogflow.v2.ConversationDatasetName;
import com.google.cloud.dialogflow.v2.ConversationDatasetsSettings;
import com.google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata;
import com.google.cloud.dialogflow.v2.CreateConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata;
import com.google.cloud.dialogflow.v2.DeleteConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.GetConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata;
import com.google.cloud.dialogflow.v2.ImportConversationDataOperationResponse;
import com.google.cloud.dialogflow.v2.ImportConversationDataRequest;
import com.google.cloud.dialogflow.v2.ListConversationDatasetsRequest;
import com.google.cloud.dialogflow.v2.ListConversationDatasetsResponse;
import com.google.cloud.dialogflow.v2.LocationName;
import com.google.cloud.dialogflow.v2.stub.ConversationDatasetsStub;
import com.google.cloud.dialogflow.v2.stub.ConversationDatasetsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ConversationDatasetsClient
implements BackgroundResource {
    private final ConversationDatasetsSettings settings;
    private final ConversationDatasetsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ConversationDatasetsClient create() throws IOException {
        return ConversationDatasetsClient.create(ConversationDatasetsSettings.newBuilder().build());
    }

    public static final ConversationDatasetsClient create(ConversationDatasetsSettings settings) throws IOException {
        return new ConversationDatasetsClient(settings);
    }

    public static final ConversationDatasetsClient create(ConversationDatasetsStub stub) {
        return new ConversationDatasetsClient(stub);
    }

    protected ConversationDatasetsClient(ConversationDatasetsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversationDatasetsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ConversationDatasetsClient(ConversationDatasetsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ConversationDatasetsSettings getSettings() {
        return this.settings;
    }

    public ConversationDatasetsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetAsync(String parent, ConversationDataset conversationDataset) {
        CreateConversationDatasetRequest request = CreateConversationDatasetRequest.newBuilder().setParent(parent).setConversationDataset(conversationDataset).build();
        return this.createConversationDatasetAsync(request);
    }

    public final OperationFuture<ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetAsync(CreateConversationDatasetRequest request) {
        return this.createConversationDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConversationDatasetRequest, ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetOperationCallable() {
        return this.stub.createConversationDatasetOperationCallable();
    }

    public final UnaryCallable<CreateConversationDatasetRequest, Operation> createConversationDatasetCallable() {
        return this.stub.createConversationDatasetCallable();
    }

    public final ConversationDataset getConversationDataset(ConversationDatasetName name) {
        GetConversationDatasetRequest request = GetConversationDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConversationDataset(request);
    }

    public final ConversationDataset getConversationDataset(String name) {
        GetConversationDatasetRequest request = GetConversationDatasetRequest.newBuilder().setName(name).build();
        return this.getConversationDataset(request);
    }

    public final ConversationDataset getConversationDataset(GetConversationDatasetRequest request) {
        return (ConversationDataset)this.getConversationDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetCallable() {
        return this.stub.getConversationDatasetCallable();
    }

    public final ListConversationDatasetsPagedResponse listConversationDatasets(LocationName parent) {
        ListConversationDatasetsRequest request = ListConversationDatasetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversationDatasets(request);
    }

    public final ListConversationDatasetsPagedResponse listConversationDatasets(String parent) {
        ListConversationDatasetsRequest request = ListConversationDatasetsRequest.newBuilder().setParent(parent).build();
        return this.listConversationDatasets(request);
    }

    public final ListConversationDatasetsPagedResponse listConversationDatasets(ListConversationDatasetsRequest request) {
        return (ListConversationDatasetsPagedResponse)((Object)this.listConversationDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversationDatasetsRequest, ListConversationDatasetsPagedResponse> listConversationDatasetsPagedCallable() {
        return this.stub.listConversationDatasetsPagedCallable();
    }

    public final UnaryCallable<ListConversationDatasetsRequest, ListConversationDatasetsResponse> listConversationDatasetsCallable() {
        return this.stub.listConversationDatasetsCallable();
    }

    public final OperationFuture<Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetAsync(ConversationDatasetName name) {
        DeleteConversationDatasetRequest request = DeleteConversationDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteConversationDatasetAsync(request);
    }

    public final OperationFuture<Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetAsync(String name) {
        DeleteConversationDatasetRequest request = DeleteConversationDatasetRequest.newBuilder().setName(name).build();
        return this.deleteConversationDatasetAsync(request);
    }

    public final OperationFuture<Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetAsync(DeleteConversationDatasetRequest request) {
        return this.deleteConversationDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConversationDatasetRequest, Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetOperationCallable() {
        return this.stub.deleteConversationDatasetOperationCallable();
    }

    public final UnaryCallable<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetCallable() {
        return this.stub.deleteConversationDatasetCallable();
    }

    public final OperationFuture<ImportConversationDataOperationResponse, ImportConversationDataOperationMetadata> importConversationDataAsync(ImportConversationDataRequest request) {
        return this.importConversationDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportConversationDataRequest, ImportConversationDataOperationResponse, ImportConversationDataOperationMetadata> importConversationDataOperationCallable() {
        return this.stub.importConversationDataOperationCallable();
    }

    public final UnaryCallable<ImportConversationDataRequest, Operation> importConversationDataCallable() {
        return this.stub.importConversationDataCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConversationDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDataset, ListConversationDatasetsPage, ListConversationDatasetsFixedSizeCollection> {
        private ListConversationDatasetsFixedSizeCollection(List<ListConversationDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversationDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListConversationDatasetsFixedSizeCollection(null, 0);
        }

        protected ListConversationDatasetsFixedSizeCollection createCollection(List<ListConversationDatasetsPage> pages, int collectionSize) {
            return new ListConversationDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversationDatasetsPage
    extends AbstractPage<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDataset, ListConversationDatasetsPage> {
        private ListConversationDatasetsPage(PageContext<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDataset> context, ListConversationDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListConversationDatasetsPage createEmptyPage() {
            return new ListConversationDatasetsPage(null, null);
        }

        protected ListConversationDatasetsPage createPage(PageContext<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDataset> context, ListConversationDatasetsResponse response) {
            return new ListConversationDatasetsPage(context, response);
        }

        public ApiFuture<ListConversationDatasetsPage> createPageAsync(PageContext<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDataset> context, ApiFuture<ListConversationDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversationDatasetsPagedResponse
    extends AbstractPagedListResponse<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDataset, ListConversationDatasetsPage, ListConversationDatasetsFixedSizeCollection> {
        public static ApiFuture<ListConversationDatasetsPagedResponse> createAsync(PageContext<ListConversationDatasetsRequest, ListConversationDatasetsResponse, ConversationDataset> context, ApiFuture<ListConversationDatasetsResponse> futureResponse) {
            ApiFuture<ListConversationDatasetsPage> futurePage = ListConversationDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversationDatasetsPagedResponse((ListConversationDatasetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversationDatasetsPagedResponse(ListConversationDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversationDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

