/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.stub.readrows.StateMachine;
import com.google.cloud.bigtable.gaxx.reframing.Reframer;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Queue;

@InternalApi
public class RowMerger<RowT>
implements Reframer<RowT, ReadRowsResponse> {
    private final StateMachine<RowT> stateMachine;
    private Queue<RowT> mergedRows;

    public RowMerger(RowAdapter.RowBuilder<RowT> rowBuilder) {
        this.stateMachine = new StateMachine<RowT>(rowBuilder);
        this.mergedRows = new ArrayDeque<RowT>();
    }

    @Override
    public void push(ReadRowsResponse response) {
        if (!response.getLastScannedRowKey().isEmpty()) {
            this.stateMachine.handleLastScannedRow(response.getLastScannedRowKey());
            if (this.stateMachine.hasCompleteRow()) {
                this.mergedRows.add(this.stateMachine.consumeRow());
            }
        }
        for (ReadRowsResponse.CellChunk cellChunk : response.getChunksList()) {
            this.stateMachine.handleChunk(cellChunk);
            if (!this.stateMachine.hasCompleteRow()) continue;
            this.mergedRows.add(this.stateMachine.consumeRow());
        }
    }

    @Override
    public boolean hasFullFrame() {
        return !this.mergedRows.isEmpty();
    }

    @Override
    public boolean hasPartialFrame() {
        return this.hasFullFrame() || this.stateMachine.isRowInProgress();
    }

    @Override
    public RowT pop() {
        return (RowT)Preconditions.checkNotNull(this.mergedRows.poll(), (Object)"RowMerger.pop() called when there are no rows");
    }
}

